/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.isom.BEntsecISOMServlet;
import com.tridiumx.entsec.roles.BEntsecRole;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import java.util.logging.Level;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryService;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.web.BWebService;

public abstract class AccessControlServiceUpgrade {
    public static final Version SECURITY_2_0_50_1 = new Version("2.0.50.1");
    public static final Version SECURITY_2_0_50 = new Version("2.0.50");
    public static final Version SECURITY_2_0_23 = new Version("2.0.23");
    public static final Version SECURITY_2_2_1 = new Version("2.2.1");
    public static final Version SECURITY_2_2_9_1 = new Version("2.2.9.1");
    public static final Version SECURITY_2_1_9 = new Version("2.1.9");
    public static final Version SECURITY_2_2_8_9 = new Version("2.2.8.9");
    public static final Version SECURITY_2_2_8_14 = new Version("2.2.8.14");
    public static final Version SECURITY_2_3_17 = new Version("2.3.17");
    public static final Version SECURITY_2_3_111 = new Version("2.3.111");

    public static void upgrade(BAccessControlService service, Version oldVersion, Version newVersion) throws Exception {
        if (SECURITY_2_0_50.compareTo(oldVersion) > 0) {
            int i;
            BAccessControlService.LOG.info("Starting Access Control Service Upgrade from " + oldVersion + " to " + SECURITY_2_0_50 + " ...");
            BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
            BEntsecRole[] roles = (BEntsecRole[])roleService.getChildren(BEntsecRole.class);
            BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            BCategory[] categories = (BCategory[])catService.getChildren(BCategory.class);
            int maxIndex = 0;
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getIndex() <= maxIndex) continue;
                maxIndex = categories[i].getIndex();
            }
            for (i = 0; i < roles.length; ++i) {
                BPermissionsMap map = roles[i].getPermissions();
                BEntsecRole role = roles[i];
                if (map.isSuperUser()) continue;
                role.setPermissions(AccessControlServiceUpgrade.getUpgradedPermissionsMap(map, categories, catService, maxIndex));
            }
            service.setSoftwareVersion(SECURITY_2_0_50.toString());
            BAccessControlService.LOG.info("Upgrade from " + oldVersion + " to " + SECURITY_2_0_50 + " complete.");
        }
        if (SECURITY_2_0_50_1.compareTo(oldVersion) > 0) {
            BogCursor c = new BogCursor((BComplex)Sys.getStation(), 1000, new Type[]{BQuery.TYPE, BDynamicTable.TYPE}, false, null);
            while (c.next()) {
                BQuery query;
                BProjection projection;
                BComponent component = (BComponent)c.get();
                if (component instanceof BDynamicTable) {
                    BDynamicTable dt = (BDynamicTable)component;
                    try {
                        dt.setColumns(dt.getDefaultColumns());
                    }
                    catch (Exception e) {
                        BAccessControlService.LOG.log(Level.INFO, "Cannot reset Columns for " + dt.getType() + "-" + dt.getSlotPath(), e);
                    }
                    continue;
                }
                if (!(component instanceof BQuery) || (projection = (query = (BQuery)component).getProjection()) == null || projection.getPropertyInParent().isFrozen()) continue;
                query.remove("projection");
            }
            service.setSoftwareVersion(SECURITY_2_0_50_1.toString());
            BAccessControlService.LOG.info("Upgrade from " + SECURITY_2_0_50 + " to " + SECURITY_2_0_50_1 + " complete.");
        }
        if (SECURITY_2_2_9_1.compareTo(oldVersion) > 0) {
            int renameIndex = 0;
            BogCursor c = new BogCursor((BComplex)Sys.getStation(), 1000, new Type[]{BThreatLevelGroup.TYPE}, false, null);
            while (c.next()) {
                String path = null;
                try {
                    BThreatLevelGroup group = (BThreatLevelGroup)c.get();
                    BThreatLevelGroupRec rec = new BThreatLevelGroupRec();
                    rec.mapFrom((BObject)group);
                    path = rec.getPath();
                    if (path.length() <= BThreatLevelGroupRec.MAX_PATH_LENGTH) continue;
                    String newName = "renamed_" + renameIndex;
                    String newParentName = "renamed_" + ++renameIndex;
                    ++renameIndex;
                    group.getParent().asComponent().rename(group.getPropertyInParent(), newName);
                    if (group.getParent() instanceof BThreatLevelGroup) {
                        group.getParent().getParent().asComponent().rename(group.getParent().getPropertyInParent(), newParentName);
                    }
                    BAccessControlService.LOG.warning("Threat Level Group Path too long, shortening last two names for Threat Level's with path from '" + path + "' to '" + newParentName + "/" + newName + "'.");
                }
                catch (Exception e) {
                    BAccessControlService.LOG.log(Level.SEVERE, "Threat Level Group Path too long, please fix this path manually before Threat Level Group can work properly: " + path, e);
                }
            }
            service.setSoftwareVersion(SECURITY_2_2_9_1.toString());
            Version myVersion = oldVersion;
            if (oldVersion.compareTo(SECURITY_2_0_50_1) < -1) {
                myVersion = SECURITY_2_0_50_1;
            }
            BAccessControlService.LOG.info(" Upgrade from " + myVersion + " to " + SECURITY_2_2_9_1 + " complete.");
        }
        if (SECURITY_2_3_111.compareTo(oldVersion) > 0) {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            if (webService.get("EntsecISOMServlet") == null) {
                BEntsecISOMServlet entsecISOMServlet = new BEntsecISOMServlet();
                entsecISOMServlet.setEnabled(true);
                webService.add(null, (BValue)entsecISOMServlet);
            }
            BAccessControlService.LOG.info("Upgrade from " + oldVersion + " to " + SECURITY_2_3_111 + " complete.");
        }
        service.setSoftwareVersion(BAccessControlService.CURRENT_SOFTWARE_VERSION.toString());
    }

    public static void addCategoryToRole(BCategory c, BPermissions permissions, BEntsecRole role) throws Exception {
        if (role == null || role.getPermissions().isSuperUser()) {
            return;
        }
        BPermissionsMap map = role.getPermissions();
        String encoded = map.encodeToString();
        if (encoded.length() > 0) {
            encoded = encoded + ";";
        }
        encoded = encoded + c.getIndex() + "=" + permissions.encodeToString();
        map = (BPermissionsMap)map.decodeFromString(encoded);
        role.setPermissions(map);
    }

    public static BPermissionsMap getUpgradedPermissionsMap(BPermissionsMap map, BCategory[] categories, BCategoryService catService, int maxIndex) {
        BPermissions[] permissionList = new BPermissions[maxIndex + 1];
        for (int i = 0; i < categories.length; ++i) {
            BPermissions permissions = map.getPermissions(categories[i].getIndex());
            if (Flags.isUserDefined1((BComplex)catService, (Slot)categories[i].getPropertyInParent()) && !permissions.hasAdminRead() && !permissions.hasAdminWrite() && !permissions.hasAdminInvoke()) {
                permissions = BPermissions.none;
            }
            permissionList[categories[i].getIndex()] = permissions;
        }
        return BPermissionsMap.make((BPermissions[])permissionList);
    }
}

