/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.BEntsecUserPermissionsInfo;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.app.EntsecAppUtil;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.roles.BEntsecRole;
import com.tridiumx.entsec.user.BEntsecUserConfig;
import com.tridiumx.entsec.user.BIEntsecProfile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.role.BIRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.web.BWebProfileConfig;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class UserPermissionsCodec {
    private boolean newCategory = false;
    private HashMap categories;
    private HashMap users;
    private HashMap roles;
    private HashMap componentMasks;
    private HashMap ordListMasks;
    private OrionSpaceElem orionSpaceElem;
    private BEntsecUserPermissionsInfo info;
    private Version version;
    private static BCategoryMask cat1 = BCategoryMask.make((String)"1");

    public UserPermissionsCodec(BEntsecUserPermissionsInfo info) {
        this.info = info;
        this.version = new Version(((BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE)).getSoftwareVersion());
    }

    public void clear(Context cx) throws Exception {
        if (this.info.getCategorizations()) {
            this.clearMasks(cx);
        }
        if (this.info.getCategories()) {
            this.clearCategories(cx);
        }
        if (this.info.getRoles()) {
            this.clearRoles(cx);
        }
        if (this.info.getUsers()) {
            this.clearUsers(cx);
        }
    }

    public void clearCategories(Context cx) throws Exception {
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        Array deleteCats = new Array(Property.class, catService.getSlotCount());
        SlotCursor c = catService.getProperties();
        while (c.next(BCategory.class)) {
            Property prop = c.property();
            if (!Flags.isUserDefined1((BComplex)catService, (Slot)prop)) continue;
            deleteCats.add((Object)prop);
        }
        for (Property prop : deleteCats) {
            catService.remove(prop);
        }
    }

    public void clearMasks(Context cx) throws Exception {
        BLocalHost root = BLocalHost.INSTANCE;
        BINavNode[] children = root.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BOrionSpace) {
                this.clearOrionMasks((BOrionSpace)children[i], cx);
                continue;
            }
            if (children[i] instanceof BFileSpace) {
                this.clearFileMasks((BFileSpace)children[i], cx);
                continue;
            }
            if (children[i] instanceof BHistorySpace) {
                this.clearHistoryMasks((BHistorySpace)children[i], cx);
                continue;
            }
            if (!(children[i] instanceof BComponentSpace)) continue;
            this.clearComponentMasks((BComponentSpace)children[i], cx);
        }
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        catService.setOrdMap(BOrdToCategoryMap.DEFAULT);
    }

    public void clearComponentMasks(BComponentSpace space, Context cx) throws Exception {
        BOrd query = BOrd.make((String)"bql: select from baja:Component");
        try (TableCursor components = ((BITable)query.resolve((BObject)space.getRootComponent()).get()).cursor();){
            while (components.next()) {
                BComponent c = (BComponent)components.get();
                if (c == space.getRootComponent()) {
                    c.setCategoryMask(cat1, cx);
                    continue;
                }
                if (c.getCategoryMask() == BCategoryMask.NULL) continue;
                c.setCategoryMask(BCategoryMask.NULL, cx);
            }
        }
        Sys.getStation().setCategoryMask(cat1, cx);
        space.getRootComponent().setCategoryMask(cat1, cx);
    }

    public void clearOrionMasks(BOrionSpace space, Context cx) throws Exception {
        BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        space.getRootComponent().setCategoryMask(cat1, cx);
        BOrionDatabase[] dbs = space.getOrionDatabases();
        for (int i = 0; i < dbs.length; ++i) {
            this.clearOrionDatabase(dbs[i], cx);
        }
        orionService.setOrdMap(BOrdToCategoryMap.DEFAULT);
    }

    public void clearOrionDatabase(BOrionDatabase db, Context cx) throws Exception {
        db.setCategoryMask(BCategoryMask.NULL, cx);
        BOrionModule[] modules = db.getModules();
        for (int m = 0; m < modules.length; ++m) {
            modules[m].setCategoryMask(BCategoryMask.NULL, cx);
            BOrionType[] types = modules[m].getTypes();
            for (int t = 0; t < types.length; ++t) {
                types[t].setCategoryMask(BCategoryMask.NULL, cx);
            }
        }
    }

    public void clearFileMasks(BFileSpace fileSpace, Context cx) {
    }

    public void clearHistoryMasks(BHistorySpace historySpace, Context cx) {
    }

    public void clearRoles(Context cx) {
        BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
        List rolesList = roleService.getRoleIds();
        if (rolesList != null && rolesList.size() > 0) {
            roleService.removeAll(cx);
        }
    }

    public void clearUsers(Context cx) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser[] users = (BUser[])userService.getChildren(BUser.class);
        for (int i = 0; i < users.length; ++i) {
            Property p = users[i].getPropertyInParent();
            BWebProfileConfig webConfig = (BWebProfileConfig)users[i].getMixIn(BWebProfileConfig.TYPE);
            if (!webConfig.getTypeSpec().getResolvedType().is(BIEntsecProfile.TYPE)) continue;
            if (p.isFrozen() || p.getName().equals("BACnet")) {
                BUser user = users[i];
                user.setRoles(user.getRoles().toString());
                continue;
            }
            userService.remove(p);
        }
    }

    public void save(OutputStream out) throws Exception {
        XWriter xout = new XWriter(out);
        xout.prolog();
        xout.w((Object)"<root>").nl();
        if (this.info.getCategories()) {
            this.saveCategories(xout, 2);
        }
        if (this.info.getCategorizations()) {
            this.saveMasks(xout, 2);
        }
        if (this.info.getRoles()) {
            this.saveRoles(xout, 2);
        }
        if (this.info.getUsers()) {
            this.saveUsers(xout, 2);
        }
        xout.w((Object)"</root>").nl();
        xout.flush();
    }

    public void saveCategories(XWriter out, int indent) throws Exception {
        out.indent(indent).w((Object)"<categories>").nl();
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BNameMap displayNames = (BNameMap)catService.get("displayNames");
        SlotCursor c = catService.getProperties();
        while (c.next(BCategory.class)) {
            BFormat displayFormat;
            BCategory cat = (BCategory)c.get();
            out.indent(indent + 2).w((Object)"<category ");
            out.attr("name", cat.getName()).w((Object)" ");
            if (displayNames != null && (displayFormat = displayNames.get(cat.getName())) != null) {
                out.attr("display", displayFormat.encodeToString()).w((Object)" ");
            }
            out.w((Object)"/>").nl();
        }
        out.indent(indent).w((Object)"</categories>").nl();
    }

    public void saveMasks(XWriter out, int indent) throws Exception {
        out.indent(indent).w((Object)"<masks>").nl();
        BLocalHost root = BLocalHost.INSTANCE;
        BINavNode[] children = root.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BOrionSpace) {
                this.saveOrionMasks(out, (BOrionSpace)children[i], indent + 2);
                continue;
            }
            if (children[i] instanceof BFileSpace) {
                this.saveFileMasks(out, (BFileSpace)children[i], indent + 2);
                continue;
            }
            if (children[i] instanceof BHistorySpace) {
                this.saveHistoryMasks(out, (BHistorySpace)children[i], indent + 2);
                continue;
            }
            if (!(children[i] instanceof BComponentSpace)) continue;
            this.saveComponentMasks(out, (BComponentSpace)children[i], indent + 2);
        }
        this.saveOrdMap(out, indent + 2);
        out.indent(indent).w((Object)"</masks>").nl();
    }

    public void saveComponentMasks(XWriter out, BComponentSpace space, int indent) throws Exception {
        out.indent(indent).w((Object)"<components>").nl();
        BOrd query = BOrd.make((String)"bql: select from baja:Component");
        try (TableCursor components = ((BITable)query.resolve((BObject)space.getRootComponent()).get()).cursor();){
            while (components.next()) {
                BComponent c = (BComponent)components.get();
                BCategoryMask mask = c.getCategoryMask();
                if (mask == BCategoryMask.DEFAULT) continue;
                BOrd ord = this.getOrd(c);
                out.indent(indent + 2).w((Object)"<component ");
                out.attr("ord", ord.encodeToString()).w((Object)" ");
                out.attr("mask", this.encodeMask(mask));
                out.w((Object)" />").nl();
            }
        }
        out.indent(indent).w((Object)"</components>").nl();
    }

    public void saveRoles(XWriter out, int indent) throws Exception {
        out.indent(indent).w((Object)"<roles>").nl();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
        BIRole[] roles = (BIRole[])roleService.getChildren(BIRole.class);
        BNameMap displayNames = (BNameMap)roleService.get("displayNames");
        for (BIRole biRole : roles) {
            BPermissionsMap map;
            BFormat displayFormat;
            BEntsecRole role = (BEntsecRole)biRole;
            out.indent(indent + 2).w((Object)"<role ");
            out.attr("name", role.getName()).w((Object)" ");
            if (displayNames != null && (displayFormat = displayNames.get(role.getName())) != null) {
                out.attr("display", displayFormat.encodeToString()).w((Object)" ");
            }
            if ((map = role.getPermissions()).isSuperUser()) {
                out.attr("permissionsMap", map.encodeToString()).w((Object)" ");
                out.w((Object)"/>").nl();
                continue;
            }
            out.w((Object)">").nl();
            SlotCursor cc = catService.getProperties();
            while (cc.next(BCategory.class) && !map.isSuperUser()) {
                BCategory category = (BCategory)cc.get();
                int index = category.getIndex();
                BPermissions permissions = map.getPermissions(index);
                if (permissions.equals((Object)BPermissions.none)) continue;
                out.indent(indent + 4).w((Object)"<category ");
                out.attr("name", category.getName()).w((Object)" ");
                out.attr("permissions", permissions.encodeToString()).w((Object)" ");
                out.indent(indent + 4).w((Object)"/>").nl();
            }
            out.indent(indent + 2).w((Object)"</role>").nl();
        }
        out.indent(indent).w((Object)"</roles>").nl();
    }

    public void saveUsers(XWriter out, int indent) throws Exception {
        out.indent(indent).w((Object)"<users>").nl();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        SlotCursor c = userService.getProperties();
        while (c.next(BUser.class)) {
            BUser user = (BUser)c.get();
            BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
            String roles = user.getRoles();
            if (roles.length() == 0) continue;
            out.indent(indent + 2).w((Object)"<user ");
            out.attr("name", user.getUsername()).w((Object)" ");
            out.attr("roles", roles).w((Object)" ");
            out.w((Object)"/>").nl();
        }
        out.indent(indent).w((Object)"</users>").nl();
    }

    public BOrd getOrd(BComponent component) {
        BComponent service;
        for (service = component; service != null && !(service instanceof BIService); service = (BComponent)service.getParent()) {
        }
        if (service == null) {
            return component.getSlotPathOrd();
        }
        BOrd serviceOrd = BOrd.make((String)("service:" + service.getType().getTypeSpec().toString()));
        if (service == component) {
            return serviceOrd;
        }
        String serviceSlotPath = service.getSlotPath().toString();
        String componentSlotPath = component.getSlotPath().toString();
        SlotPath relPath = new SlotPath(componentSlotPath.substring(serviceSlotPath.length() + 1));
        return BOrd.make((BOrd)serviceOrd, (OrdQuery)relPath);
    }

    public void saveOrionMasks(XWriter out, BOrionSpace space, int indent) throws Exception {
        out.indent(indent).w((Object)"<orion ").attr("mask", this.encodeMask(space.getCategoryMask())).w((Object)">").nl();
        BOrionDatabase appDb = this.getAppDb();
        BOrionDatabase[] dbs = space.getOrionDatabases();
        for (int i = 0; i < dbs.length; ++i) {
            String dbId = dbs[i].getId();
            if (dbs[i] == appDb) {
                dbId = "_app_";
            }
            out.indent(indent + 2).w((Object)"<databases>").nl();
            this.saveOrionDatabase(out, dbs[i], dbId, indent + 4);
            out.indent(indent + 2).w((Object)"</databases>").nl();
        }
        out.indent(indent).w((Object)"</orion>").nl();
    }

    private BOrionDatabase getAppDb() {
        Array appDbs = new Array(BRdbms.class, 1);
        this.addDb(appDbs, BEnterpriseSecurityService.TYPE);
        this.addDb(appDbs, BAccessControlService.TYPE);
        this.addDb(appDbs, BIntrusionService.TYPE);
        if (appDbs.size() > 1) {
            throw new IllegalStateException("Security application must use a single database.");
        }
        if (appDbs.size() == 1) {
            BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase db = orionService.getOrionDatabase((BRdbms)appDbs.get(0));
            return db;
        }
        return null;
    }

    private void addDb(Array dbs, Type appType) {
        BComponent app = null;
        try {
            app = Sys.getService((Type)appType);
        }
        catch (ServiceNotFoundException ex) {
            return;
        }
        BOrd dbOrd = null;
        try {
            BRdbms db;
            Property dbOrdProp = app.getProperty("dbOrd");
            if (dbOrdProp != null && !dbs.contains((Object)(db = (BRdbms)(dbOrd = (BOrd)app.get(dbOrdProp)).resolve((BObject)Sys.getStation()).get()))) {
                dbs.add((Object)db);
            }
        }
        catch (Exception ex) {
            System.out.println("db undefined for " + app + " -> " + dbOrd);
            ex.printStackTrace();
        }
    }

    public void saveOrionDatabase(XWriter out, BOrionDatabase db, String dbId, int indent) throws Exception {
        out.indent(indent).w((Object)"<db ").attr("id", dbId).w((Object)" ");
        out.attr("mask", this.encodeMask(db.getCategoryMask())).w((Object)">").nl();
        BOrionModule[] modules = db.getModules();
        for (int m = 0; m < modules.length; ++m) {
            out.indent(indent + 2).w((Object)"<module ");
            out.attr("name", modules[m].getName()).w((Object)" ");
            out.attr("mask", this.encodeMask(modules[m].getCategoryMask()));
            out.w((Object)">").nl();
            BOrionType[] types = modules[m].getTypes();
            for (int t = 0; t < types.length; ++t) {
                out.indent(indent + 4).w((Object)"<type ");
                out.attr("typeSpec", types[t].getOrionType().getTypeSpec().encodeToString()).w((Object)" ");
                out.attr("mask", this.encodeMask(types[t].getCategoryMask()));
                out.w((Object)" />").nl();
            }
            out.indent(indent + 2).w((Object)"</module>").nl();
        }
        out.indent(indent).w((Object)"</db>").nl();
    }

    public void saveFileMasks(XWriter out, BFileSpace space, int indent) {
    }

    public void saveHistoryMasks(XWriter out, BHistorySpace space, int indent) {
    }

    public void saveOrdMap(XWriter out, int indent) {
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BOrdToCategoryMap catMap = catService.getOrdMap();
        out.indent(indent).w((Object)"<ordMap>").nl();
        int size = catMap.size();
        for (int i = 0; i < size; ++i) {
            HistoryQuery hq;
            BOrd ord = catMap.getOrd(i);
            OrdQuery[] queries = ord.parse();
            if (queries.length > 0 && queries[0] instanceof HistoryQuery && ((hq = (HistoryQuery)queries[0]).isDeviceQuery() || hq.isHistoryQuery())) {
                if (hq.getDeviceName().equals(Sys.getStation().getStationName())) {
                    if (hq.isHistoryQuery()) {
                        queries[0] = new HistoryQuery("^" + hq.getHistoryName());
                    } else if (hq.isDeviceQuery()) {
                        queries[0] = new HistoryQuery("^");
                    }
                }
                ord = BOrd.make((OrdQuery[])queries);
            }
            out.indent(indent + 2).w((Object)"<entry ");
            out.attr("ord", ord.encodeToString()).w((Object)" ");
            out.attr("mask", this.encodeMask(catMap.getCategoryMask(i))).w((Object)" ");
            out.w((Object)"/>").nl();
        }
        out.indent(indent).w((Object)"</ordMap>").nl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in, Context cx) throws Exception {
        this.initLoad();
        try {
            XParser parser = XParser.make((InputStream)in);
            int elemType = parser.next();
            if (elemType == -1) {
                throw new IllegalStateException("Expecting start of root element.");
            }
            this.parseRoot(parser, cx);
            this.enforceLoad(cx);
        }
        finally {
            this.finalizeLoad();
        }
    }

    public void initLoad() {
        this.newCategory = false;
        this.categories = new LinkedHashMap();
        this.users = new LinkedHashMap();
        this.roles = new LinkedHashMap();
        this.componentMasks = new LinkedHashMap();
        this.ordListMasks = new LinkedHashMap();
    }

    public void finalizeLoad() {
        this.newCategory = false;
        this.categories = null;
        this.users = null;
        this.roles = null;
        this.componentMasks = null;
        this.ordListMasks = null;
        this.orionSpaceElem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BOrdList ordList, Context cx) throws Exception {
        this.initLoad();
        try {
            for (int i = 0; i < ordList.size(); ++i) {
                BIFile file = (BIFile)ordList.get(i).get();
                try (InputStream in = file.getInputStream();){
                    XParser parser = XParser.make((InputStream)in);
                    int elemType = parser.next();
                    if (elemType == -1) {
                        throw new IllegalStateException("Expecting start of root element.");
                    }
                    this.parseRoot(parser, cx);
                    continue;
                }
            }
            this.enforceLoad(cx);
        }
        finally {
            this.finalizeLoad();
        }
    }

    public void enforceLoad(Context cx) throws Exception {
        if (this.info.getCategories()) {
            this.enforceCategories(cx);
        }
        if (this.info.getCategorizations()) {
            this.enforceMasks(cx);
        }
        this.enforceRoles(cx);
        if (this.info.getUsers()) {
            this.enforceUsers(cx);
        }
    }

    public void enforceMasks(Context cx) throws Exception {
        if (this.info.getCategories()) {
            this.enforceComponents(cx);
        }
        if (this.orionSpaceElem != null) {
            this.enforceOrion(cx);
        }
        if (this.ordListMasks != null) {
            this.enforceOrdMap(cx);
        }
    }

    public void parseRoot(XParser parser, Context cx) throws Exception {
        XElem root = this.match(parser, 1, "root");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("categories") && this.info.getCategories()) {
                    this.parseCategories(parser, cx);
                } else if (name.equals("masks")) {
                    this.parseMasks(parser, cx);
                } else if (name.equals("roles")) {
                    this.parseRoles(parser, cx);
                } else if (name.equals("users") && this.info.getUsers()) {
                    this.parseUsers(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem rootEnd = this.match(parser, 2, "root");
    }

    public void enforceCategories(Context cx) throws Exception {
        Iterator i = this.categories.values().iterator();
        while (i.hasNext()) {
            this.enforceCategory((CategoryElem)i.next(), cx);
        }
    }

    public void enforceUsers(Context cx) throws Exception {
        Iterator i = this.users.values().iterator();
        while (i.hasNext()) {
            this.enforceUser((UserElem)i.next(), cx);
        }
    }

    public void enforceRoles(Context cx) throws Exception {
        Iterator i = this.roles.values().iterator();
        while (i.hasNext()) {
            this.enforceRole((RoleElem)i.next(), cx);
        }
    }

    public void parseCategories(XParser parser, Context cx) throws Exception {
        XElem root = this.match(parser, 1, "categories");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("category")) {
                    this.parseCategory(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem rootEnd = this.match(parser, 2, "categories");
    }

    public void parseCategory(XParser parser, Context cx) throws Exception {
        XElem catElem = this.match(parser, 1, "category");
        String name = catElem.get("name", null);
        if (name == null) {
            throw new IllegalStateException("'name' attribute required for category.");
        }
        CategoryElem parse = new CategoryElem();
        parse.name = name;
        parse.display = catElem.get("display", null);
        this.categories.put(name, parse);
        XElem catEnd = this.match(parser, 2, "category");
    }

    public void enforceCategory(CategoryElem categoryElem, Context cx) {
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BCategory existing = (BCategory)catService.get(categoryElem.name);
        if (existing == null) {
            BCategory newCat = new BCategory();
            newCat.setIndex(this.getMaxCategoryIndex(catService) + 1);
            catService.add(categoryElem.name, (BValue)newCat, 0x10000000);
            categoryElem.newCategory = true;
            this.newCategory = true;
            if (!this.info.getRoles()) {
                BEnterpriseSecurityService.LOG.info("New Category Detected: " + SlotPath.unescape((String)categoryElem.name));
            }
        }
        if (categoryElem.display != null) {
            BFormat displayFormat = BFormat.make((String)categoryElem.display);
            BNameMap displayNames = (BNameMap)catService.get("displayNames");
            if (displayNames == null) {
                displayNames = BNameMap.make((BNameMap)BNameMap.NULL, (String)categoryElem.name, (BFormat)displayFormat);
                catService.add("displayNames", (BValue)displayNames);
            } else {
                displayNames = BNameMap.make((BNameMap)displayNames, (String)categoryElem.name, (BFormat)displayFormat);
                catService.set("displayNames", (BValue)displayNames);
            }
        }
    }

    public void parseUsers(XParser parser, Context cx) throws Exception {
        XElem root = this.match(parser, 1, "users");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("user")) {
                    this.parseUser(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem rootEnd = this.match(parser, 2, "users");
    }

    public void parseUser(XParser parser, Context cx) throws Exception {
        XElem catElem = this.match(parser, 1, "user");
        String name = catElem.get("name", null);
        String encodedRoles = catElem.get("roles", null);
        UserElem userElem = new UserElem();
        userElem.name = name;
        userElem.roles = TextUtil.replace((String)encodedRoles, (String)",", (String)";");
        if (this.users.get(name) != null) {
            String mergedRoles;
            UserElem existingUserElem = (UserElem)this.users.get(name);
            Array a = new Array((Object[])TextUtil.split((String)existingUserElem.roles, (char)';'));
            Array b = new Array((Object[])TextUtil.split((String)userElem.roles, (char)';'));
            if (a.size() == 1 && a.get(0) == null) {
                a.remove(0);
            }
            if (b.size() == 1 && b.get(0) == null) {
                b.remove(0);
            }
            for (int i = 0; i < b.size(); ++i) {
                if (a.contains(b.get(i))) continue;
                a.add(b.get(i));
            }
            userElem.roles = mergedRoles = TextUtil.join((String[])((String[])a.trim()), (char)';');
        }
        this.users.put(name, userElem);
        XElem rootEnd = this.match(parser, 2, "user");
    }

    public void enforceUser(UserElem userElem, Context cx) throws Exception {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser user = (BUser)userService.get(userElem.name);
        if (user == null) {
            user = this.getNewSecUser();
            userService.add(userElem.name, (BValue)user);
        }
        user.setRoles(userElem.roles);
    }

    public BUser getNewSecUser() {
        BUser user = new BUser();
        BWebProfileConfig webProfile = new BWebProfileConfig();
        webProfile.setTypeSpec(BTypeSpec.make((String)"entsecHx:HxAccessProfile"));
        user.add(MappingSupport.getMixInName(BWebProfileConfig.TYPE), (BValue)webProfile);
        if (user.getNavFile().isNull()) {
            user.setNavFile(BOrd.make((String)"module://entsec/rc/entsecHome.nav"));
        }
        return user;
    }

    public void parseRoles(XParser parser, Context cx) throws Exception {
        XElem root = this.match(parser, 1, "roles");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("role")) {
                    this.parseRole(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem rootEnd = this.match(parser, 2, "roles");
    }

    public void parseRole(XParser parser, Context cx) throws Exception {
        String stringEntsecApp;
        String stringFirstVersion;
        XElem roleXElem = this.match(parser, 1, "role");
        String name = roleXElem.get("name", null);
        if (name == null) {
            throw new IllegalStateException("'name' attribute required for role.");
        }
        RoleElem roleElem = new RoleElem();
        roleElem.name = name;
        String stringPermissionsMap = roleXElem.get("permissionsMap", null);
        if (stringPermissionsMap != null) {
            roleElem.permissionsMap = (BPermissionsMap)BPermissionsMap.DEFAULT.decodeFromString(stringPermissionsMap);
        }
        if ((stringFirstVersion = roleXElem.get("firstVersion", null)) != null) {
            roleElem.firstVersion = new Version(stringFirstVersion);
        }
        if ((stringEntsecApp = roleXElem.get("entsecApp", null)) != null) {
            roleElem.entsecApp = BTypeSpec.make((String)stringEntsecApp);
        }
        this.roles.put(name, roleElem);
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String elemName = elem.name();
                if (elemName.equals("category")) {
                    this.parseRoleCategory(parser, roleElem, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem roleEnd = this.match(parser, 2, "role");
    }

    public void enforceRole(RoleElem roleElem, Context cx) throws Exception {
        BPermissionsMap map;
        boolean newlyAdded = false;
        if (!this.info.getRoles()) {
            if (roleElem.firstVersion != null && roleElem.firstVersion.compareTo(this.version) > 0) {
                newlyAdded = true;
            } else if (roleElem.entsecApp != null && EntsecAppUtil.isEntsecAppNew(roleElem.entsecApp)) {
                newlyAdded = true;
            }
        }
        BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
        BEntsecRole entsecRole = null;
        BIRole role = roleService.getRole(roleElem.name);
        if (role == null) {
            if (!this.info.getRoles() && !newlyAdded) {
                return;
            }
            entsecRole = new BEntsecRole();
            roleService.add(roleElem.name, (BValue)entsecRole);
        } else {
            entsecRole = (BEntsecRole)role;
            if (roleElem.name.equals("Admin")) {
                entsecRole.setFlags(entsecRole.getSlot("permissions"), 1);
            }
        }
        if ((this.info.getRoles() || newlyAdded) && roleElem.permissionsMap != null) {
            entsecRole.setPermissions(roleElem.permissionsMap);
        }
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        int index = this.getMaxCategoryIndex(catService);
        BPermissions[] permissions = new BPermissions[index + 1];
        BPermissionsMap storedPermissionsMap = entsecRole.getPermissions();
        for (int i = 1; i < storedPermissionsMap.size(); ++i) {
            permissions[i] = storedPermissionsMap.getPermissions(i);
        }
        roleElem.permissions = permissions;
        Iterator i = roleElem.roleCategories.values().iterator();
        while (i.hasNext()) {
            this.enforceRoleCategory(roleElem, (RoleCategoryElem)i.next(), newlyAdded, cx);
        }
        if (roleElem.permissionsMap == null && !storedPermissionsMap.equals((Object)(map = BPermissionsMap.make((BPermissions[])roleElem.permissions)))) {
            entsecRole.setPermissions(map);
        }
    }

    public void parseRoleCategory(XParser parser, RoleElem roleElem, Context cx) throws Exception {
        XElem catElem = this.match(parser, 1, "category");
        String name = catElem.get("name", null);
        String encodedPermissions = catElem.get("permissions", null);
        RoleCategoryElem roleCategoryElem = new RoleCategoryElem();
        roleCategoryElem.name = name;
        roleCategoryElem.permissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(encodedPermissions);
        roleElem.roleCategories.put(name, roleCategoryElem);
        XElem rootEnd = this.match(parser, 2, "category");
    }

    public void enforceRoleCategory(RoleElem roleElem, RoleCategoryElem roleCategoryElem, boolean newlyAddedRole, Context cx) throws Exception {
        CategoryElem categoryElem;
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BCategory existing = (BCategory)catService.get(roleCategoryElem.name);
        if (existing == null) {
            throw new IllegalStateException("Cannot Find Category Named: " + roleElem + ":" + catService.get(roleCategoryElem.name) + ":" + ((BCategory[])catService.getChildren(BCategory.class)).length);
        }
        if (!(this.info.getRoles() || !this.newCategory || newlyAddedRole || (categoryElem = (CategoryElem)this.categories.get(existing.getName())) != null && categoryElem.newCategory)) {
            return;
        }
        roleElem.permissions[existing.getIndex()] = roleCategoryElem.permissions;
    }

    public void parseMasks(XParser parser, Context cx) throws Exception {
        XElem masksStart = this.match(parser, 1, "masks");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("components")) {
                    this.parseComponents(parser, cx);
                } else if (name.equals("orion")) {
                    this.parseOrion(parser, cx);
                } else if (name.equals("ordMap")) {
                    this.parseOrdMap(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                parser.next();
            }
            elemType = parser.type();
        }
        XElem masksEnd = this.match(parser, 2, "masks");
    }

    public void parseComponents(XParser parser, Context cx) throws Exception {
        XElem masksStart = this.match(parser, 1, "components");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("component")) {
                    BComponentSpace space = Sys.getStation().getComponentSpace();
                    this.parseComponent(parser, space, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem masksEnd = this.match(parser, 2, "components");
    }

    public void enforceComponents(Context cx) throws Exception {
        Iterator i = this.componentMasks.values().iterator();
        while (i.hasNext()) {
            this.enforceComponent((ComponentMaskElem)i.next(), cx);
        }
    }

    public void parseComponent(XParser parser, BComponentSpace space, Context cx) throws Exception {
        XElem cElem = this.match(parser, 1, "component");
        String ord = cElem.get("ord");
        String mask = cElem.get("mask");
        if (ord == null || mask == null) {
            throw new IllegalStateException("'ord' and 'mask' attributes required for component.");
        }
        try {
            BComponent[] components = null;
            if (!"service:naxisVideo:AxisVideoNetwork".equals(ord)) {
                BComponent component = (BComponent)BOrd.make((String)ord).resolve((BObject)space).get();
                components = new BComponent[]{component};
            } else {
                Type type = BTypeSpec.make((String)"naxisVideo:AxisVideoNetwork").getResolvedType();
                components = Sys.getServices((Type)type);
            }
            for (int i = 0; i < components.length; ++i) {
                ComponentMaskElem componentMaskElem = new ComponentMaskElem();
                componentMaskElem.component = components[i];
                componentMaskElem.mask = this.decodeMask(mask);
                ComponentMaskElem existingElem = (ComponentMaskElem)this.componentMasks.get(components[i].getHandle());
                if (existingElem != null) {
                    componentMaskElem.mask = BCategoryMask.or((BCategoryMask)componentMaskElem.mask, (BCategoryMask)existingElem.mask);
                }
                this.componentMasks.put(components[i].getHandle(), componentMaskElem);
            }
        }
        catch (UnresolvedException components) {
        }
        catch (ServiceNotFoundException components) {
        }
        catch (ModuleNotFoundException components) {
            // empty catch block
        }
        XElem cEnd = this.match(parser, 2, "component");
    }

    public void enforceComponent(ComponentMaskElem componentMaskElem, Context cx) throws Exception {
        componentMaskElem.component.setCategoryMask(componentMaskElem.mask, cx);
    }

    public void parseOrion(XParser parser, Context cx) throws Exception {
        XElem orionStart = this.match(parser, 1, "orion");
        String orionMask = orionStart.get("mask");
        if (orionMask == null) {
            throw new IllegalStateException("'mask' attribute required for orion.");
        }
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionSpace space = service.getOrionSpace();
        OrionSpaceElem existingElem = this.orionSpaceElem;
        this.orionSpaceElem = new OrionSpaceElem();
        this.orionSpaceElem.mask = this.decodeMask(orionMask);
        this.orionSpaceElem.component = space.getRootComponent();
        if (existingElem != null) {
            this.orionSpaceElem.mask = BCategoryMask.or((BCategoryMask)this.orionSpaceElem.mask, (BCategoryMask)existingElem.mask);
        }
        this.parseOrionDatabases(parser, cx);
        XElem orionEnd = this.match(parser, 2, "orion");
    }

    public void enforceOrion(Context cx) throws Exception {
        if (this.orionSpaceElem == null) {
            return;
        }
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionSpace space = service.getOrionSpace();
        this.orionSpaceElem.component.setCategoryMask(this.orionSpaceElem.mask, cx);
        Iterator i = this.orionSpaceElem.databases.values().iterator();
        while (i.hasNext()) {
            this.enforceOrionDatabase((OrionDatabaseElem)i.next(), cx);
        }
    }

    public void parseOrionDatabases(XParser parser, Context cx) throws Exception {
        XElem start = this.match(parser, 1, "databases");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("db")) {
                    this.parseOrionDatabase(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem end = this.match(parser, 2, "databases");
    }

    public void parseOrionDatabase(XParser parser, Context cx) throws Exception {
        XElem dbStart = this.match(parser, 1, "db");
        String id = dbStart.get("id");
        String mask = dbStart.get("mask");
        if (id == null || mask == null) {
            throw new IllegalStateException("'id' and 'mask' attributes required for database.");
        }
        BOrionDatabase db = null;
        if (id.equals("_app_")) {
            db = this.getAppDb();
            if (db == null) {
                throw new IllegalStateException("Security application database not configured.");
            }
        } else {
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace space = service.getOrionSpace();
            db = space.getOrionDatabase(id);
            if (db == null) {
                throw new IllegalStateException("Database not found: " + id);
            }
        }
        OrionDatabaseElem orionDatabaseElem = new OrionDatabaseElem();
        orionDatabaseElem.mask = this.decodeMask(mask);
        orionDatabaseElem.component = db;
        OrionDatabaseElem existingElem = (OrionDatabaseElem)this.orionSpaceElem.databases.get(db.getHandle());
        if (existingElem != null) {
            orionDatabaseElem.mask = BCategoryMask.or((BCategoryMask)orionDatabaseElem.mask, (BCategoryMask)existingElem.mask);
        }
        this.orionSpaceElem.databases.put(db.getHandle(), orionDatabaseElem);
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("module")) {
                    this.parseOrionModule(parser, db, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem dbEnd = this.match(parser, 2, "db");
    }

    public void enforceOrionDatabase(OrionDatabaseElem orionDatabaseElem, Context cx) throws Exception {
        orionDatabaseElem.component.setCategoryMask(orionDatabaseElem.mask, cx);
        Iterator i = orionDatabaseElem.modules.values().iterator();
        while (i.hasNext()) {
            this.enforceOrionModule((OrionModuleElem)i.next(), cx);
        }
        i = orionDatabaseElem.types.values().iterator();
        while (i.hasNext()) {
            this.enforceOrionType((OrionTypeElem)i.next(), cx);
        }
    }

    public void parseOrionModule(XParser parser, BOrionDatabase db, Context cx) throws Exception {
        XElem moduleStart = this.match(parser, 1, "module");
        String moduleName = moduleStart.get("name");
        String mask = moduleStart.get("mask");
        BOrionModule module = db.getModule(moduleName);
        if (module != null) {
            OrionModuleElem existingElem;
            OrionModuleElem orionModuleElem = new OrionModuleElem();
            orionModuleElem.mask = this.decodeMask(mask);
            orionModuleElem.component = module;
            OrionDatabaseElem orionDatabaseElem = (OrionDatabaseElem)this.orionSpaceElem.databases.get(db.getHandle());
            if (orionDatabaseElem != null && (existingElem = (OrionModuleElem)orionDatabaseElem.modules.get(module.getHandle())) != null) {
                orionModuleElem.mask = BCategoryMask.or((BCategoryMask)orionModuleElem.mask, (BCategoryMask)existingElem.mask);
            }
            orionDatabaseElem.modules.put(module.getHandle(), orionModuleElem);
        }
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("type")) {
                    this.parseOrionType(parser, db, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem moduleEnd = this.match(parser, 2, "module");
    }

    public void enforceOrionModule(OrionModuleElem orionModuleElem, Context cx) throws Exception {
        orionModuleElem.component.setCategoryMask(orionModuleElem.mask, cx);
    }

    public void enforceOrionType(OrionTypeElem orionTypeElem, Context cx) throws Exception {
        orionTypeElem.orionType.setCategoryMask(orionTypeElem.mask, cx);
    }

    public void parseOrionType(XParser parser, BOrionDatabase db, Context cx) throws Exception {
        XElem typeElem = this.match(parser, 1, "type");
        String typeSpec = typeElem.get("typeSpec");
        String mask = typeElem.get("mask");
        if (typeSpec == null || mask == null) {
            throw new IllegalStateException("'typeSpec' and 'mask' attributes required for type.");
        }
        BOrionType orionType = db.getType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeSpec));
        if (orionType != null) {
            OrionTypeElem existingElem;
            OrionTypeElem orionTypeElem = new OrionTypeElem();
            orionTypeElem.mask = this.decodeMask(mask);
            orionTypeElem.orionType = orionType;
            OrionDatabaseElem orionDatabaseElem = (OrionDatabaseElem)this.orionSpaceElem.databases.get(db.getHandle());
            if (orionDatabaseElem != null && (existingElem = (OrionTypeElem)orionDatabaseElem.types.get(orionType.getHandle())) != null) {
                orionTypeElem.mask = BCategoryMask.or((BCategoryMask)orionTypeElem.mask, (BCategoryMask)existingElem.mask);
            }
            orionDatabaseElem.types.put(orionType.getHandle(), orionTypeElem);
        }
        XElem cEnd = this.match(parser, 2, "type");
    }

    public void parseOrdMap(XParser parser, Context cx) throws Exception {
        XElem start = this.match(parser, 1, "ordMap");
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                XElem elem = parser.elem();
                String name = elem.name();
                if (name.equals("entry")) {
                    this.parseOrdMapEntry(parser, cx);
                } else {
                    this.parseUnrecognized(parser, cx);
                }
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem end = this.match(parser, 2, "ordMap");
    }

    public void enforceOrdMap(Context cx) throws Exception {
        boolean newCategoryAdded = false;
        Array userNewCategories = new Array(String.class);
        LinkedHashMap<BOrd, BCategoryMask> originalOrdMap = new LinkedHashMap<BOrd, BCategoryMask>();
        for (OrdMaskElem ordListElem : this.ordListMasks.values()) {
            originalOrdMap.put(ordListElem.ord, ordListElem.mask);
        }
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BOrdToCategoryMap latestUpdatedMap = catService.getOrdMap();
        SlotCursor c = catService.getProperties();
        while (c.next(BCategory.class)) {
            Property prop = c.property();
            if (Flags.isUserDefined1((BComplex)catService, (Slot)prop)) continue;
            userNewCategories.add((Object)prop.getName());
        }
        for (int j = 0; j < latestUpdatedMap.size(); ++j) {
            BOrd latestOrd = latestUpdatedMap.getOrd(j);
            if (originalOrdMap.containsKey(latestOrd)) {
                String originalMask = this.reEncodeMask((BCategoryMask)originalOrdMap.get(latestOrd));
                String updatedMask = this.reEncodeMask(latestUpdatedMap.getCategoryMask(latestOrd));
                originalMask = this.addUserDefinedCategoryPermissions(userNewCategories, updatedMask, originalMask);
                originalOrdMap.put(latestOrd, this.decodeMask(originalMask));
                continue;
            }
            String updatedMask = this.reEncodeMask(latestUpdatedMap.getCategoryMask(j));
            String mask = this.addUserDefinedCategoryPermissions(userNewCategories, updatedMask, "");
            originalOrdMap.put(latestOrd, this.decodeMask(mask));
        }
        BOrd[] ords = originalOrdMap.keySet().toArray(new BOrd[originalOrdMap.size()]);
        BCategoryMask[] catMasks = originalOrdMap.values().toArray(new BCategoryMask[originalOrdMap.size()]);
        BOrdToCategoryMap map = BOrdToCategoryMap.make((BOrd[])ords, (BCategoryMask[])catMasks);
        catService.setOrdMap(map);
    }

    private String addUserDefinedCategoryPermissions(Array userNewCategories, String updatedMask, String originalMask) {
        for (int i = 0; i < userNewCategories.size(); ++i) {
            if (!updatedMask.contains(userNewCategories.get(i).toString())) continue;
            originalMask = originalMask.length() > 0 ? originalMask + "," + userNewCategories.get(i).toString() : userNewCategories.get(i).toString();
        }
        return originalMask;
    }

    public void parseOrdMapEntry(XParser parser, Context cx) throws Exception {
        String deviceName;
        HistoryQuery hq;
        XElem entryElem = this.match(parser, 1, "entry");
        String ordString = entryElem.get("ord");
        String mask = entryElem.get("mask");
        if (ordString == null || mask == null) {
            throw new IllegalStateException("'ord' and 'mask' attributes required for ord map entry.");
        }
        BOrd ord = (BOrd)BOrd.DEFAULT.decodeFromString(ordString);
        OrdQuery[] queries = ord.parse();
        if (queries.length > 0 && queries[0] instanceof HistoryQuery && ((hq = (HistoryQuery)queries[0]).isDeviceQuery() || hq.isHistoryQuery()) && (deviceName = hq.getDeviceName()).equals("^")) {
            if (hq.isDeviceQuery()) {
                hq = new HistoryQuery(Sys.getStation().getStationName());
            } else if (hq.isHistoryQuery()) {
                hq = new HistoryQuery(BHistoryId.make((String)Sys.getStation().getStationName(), (String)hq.getHistoryName()).toString());
            }
            queries[0] = hq;
            ord = BOrd.make((OrdQuery[])queries);
        }
        OrdMaskElem ordMaskElem = new OrdMaskElem();
        ordMaskElem.ord = ord;
        ordMaskElem.mask = this.decodeMask(mask);
        OrdMaskElem existingElem = (OrdMaskElem)this.ordListMasks.get(ordMaskElem.ord);
        if (existingElem != null) {
            ordMaskElem.mask = BCategoryMask.or((BCategoryMask)ordMaskElem.mask, (BCategoryMask)existingElem.mask);
        }
        this.ordListMasks.put(ordMaskElem.ord, ordMaskElem);
        XElem entryEnd = this.match(parser, 2, "entry");
    }

    public void parseUnrecognized(XParser parser, Context cx) throws Exception {
        XElem root = parser.elem();
        String name = root.name();
        XElem start = this.match(parser, 1, name);
        int elemType = parser.type();
        while (elemType != -1 && elemType != 2) {
            if (elemType == 1) {
                this.parseUnrecognized(parser, cx);
            } else {
                elemType = parser.next();
            }
            elemType = parser.type();
        }
        XElem end = this.match(parser, 2, name);
    }

    public int getMaxCategoryIndex(BCategoryService catService) {
        int maxIndex = 0;
        SlotCursor cats = catService.getProperties();
        while (cats.next(BCategory.class)) {
            BCategory cat = (BCategory)cats.get();
            maxIndex = Math.max(maxIndex, cat.getIndex());
        }
        return maxIndex;
    }

    public String encodeMask(BCategoryMask mask) {
        if (mask.isNull()) {
            return "";
        }
        if (mask.isWildcard()) {
            return "*";
        }
        StringBuffer cats = new StringBuffer(128);
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        int size = mask.size();
        for (int i = 1; i <= size; ++i) {
            if (!mask.get(i)) continue;
            if (cats.length() != 0) {
                cats.append(",");
            }
            BCategory cat = catService.getCategory(i);
            cats.append(cat.getName());
        }
        return cats.toString();
    }

    public String reEncodeMask(BCategoryMask mask) {
        if (mask.isNull()) {
            return "";
        }
        if (mask.isWildcard()) {
            return "*";
        }
        StringBuffer cats = new StringBuffer(128);
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BCategory[] categories = catService.getCategories(mask);
        for (int i = 0; i < categories.length; ++i) {
            BCategory cat = categories[i];
            if (i != 0) {
                cats.append("," + cat.getName());
                continue;
            }
            cats.append(cat.getName());
        }
        return cats.toString();
    }

    public BCategoryMask decodeMask(String encodedMask) {
        if (encodedMask.equals("")) {
            return BCategoryMask.NULL;
        }
        if (encodedMask.equals("*")) {
            return BCategoryMask.WILDCARD;
        }
        Array cats = new Array(BCategory.class);
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        StringTokenizer t = new StringTokenizer(encodedMask, ",");
        while (t.hasMoreTokens()) {
            String catName = t.nextToken().trim();
            BCategory cat = (BCategory)catService.get(catName);
            if (cat == null) continue;
            cats.add((Object)cat);
        }
        int[] indices = new int[cats.size()];
        for (int i = 0; i < cats.size(); ++i) {
            BCategory cat = (BCategory)cats.get(i);
            indices[i] = cat.getIndex();
        }
        return BCategoryMask.make((int[])indices);
    }

    public XElem match(XParser parser, int elemType, String elemName) throws Exception {
        int currentType = parser.type();
        boolean error = false;
        if (elemType != currentType) {
            error = true;
        } else if (elemName != null && !parser.elem().name().equals(elemName)) {
            error = true;
        }
        if (error) {
            StringBuffer errMsg = new StringBuffer();
            errMsg.append("Expecting ");
            switch (elemType) {
                case 1: {
                    errMsg.append("start of");
                    break;
                }
                case 2: {
                    errMsg.append("end of");
                    break;
                }
                case 3: {
                    errMsg.append("text");
                    break;
                }
                case -1: {
                    errMsg.append("EOF");
                }
            }
            if (elemName != null) {
                errMsg.append(" ").append(elemName);
            }
            errMsg.append(" element, not ");
            switch (currentType) {
                case 1: {
                    errMsg.append("start of");
                    break;
                }
                case 2: {
                    errMsg.append("end of");
                    break;
                }
                case 3: {
                    errMsg.append("text");
                    break;
                }
                case -1: {
                    errMsg.append("EOF");
                }
            }
            XElem currentElem = parser.elem();
            if (currentElem != null) {
                errMsg.append(currentElem.name());
            }
            errMsg.append(".");
            throw new IllegalStateException(errMsg.toString());
        }
        XElem elem = parser.elem();
        parser.next();
        return elem;
    }

    class OrdMaskElem
    extends MaskElem {
        BOrd ord;

        OrdMaskElem() {
        }
    }

    class OrionTypeElem
    extends MaskElem {
        BOrionType orionType;

        OrionTypeElem() {
        }
    }

    class OrionModuleElem
    extends ComponentMaskElem {
        OrionModuleElem() {
        }
    }

    class OrionDatabaseElem
    extends ComponentMaskElem {
        HashMap modules;
        HashMap types;

        OrionDatabaseElem() {
            this.modules = new LinkedHashMap();
            this.types = new LinkedHashMap();
        }
    }

    class OrionSpaceElem
    extends ComponentMaskElem {
        HashMap databases;

        OrionSpaceElem() {
            this.databases = new LinkedHashMap();
        }
    }

    class ComponentMaskElem
    extends MaskElem {
        BComponent component;

        ComponentMaskElem() {
        }
    }

    class MaskElem {
        BCategoryMask mask;

        MaskElem() {
        }
    }

    class RoleCategoryElem {
        String name;
        BPermissions permissions;

        RoleCategoryElem() {
        }
    }

    class RoleElem {
        String name;
        BPermissionsMap permissionsMap;
        BPermissions[] permissions;
        HashMap roleCategories = new LinkedHashMap();
        Version firstVersion;
        BTypeSpec entsecApp;

        RoleElem() {
        }
    }

    class UserElem {
        String name;
        String roles;

        UserElem() {
        }
    }

    class CategoryElem {
        String name;
        String display;
        boolean newCategory = false;

        CategoryElem() {
        }
    }
}

