/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import javax.baja.hx.HxOp;
import javax.baja.security.BPassword;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public abstract class PasswordUtil {
    public static boolean emphasizeCorrect = false;
    private static String SESSION_INFO = "consolidated_session_Info";

    public static boolean hasSameValueBothReversible(BPassword password1, BPassword password2) {
        if (password1 == null) {
            throw new RuntimeException("First Password is null");
        }
        if (password2 == null) {
            throw new RuntimeException("Second Password is null");
        }
        if (!password1.getPasswordEncoder().isReversible()) {
            throw new RuntimeException("First Passords is not reversible");
        }
        if (!password2.getPasswordEncoder().isReversible()) {
            throw new RuntimeException("Second Passords is not reversible");
        }
        return password1.validate(password2);
    }

    public static boolean hasSameValueBothReversiblePasswords(BOrionObject o1, BOrionObject o2) {
        OrionType t1 = o1.getOrionType();
        OrionType t2 = o2.getOrionType();
        if (!t1.getOrionTypeId().equals((Object)t2.getOrionTypeId())) {
            return false;
        }
        Property[] props = t1.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!(o1.get(props[i]) instanceof BPassword && o2.get(props[i]) instanceof BPassword ? !PasswordUtil.hasSameValueBothReversible((BPassword)o1.get(props[i]), (BPassword)o2.get(props[i])) : !o1.get(props[i]).equals((Object)o2.get(props[i])))) continue;
            return false;
        }
        return true;
    }

    public static boolean requiresPasswordEntryForSubordinates(HxOp op) {
        if (!PasswordUtil.hasSubordinates(op)) {
            return false;
        }
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (!service.getQueryOutdatedStations()) {
            return false;
        }
        boolean oldSubordinate = PasswordUtil.hasWorkingSubordinateWithoutPasswordHashing(op);
        if (!oldSubordinate) {
            return false;
        }
        Object id = op.getRequest().getSession().getAttribute(SESSION_INFO);
        return id == null;
    }

    public static BPassword getSessionPassword(HxOp op) {
        BPassword password = (BPassword)op.getRequest().getSession().getAttribute(SESSION_INFO);
        if (password != null) {
            return password;
        }
        return BPassword.make((String)"");
    }

    public static void setSessionPassword(BPassword password, HxOp op) {
        op.getRequest().getSession().setAttribute(SESSION_INFO, (Object)password);
    }

    public static void removeSessionPassword(HxOp op) {
        emphasizeCorrect = true;
        op.getRequest().getSession().removeAttribute(SESSION_INFO);
    }

    public static boolean hasSubordinates(HxOp op) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        return service.getMonitorSysDefSecurity().getSecuritySubordinateStations().length > 0;
    }

    public static boolean hasWorkingSubordinateWithoutPasswordHashing(HxOp op) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
        for (int i = 0; i < stations.length; ++i) {
            if (stations[i].isDisabled() || stations[i].isDown() || PasswordUtil.supportsPasswordHashing(PasswordUtil.getRemoteVersion(stations[i]))) continue;
            return true;
        }
        return false;
    }

    public static Version getRemoteVersion(BNiagaraStation station) {
        return new Version(station.getVersion());
    }

    public static boolean supportsPasswordHashing(Version v) {
        int major = v.major();
        int minor = v.minor();
        int build = v.build();
        if (major < 3) {
            return false;
        }
        if (major == 3) {
            if (minor <= 4) {
                return false;
            }
            if (minor == 5) {
                return build >= 400;
            }
            if (minor == 6) {
                return build >= 400;
            }
            if (minor == 7) {
                return build >= 100;
            }
            if (minor >= 8) {
                return true;
            }
        }
        return major > 3;
    }
}

