/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridiumx.entsec.access.BAccessControlService;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.Sys;

public abstract class LicenseCounter {
    private static HashMap globalLimits = new HashMap();

    public static Feature getEntsecLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "entSecurity");
    }

    public static void checkLicense(Feature feature, BAbstractService service) {
        try {
            if (feature == null) {
                return;
            }
            feature.check();
            HashMap<String, LicenseLimit> limits = LicenseCounter.getLimitsForFeature(feature);
            if (limits != null) {
                return;
            }
            limits = new HashMap<String, LicenseLimit>();
            globalLimits.put(LicenseCounter.getGlobalKey(feature), limits);
            String[] keys = feature.list();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.endsWith(".limit")) continue;
                String val = feature.get(key);
                int limit = Integer.MAX_VALUE;
                if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
                    limit = Integer.parseInt(val);
                }
                LicenseLimit lic = new LicenseLimit();
                lic.key = key;
                lic.used = 0;
                lic.limit = limit;
                limits.put(key, lic);
            }
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Unlicensed: " + service.toPathString(), e);
            service.setFaultCause("Unlicensed: " + e);
        }
    }

    public static String getGlobalKey(Feature feature) {
        String globalKey = feature.getVendorName() + ":" + feature.getFeatureName();
        return TextUtil.toLowerCase((String)globalKey);
    }

    public static HashMap getLimitsForFeature(Feature feature) {
        return (HashMap)globalLimits.get(LicenseCounter.getGlobalKey(feature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLicenseCount(Feature feature, String key) {
        HashMap limits = LicenseCounter.getLimitsForFeature(feature);
        if (limits == null) {
            return 0;
        }
        HashMap hashMap = globalLimits;
        synchronized (hashMap) {
            LicenseLimit lic = (LicenseLimit)limits.get(key);
            if (lic == null) {
                return 0;
            }
            return lic.used;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkLicenseLimit(Feature feature, String key) {
        HashMap hashMap = globalLimits;
        synchronized (hashMap) {
            HashMap limits = LicenseCounter.getLimitsForFeature(feature);
            if (limits == null) {
                return null;
            }
            LicenseLimit lic = (LicenseLimit)limits.get(key);
            if (lic == null) {
                return "Unlicensed: " + key;
            }
            ++lic.used;
            if (lic.used > lic.limit) {
                return "Exceeded " + lic.key + " of " + lic.limit;
            }
            return null;
        }
    }

    public static void spy(SpyWriter out) throws Exception {
        for (String limitKey : globalLimits.keySet()) {
            HashMap limits = (HashMap)globalLimits.get(limitKey);
            if (limits == null) continue;
            out.startTable(true);
            out.trTitle((Object)("License Limits for " + limitKey), 3);
            out.w((Object)"<tr>").th((Object)"Attribue").th((Object)"Used").th((Object)"Limit").w((Object)"</tr>\n");
            for (LicenseLimit lic : limits.values()) {
                String limit = lic.limit == Integer.MAX_VALUE ? "none" : "" + lic.limit;
                out.tr((Object)lic.key, (Object)("" + lic.used), (Object)limit);
            }
            out.endTable();
        }
    }

    static class LicenseLimit {
        String key;
        int limit;
        int used;

        LicenseLimit() {
        }
    }
}

