/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridium.platform.license.BrandProps;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.app.BIEntsecApp;
import com.tridiumx.guidedTour.GuidedTour;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

public class BrandingManager {
    public GuidedTour guidedTour;
    private BOrdList entsecNavOrdList;
    private BOrd defaultUserPermissionsXml = BOrd.make((String)"module://entsec/rc/defaultUserPermissions.xml");
    private BOrd guidedTourXml;
    private String brandModuleName = "entsecHx";
    private BOrd helpModule = BOrd.make((String)"module://genericSecHelp/help");
    private BEnterpriseSecurityService service;

    public BrandingManager(BEnterpriseSecurityService service) {
        try {
            BOrd logo;
            boolean loginSet = false;
            boolean favSet = false;
            this.service = service;
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            if (BEnterpriseSecurityService.isWorkstation()) {
                this.guidedTourXml = BOrd.make((String)"module://entsec/rc/SysGuidedTour.xml");
                this.entsecNavOrdList = BOrdList.make((String)"module://entsec/rc/entsecServer.enav");
            } else {
                this.guidedTourXml = BOrd.make((String)"module://entsec/rc/JaceGuidedTour.xml");
                this.entsecNavOrdList = BOrdList.make((String)"module://entsec/rc/entsecController.enav");
            }
            BValue oldLogo = webService.get("logo");
            BValue oldFavIcon = webService.get("favicon");
            this.brandModuleName = BrandProps.getLocalInstance().get("entsec.brand.module", "entsecHx");
            String logInLogo = BrandProps.getLocalInstance().get("entsec.login.logo", null);
            String favIcon = BrandProps.getLocalInstance().get("entsec.favicon", null);
            String sHelpModule = BrandProps.getLocalInstance().get("entsec.helpModule", null);
            String sGuidedSetup = BrandProps.getLocalInstance().get("entsec.guidedSetup.xml", null);
            String sDefaultUserPermissions = BrandProps.getLocalInstance().get("entsec.defaultUserPermissions.xml", null);
            String sEntsecNav = BrandProps.getLocalInstance().get("entsec.enav", null);
            if (sHelpModule != null && sHelpModule.length() > 0) {
                this.helpModule = BOrd.make((String)sHelpModule);
            }
            if (logInLogo != null && logInLogo.length() > 0 || !this.brandModuleName.equals("entsecHx")) {
                loginSet = true;
                logo = null;
                logo = logInLogo != null && logInLogo.length() > 0 ? BOrd.make((String)logInLogo) : BOrd.make((String)("module://" + this.brandModuleName + "/rc/header/logo.png"));
                if (oldLogo != null && !oldLogo.equals((Object)logo) && oldLogo.getType().is(BOrd.TYPE)) {
                    webService.set("logo", (BValue)logo);
                } else if (oldLogo == null) {
                    webService.add("logo", (BValue)logo);
                }
            }
            if (favIcon != null && favIcon.length() > 0) {
                favSet = true;
                logo = BOrd.make((String)favIcon);
                if (oldFavIcon != null && !oldFavIcon.equals((Object)logo) && oldFavIcon.getType().is(BOrd.TYPE)) {
                    webService.set("favicon", (BValue)logo);
                } else if (oldFavIcon == null) {
                    webService.add("favicon", (BValue)logo);
                }
            }
            if (sGuidedSetup != null && sGuidedSetup.length() > 0) {
                this.guidedTourXml = BOrd.make((String)sGuidedSetup);
            }
            if (sDefaultUserPermissions != null && sDefaultUserPermissions.length() > 0) {
                this.defaultUserPermissionsXml = BOrd.make((String)sDefaultUserPermissions);
            }
            if (sEntsecNav != null && sEntsecNav.length() > 0) {
                this.entsecNavOrdList = BOrdList.make((String)sEntsecNav);
            }
            if (!loginSet) {
                logo = BOrd.make((String)"module://entsec/rc/TridiumLogo.png");
                if (oldLogo == null) {
                    webService.add("logo", (BValue)logo);
                } else if (!logo.equals((Object)oldLogo)) {
                    webService.set("logo", (BValue)logo);
                }
            }
            if (!favSet && oldFavIcon != null) {
                webService.remove("favicon");
            }
        }
        catch (Exception e) {
            BEnterpriseSecurityService.LOG.log(Level.SEVERE, "Branding failed:", e);
        }
    }

    public String getBrandModule() {
        return this.brandModuleName;
    }

    public BOrd getHelpModule() {
        return this.helpModule;
    }

    public BOrd getGuidedTourXml() {
        return this.guidedTourXml;
    }

    public BOrdList getDefaultUserPermissionsOrdList() {
        try {
            BComponent[] entsecApps = Sys.getServices((Type)BIEntsecApp.TYPE);
            Array a = new Array(BOrd.class);
            a.add((Object)this.defaultUserPermissionsXml);
            for (int i = 0; i < entsecApps.length; ++i) {
                BIEntsecApp entsecApp = (BIEntsecApp)entsecApps[i];
                BOrd ord = entsecApp.getAdditionalUserPermissionsFileOrd();
                if (ord == null) continue;
                a.add((Object)ord);
            }
            return BOrdList.make((BOrd[])((BOrd[])a.trim()));
        }
        catch (Exception e) {
            return BOrdList.make((BOrd)this.defaultUserPermissionsXml);
        }
    }

    public BOrdList getEntsecNavOrdList() {
        try {
            BComponent[] entsecApps = Sys.getServices((Type)BIEntsecApp.TYPE);
            Array a = new Array(BOrd.class);
            a.addAll((Object[])this.entsecNavOrdList.toArray());
            for (int i = 0; i < entsecApps.length; ++i) {
                BIEntsecApp entsecApp = (BIEntsecApp)entsecApps[i];
                BOrd ord = entsecApp.getAdditionalEntsecNavFileOrd();
                if (ord == null) continue;
                a.add((Object)ord);
            }
            return BOrdList.make((BOrd[])((BOrd[])a.trim()));
        }
        catch (Exception e) {
            return this.entsecNavOrdList;
        }
    }
}

