/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.vacm;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.version3.vacm.BVacmGroup;
import com.tridium.nSnmp.version3.vacm.SnmpVACMTablesFactory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BVacmGroupTable
extends BComponent {
    public static final Type TYPE = Sys.loadType(BVacmGroupTable.class);

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSnmpAgent;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!(value instanceof BVacmGroup)) {
            throw new LocalizableRuntimeException("nSnmp", "addNonVacmGroupError");
        }
    }

    public static BVacmGroup getVacmGroup(int securityModel, String securityName) {
        BVacmGroup vacmGroup = null;
        BVacmGroupTable groupTable = (BVacmGroupTable)SnmpVACMTablesFactory.getTableComponent(SnmpVACMTablesFactory.VACMTableTypes.BVacmGroup);
        if (groupTable != null) {
            BComponent[] contexts = groupTable.getChildComponents();
            for (int index = 0; index < contexts.length; ++index) {
                BVacmGroup tmpVacmGroup;
                if (!(contexts[index] instanceof BVacmGroup) || securityModel != (tmpVacmGroup = (BVacmGroup)contexts[index]).getSecurityModel() || !securityName.equals(tmpVacmGroup.getSecurityName())) continue;
                vacmGroup = tmpVacmGroup;
                break;
            }
        }
        return vacmGroup;
    }

    public static boolean isEqualTo(BVacmGroup vacmGroup1, BVacmGroup vacmGroup2) {
        boolean status = false;
        status = vacmGroup1.getSecurityModel() == vacmGroup2.getSecurityModel();
        status = status && vacmGroup1.getSecurityName().equals(vacmGroup2.getSecurityName());
        status = status && vacmGroup1.getVacmGroupName().equals(vacmGroup2.getVacmGroupName());
        return status;
    }

    public Type getType() {
        return TYPE;
    }
}

