/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.securityModel.usmUser;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BUsmUserTable
extends BComponent {
    public static final Type TYPE = Sys.loadType(BUsmUserTable.class);
    private static BUsmUserTable usmUsersTable;
    private static Map<String, BUsmUser> usmUsersTablewithIpAddress;

    public Type getType() {
        return TYPE;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BUsmUser) {
            ((BUsmUser)value).setEngineID(BUsmUserTable.engineIdDisplay(this.createLocalEngineID()));
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
    }

    public void renamed(Property p, String oldName, Context context) {
        super.renamed(p, oldName, context);
    }

    public void removed(Property property, BValue value, Context context) {
        super.removed(property, value, context);
    }

    public BUsmUser getUser(String userName) {
        BUsmUser usmUser = null;
        BComponent[] usmUsers = this.getChildComponents();
        for (int j = 0; j < usmUsers.length; ++j) {
            BUsmUser user;
            if (!(usmUsers[j] instanceof BUsmUser) || !(user = (BUsmUser)usmUsers[j]).getName().equalsIgnoreCase(userName)) continue;
            usmUser = user;
        }
        return usmUser;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSnmpAgent;
    }

    public static BUsmUser getUserforTrap(String IpAddress) {
        return usmUsersTablewithIpAddress.get(IpAddress);
    }

    public static Map<String, BUsmUser> getUsmUserForTrapTable() {
        return usmUsersTablewithIpAddress;
    }

    public static BUsmUserTable getUsmUserTable() {
        return usmUsersTable;
    }

    public static void setUsmUserTable(BUsmUserTable usmUserTable) {
        usmUsersTable = usmUserTable;
    }

    public byte[] createLocalEngineID() {
        byte[] engineID = new byte[12];
        int enterpriseID = 4131;
        engineID[0] = (byte)(0x80 | enterpriseID >> 24 & 0xFF);
        engineID[1] = (byte)(enterpriseID >> 16 & 0xFF);
        engineID[2] = (byte)(enterpriseID >> 8 & 0xFF);
        engineID[3] = (byte)(enterpriseID & 0xFF);
        engineID[4] = -128;
        byte[] address = null;
        address = this.getCurrentIp().getAddress();
        int j = 0;
        for (int i = 5; i < 12 && j < 4; ++i, ++j) {
            engineID[i] = address[j];
        }
        return engineID;
    }

    private static String engineIdDisplay(byte[] paramArrayOfByte) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            sb.append(String.format("%02X", 0xFF & paramArrayOfByte[i]));
        }
        return sb.toString().trim();
    }

    private InetAddress getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("unable to get current IP " + e.getMessage());
        }
        return null;
    }

    static {
        usmUsersTablewithIpAddress = new Hashtable<String, BUsmUser>();
    }
}

