/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.securityModel.usm.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BUsmAuthUtil {
    public static final int BLOCK_LENGTH = 64;
    public static final int MD_LENGTH = 12;
    private static long OneMegaByteDataLength = 0x100000L;

    public static MessageDigest getDigestObject(String protocolName) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(protocolName);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InternalError(protocolName + " is not supported");
        }
        return md;
    }

    public static byte[] authenticateOutgoingMsg(String authProtocol, byte[] authKey, byte[] message) {
        int i;
        byte[] macDigest = new byte[12];
        int keyLength = authKey.length;
        MessageDigest md = BUsmAuthUtil.getDigestObject(authProtocol);
        BUsmAuthUtil.checkAuthKey(authKey);
        if (keyLength > 64) {
            md.update(authKey);
            authKey = md.digest();
        }
        byte[] kIpad = new byte[64];
        byte[] kOpad = new byte[64];
        for (i = 0; i < 64; ++i) {
            if (i < authKey.length) {
                kIpad[i] = (byte)(authKey[i] ^ 0x36);
                kOpad[i] = (byte)(authKey[i] ^ 0x5C);
                continue;
            }
            kIpad[i] = 54;
            kOpad[i] = 92;
        }
        md.update(kIpad);
        md.update(message);
        byte[] innerDigest = md.digest();
        md.reset();
        md.update(kOpad);
        md.update(innerDigest);
        byte[] finalDigest = md.digest();
        for (i = 0; i < 12; ++i) {
            macDigest[i] = finalDigest[i];
        }
        return macDigest;
    }

    private static void checkAuthKey(byte[] authKey) {
        if (authKey.length < 8) {
            throw new RuntimeException("AuthKey Length should must be of 16 octets");
        }
    }

    public static boolean authenticateIncomingMsg(String authProtocol, byte[] authKey, byte[] message, byte[] originaldigest) {
        boolean isAuthentic = false;
        byte[] newDigest = BUsmAuthUtil.authenticateOutgoingMsg(authProtocol, authKey, message);
        if (newDigest != null) {
            int i = 0;
            for (i = 0; i < originaldigest.length && newDigest[i] == originaldigest[i]; ++i) {
            }
            if (i == originaldigest.length) {
                isAuthentic = true;
            }
        }
        return isAuthentic;
    }

    public static byte[] passwordTokey(String authProtocol, byte[] password, byte[] engineId, String privacyProtocol) {
        byte[] key_16 = BUsmAuthUtil.passwordTokey(authProtocol, password, engineId);
        if (privacyProtocol.equalsIgnoreCase("AES128") || privacyProtocol.equalsIgnoreCase("DES")) {
            return key_16;
        }
        if (privacyProtocol.equalsIgnoreCase("AES192")) {
            byte[] key_24 = new byte[24];
            byte[] tempKey = BUsmAuthUtil.generateHashKey(authProtocol, key_16);
            try {
                if (authProtocol.equalsIgnoreCase("MD5")) {
                    System.arraycopy(key_16, 0, key_24, 0, 16);
                    System.arraycopy(tempKey, 0, key_24, 16, 8);
                }
                if (authProtocol.equalsIgnoreCase("SHA")) {
                    System.arraycopy(key_16, 0, key_24, 0, 20);
                    System.arraycopy(tempKey, 0, key_24, 20, 4);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return key_24;
        }
        if (privacyProtocol.equalsIgnoreCase("AES256")) {
            byte[] key_32 = new byte[32];
            byte[] tempKey = BUsmAuthUtil.generateHashKey(authProtocol, key_16);
            try {
                if (authProtocol.equalsIgnoreCase("MD5")) {
                    System.arraycopy(key_16, 0, key_32, 0, 16);
                    System.arraycopy(tempKey, 0, key_32, 16, 16);
                }
                if (authProtocol.equalsIgnoreCase("SHA")) {
                    System.arraycopy(key_16, 0, key_32, 0, 20);
                    System.arraycopy(tempKey, 0, key_32, 20, 12);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return key_32;
        }
        return key_16;
    }

    private static byte[] generateHashKey(String authProtocol, byte[] keyOfLength_16) {
        MessageDigest md = BUsmAuthUtil.getDigestObject(authProtocol);
        byte[] hashKey = md.digest(keyOfLength_16);
        return hashKey;
    }

    public static byte[] passwordTokey(String authProtocol, byte[] password, byte[] engineId) {
        MessageDigest md = BUsmAuthUtil.getDigestObject(authProtocol);
        byte[] buff = new byte[64];
        int pwd_index = 0;
        int count = 0;
        while ((long)count < OneMegaByteDataLength) {
            for (int i = 0; i < 64; ++i) {
                buff[i] = password[pwd_index++ % password.length];
            }
            md.update(buff);
            count += 64;
        }
        byte[] digest = md.digest();
        md.reset();
        md.update(digest);
        md.update(engineId);
        md.update(digest);
        digest = md.digest();
        return digest;
    }
}

