/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.dto;

import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.ndriver.datatypes.BIpAddress;

public class BSnmpMessageProcessingModelOutput {
    private BIpAddress destinationAddress;
    private SnmpV3Message outgoingMessage;
    private String outgoingMessageLength;
    private boolean isResponse = false;

    public BSnmpMessageProcessingModelOutput() {
    }

    public BSnmpMessageProcessingModelOutput(BIpAddress destinationAddress, SnmpV3Message outgoingMessage, String outgoingMessageLength) {
        this.destinationAddress = destinationAddress;
        this.outgoingMessage = outgoingMessage;
        this.outgoingMessageLength = outgoingMessageLength;
    }

    public BSnmpMessageProcessingModelOutput(BIpAddress destinationAddress, SnmpPDU outgoingPDU, String outgoingMessageLength) {
        this.destinationAddress = destinationAddress;
        this.outgoingMessage = outgoingPDU instanceof SnmpV3Message ? (SnmpV3Message)outgoingPDU : this.outgoingMessage;
    }

    public BIpAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public SnmpV3Message getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public String getOutgoingMessageLength() {
        return this.outgoingMessageLength;
    }

    public void setDestinationAddress(BIpAddress destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public void setOutgoingMessage(SnmpV3Message outgoingMessage) {
        this.outgoingMessage = outgoingMessage;
    }

    public void setOutgoingMessageLength(String outgoingMessageLength) {
        this.outgoingMessageLength = outgoingMessageLength;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public void setResponse(boolean isResponse) {
        this.isResponse = isResponse;
    }

    private SnmpV3Message prepareOutgoingMessage(SnmpPDU pdu) {
        int version = pdu.getVersion();
        SnmpV3Message snmpV3Message = null;
        switch (version) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                snmpV3Message = this.outgoingMessage;
            }
        }
        return snmpV3Message;
    }
}

