/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.util;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.datatypes.BCreateMibParameters;
import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.export.BSnmpExportFolder;
import com.tridium.nSnmp.mib.table.PointTable;
import com.tridium.nSnmp.mib.table.TableEntry;
import com.tridium.nSnmp.object.BSnmpObjectExt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;

public class LocalToMibSnmpV2 {
    private StringBuffer out;

    String extract(BSnmpAgent ldev, BCreateMibParameters p) throws IOException {
        this.out = new StringBuffer();
        int ent = ldev.getEnterprise();
        this.extractFixed(p.getFileName(), ent == 0 ? 4131 : ent);
        BSnmpExportFolder[] fa = LocalToMibSnmpV2.getExportFolders(ldev);
        for (int i = 0; i < fa.length; ++i) {
            this.writeExportTable(fa[i].getDisplayName(null), i + 2);
        }
        this.writeObjects(ldev.snmpNet().objects());
        this.writeNotification();
        this.out.append("END\n");
        return this.out.toString();
    }

    private void extractFixed(String fname, int enterprise) throws IOException {
        String defName = fname;
        if (fname.lastIndexOf(46) > 0) {
            defName = fname.substring(0, fname.lastIndexOf(46));
        }
        this.out.append("-- *************************************************\n");
        this.out.append("-- ").append(fname).append("\n");
        this.out.append("--\n");
        this.out.append("-- Created:").append(BAbsTime.make().toString((Context)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.TRUE))).append("\n");
        this.out.append("--\n");
        this.out.append("-- Copyright ").append(Calendar.getInstance().get(1)).append(" Tridium, Inc.\n");
        this.out.append("-- *************************************************\n");
        this.out.append("--\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append(defName.toUpperCase()).append(" DEFINITIONS ::= BEGIN\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append("IMPORTS\n");
        this.out.append("         MODULE-IDENTITY,OBJECT-TYPE,NOTIFICATION-TYPE,mib-2\n");
        this.out.append("               FROM SNMPv2-SMI\n");
        this.out.append("         enterprises\n");
        this.out.append("               FROM RFC1155-SMI\n");
        this.out.append("         DisplayString,sysUpTime\n");
        this.out.append("               FROM RFC1213-MIB;\n");
        this.out.append("\n");
        this.out.append("tridium  MODULE-IDENTITY\n");
        this.out.append("         LAST-UPDATED \"" + this.lastModifiedDate() + "Z\"\n");
        this.out.append("         ORGANIZATION \"Tridium Inc.\"\n");
        this.out.append("         CONTACT-INFO\n");
        this.out.append("                     \"\"\n");
        this.out.append("         DESCRIPTION \" The MIB Module for snmpv2.\"\n");
        this.out.append("                         \n");
        this.out.append("         ::= { enterprises ").append(enterprise).append(" }\n");
        this.out.append("\n");
        this.out.append("tridiumStation    OBJECT IDENTIFIER ::= { tridium 1 }\n");
        this.out.append("\n");
        this.out.append("version    OBJECT-TYPE\n");
        this.out.append("    SYNTAX        DisplayString\n");
        this.out.append("    MAX-ACCESS    read-only\n");
        this.out.append("    STATUS        current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Current software version\"\n");
        this.out.append("    ::=  { tridiumStation 1 }\n");
        this.out.append("\n");
        this.out.append("action   OBJECT-TYPE\n");
        this.out.append("    SYNTAX            Integer32{\n");
        this.out.append("                       noAction(0),\n");
        this.out.append("                       ackAll(1)\n");
        this.out.append("                      }\n");
        this.out.append("    MAX-ACCESS        read-write\n");
        this.out.append("    STATUS            current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Provides means for manager to perform actions on the alarm table. 0 (no action) or 1 (acknowledge all).\"\n");
        this.out.append("    ::=  { tridiumStation 2 }\n");
        this.out.append("\n");
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  Alarm table declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("alarmTable   OBJECT-TYPE\n");
        this.out.append("    SYNTAX                SEQUENCE OF AlarmTableEntry\n");
        this.out.append("    MAX-ACCESS            not-accessible\n");
        this.out.append("    STATUS                current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A list of alarms in the station which have an snmp recipient (configured to store received alarms).\"\n");
        this.out.append("    ::=  { tridiumStation 3 }\n");
        this.out.append("\n");
        this.out.append("alarmTableEntry  OBJECT-TYPE\n");
        this.out.append("    SYNTAX                AlarmTableEntry\n");
        this.out.append("    MAX-ACCESS            not-accessible\n");
        this.out.append("    STATUS                current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"An alarm table entry containing data for a specific alarm.\"\n");
        this.out.append("    INDEX  { alarmId }  ::=   { alarmTable 1 }\n");
        this.out.append("\n");
        this.out.append("AlarmTableEntry ::= SEQUENCE {\n");
        this.out.append("        timestamp        DisplayString,\n");
        this.out.append("        uuid             OCTET STRING,\n");
        this.out.append("        sourceState      Integer32,\n");
        this.out.append("        ackState         Integer32,\n");
        this.out.append("        ackRequired      Integer32,\n");
        this.out.append("        source           DisplayString,\n");
        this.out.append("        alarmClass       DisplayString,\n");
        this.out.append("        priority         Integer32,\n");
        this.out.append("        normalTime       DisplayString,\n");
        this.out.append("        ackTime          DisplayString,\n");
        this.out.append("        user             DisplayString,\n");
        this.out.append("        alarmData        DisplayString,\n");
        this.out.append("        alarmTransition  Integer32,\n");
        this.out.append("        lastUpdate       DisplayString,\n");
        this.out.append("        alarmId          Integer32\n");
        this.out.append("    }\n");
        this.out.append("\n");
        this.out.append("timestamp   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates the time when the alarm occurred.\"\n");
        this.out.append("    ::=   { alarmTableEntry 1 }\n");
        this.out.append("\n");
        this.out.append("uuid   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              OCTET STRING(SIZE(0..255))\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The unique universal identifier of the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 2 }\n");
        this.out.append("\n");
        this.out.append("sourceState   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           Integer32 {\n");
        this.out.append("                       normal(0),\n");
        this.out.append("                       offnormal(1),\n");
        this.out.append("                       fault(2),\n");
        this.out.append("                       alert(3)\n");
        this.out.append("                     }\n");
        this.out.append("    MAX-ACCESS       read-only\n");
        this.out.append("    STATUS           current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The current state of the source.  normal(0), offnormal(1), fault(2), or alert(3).\"\n");
        this.out.append("    ::=   { alarmTableEntry 3 }\n");
        this.out.append("\n");
        this.out.append("ackState   OBJECT-TYPE\n");
        this.out.append("    SYNTAX             Integer32 {\n");
        this.out.append("                         acked(0),\n");
        this.out.append("                         unacked(1),\n");
        this.out.append("                         ackPending(2)\n");
        this.out.append("                       }\n");
        this.out.append("    MAX-ACCESS         read-write\n");
        this.out.append("    STATUS             current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates if the alarm has been acknowledged.  acked(0), unacked(1), or ackPending(2).\n");
        this.out.append("     Alarm can be acknowledged by setting ackState to 'acked'(0)\"\n");
        this.out.append("    ::=   { alarmTableEntry 4 }\n");
        this.out.append("\n");
        this.out.append("ackRequired   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           Integer32 {\n");
        this.out.append("                       false(0),\n");
        this.out.append("                       true(1)\n");
        this.out.append("                     }\n");
        this.out.append("    MAX-ACCESS       read-only\n");
        this.out.append("    STATUS           current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates if an acknowledgement is required for the alarm.  false(0), or true(1).\"\n");
        this.out.append("    ::=   { alarmTableEntry 5 }\n");
        this.out.append("\n");
        this.out.append("source    OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates the path to the station object which generated the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 6 }\n");
        this.out.append("\n");
        this.out.append("alarmClass  OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The alarm class for the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 7 }\n");
        this.out.append("\n");
        this.out.append("priority   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              Integer32(0..255)\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The priority of the alarm (0=high, 255=low).\"\n");
        this.out.append("    ::=   { alarmTableEntry 8 }\n");
        this.out.append("\n");
        this.out.append("normalTime   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm goes back to normal state.\"\n");
        this.out.append("    ::=   { alarmTableEntry 9 }\n");
        this.out.append("\n");
        this.out.append("ackTime  OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm is acked. Note that\n");
        this.out.append("     interpretation of this value depends upon the state of the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 10 }\n");
        this.out.append("\n");
        this.out.append("user   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The name of the user who acknowledged the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 11 }\n");
        this.out.append("\n");
        this.out.append("alarmData     OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A string containing dynamic alarm data, in key-value pairs.\"\n");
        this.out.append("    ::=   { alarmTableEntry 12 }\n");
        this.out.append("\n");
        this.out.append("alarmTransition   OBJECT-TYPE\n");
        this.out.append("    SYNTAX          Integer32 {\n");
        this.out.append("                       normal(0),\n");
        this.out.append("                       offnormal(1),\n");
        this.out.append("                       fault(2),\n");
        this.out.append("                       alert(3)\n");
        this.out.append("                     }\n");
        this.out.append("    MAX-ACCESS      read-only\n");
        this.out.append("    STATUS          current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The initial state of the source.  normal(0), offnormal(1), fault(2), or alert(3).\"\n");
        this.out.append("    ::=   { alarmTableEntry 13 }\n");
        this.out.append("\n");
        this.out.append("lastUpdate  OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm was last updated. Updates occur\n");
        this.out.append("     at creation, acknowlegement, and changes to alarmData such as notes.\"\n");
        this.out.append("    ::=   { alarmTableEntry 14 }\n");
        this.out.append("\n");
        this.out.append("alarmId   OBJECT-TYPE\n");
        this.out.append("    SYNTAX              Integer32(0..2147483647)\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Numerical identifier for the alarm in the Snmp alarm table.\n");
        this.out.append("     Used as an index to address table entries\"\n");
        this.out.append("    ::=   { alarmTableEntry 15 }\n");
        this.out.append("\n");
        this.writeTable("tridiumStation 4", "Input", true);
        this.writeTable("tridiumStation 5", "Output", false);
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ExportTables\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("exportTables    OBJECT IDENTIFIER ::= { tridiumStation 6 }\n");
        this.out.append("\n");
        this.writeExportTable("export", 1);
    }

    private String lastModifiedDate() {
        BAbsTime modificationTime = BAbsTime.make();
        String modificationDate = modificationTime.getYear() + "";
        int month = modificationTime.getMonth().getMonthOfYear();
        modificationDate = month < 10 ? modificationDate + "0" + month : modificationDate + "" + month;
        int day = modificationTime.getDay();
        modificationDate = day < 10 ? modificationDate + "0" + day : modificationDate + day + "";
        int hour = modificationTime.getHour();
        modificationDate = hour < 10 ? modificationDate + "0" + hour : modificationDate + hour + "";
        int min = modificationTime.getMinute();
        modificationDate = min < 10 ? modificationDate + "0" + min : modificationDate + min + "";
        return modificationDate;
    }

    private void writeExportTable(String name, int expTab) {
        String lcName = name.substring(0, 1).toLowerCase() + name.substring(1);
        String ucName = name.substring(0, 1).toUpperCase() + name.substring(1);
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ").append(ucName).append("\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("").append(lcName).append("    OBJECT IDENTIFIER ::= { exportTables ").append(expTab).append(" }\n");
        this.writeTable(lcName + " 1", lcName + "Input", true);
        this.writeTable(lcName + " 2", lcName + "Output", false);
    }

    private void writeTable(String root, String name, boolean readWrite) {
        String lcName = name.substring(0, 1).toLowerCase() + name.substring(1);
        String ucName = name.substring(0, 1).toUpperCase() + name.substring(1);
        String valueAccess = readWrite ? "read-write" : "read-only";
        this.out.append("\n-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ").append(ucName).append(" table declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append(lcName).append("Table   OBJECT-TYPE\n");
        this.out.append("    SYNTAX                   SEQUENCE OF ").append(ucName).append("TableEntry\n");
        this.out.append("    MAX-ACCESS               not-accessible\n");
        this.out.append("    STATUS                   current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A list of snmp ").append(lcName).append(" (read-only) object values.\"\n");
        this.out.append("    ::=  { ").append(root).append(" }\n");
        this.out.append("\n");
        this.out.append(lcName).append("TableEntry  OBJECT-TYPE\n");
        this.out.append("    SYNTAX                ").append(ucName).append("TableEntry\n");
        this.out.append("    MAX-ACCESS               not-accessible\n");
        this.out.append("    STATUS                   current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"An ").append(lcName).append(" table entry containing data for a specific ").append(lcName).append(".\"\n");
        this.out.append("    INDEX  { ").append(lcName).append("Index }  ::=   { ").append(lcName).append("Table 1 }\n");
        this.out.append("\n");
        this.out.append(ucName).append("TableEntry ::= SEQUENCE {\n");
        this.out.append("        ").append(lcName).append("Index       Integer32,\n");
        this.out.append("        ").append(lcName).append("Name        DisplayString,\n");
        this.out.append("        ").append(lcName).append("Value       DisplayString\n");
        this.out.append("    }\n");
        this.out.append("\n");
        this.out.append(lcName).append("Index   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           Integer32(0..2147483647)\n");
        this.out.append("    MAX-ACCESS       read-only\n");
        this.out.append("    STATUS           current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The index in the ").append(lcName).append(" table for a particular snmp ").append(lcName).append("\n");
        this.out.append("\t object.  Used to address table entries.\"\n");
        this.out.append("    ::=   { ").append(lcName).append("TableEntry 1 }\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append(lcName).append("Name    OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          read-only\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Name of station object.\"\n");
        this.out.append("    ::=   { ").append(lcName).append("TableEntry 2 }\n");
        this.out.append("\n");
        this.out.append(lcName).append("Value    OBJECT-TYPE\n");
        this.out.append("    SYNTAX              DisplayString\n");
        this.out.append("    MAX-ACCESS          ").append(valueAccess).append("\n");
        this.out.append("    STATUS              current \n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Current value of station object. Is ").append(valueAccess).append(" .\"\n");
        this.out.append("    ::=   { ").append(lcName).append("TableEntry 3 }\n");
        this.out.append("\n\n");
    }

    private void writeObjects(PointTable pt) throws IOException {
        TableEntry[] a = pt.getArray();
        if (a.length == 0) {
            return;
        }
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  Niagara Objects\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("    niagaraObjects    OBJECT IDENTIFIER ::= { tridiumStation 7 }\n");
        this.out.append("\n");
        for (int i = 0; i < a.length; ++i) {
            BSnmpObjectExt ext = (BSnmpObjectExt)a[i];
            BSnmpVariableTypeEnum vtyp = ext.getVariableType();
            String idName = this.fixIdentifierName(ext.getPointName());
            if (vtyp == BSnmpVariableTypeEnum.counter64) {
                this.out.append("-- type counter64 not valid for SNMPv1 MIB - ").append(idName).append("\n\n");
                continue;
            }
            this.out.append(idName).append("   OBJECT-TYPE\n");
            this.out.append("    SYNTAX           ");
            switch (vtyp.getOrdinal()) {
                case 0: {
                    int[] ords;
                    BEnumRange range = (BEnumRange)((BControlPoint)ext.getParent()).getFacets().getFacet("range");
                    if (range != null && (ords = range.getOrdinals()).length > 0) {
                        Arrays.sort(ords);
                        this.out.append("    Integer32 {\n");
                        for (int n = 0; n < ords.length; ++n) {
                            this.out.append("                           " + SlotPath.unescape((String)range.getTag(ords[n])) + "(" + ords[n] + ")");
                            this.out.append(n < ords.length - 1 ? ",\n" : "\n");
                        }
                        this.out.append("                         }\n");
                        break;
                    }
                    this.out.append("    Integer32\n");
                    break;
                }
                case 2: {
                    this.out.append("    Counter32\n");
                    break;
                }
                case 3: {
                    this.out.append("    Gauge32\n");
                    break;
                }
                case 1: {
                    this.out.append("    OCTET STRING\n");
                    break;
                }
                case 6: {
                    this.out.append("    IpAddress\n");
                    break;
                }
                case 7: {
                    this.out.append("    OBJECT IDENTIFIER\n");
                    break;
                }
                case 4: {
                    this.out.append("    TimeTicks\n");
                }
            }
            this.out.append("    MAX-ACCESS          ").append(ext.isSettablePoint() ? "read-write" : "read-only").append("\n");
            this.out.append("    STATUS          current \n");
            if (ext.getDescription().length() > 0) {
                this.out.append("    DESCRIPTION\n");
                this.out.append("    \"").append(ext.getDescription()).append("\"\n");
            }
            this.out.append("    ::=   { niagaraObjects ").append(ext.getIndex()).append(" }\n");
            this.out.append("\n");
        }
    }

    private String fixIdentifierName(String name) {
        if (!Character.isLowerCase(name.charAt(0))) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    private void writeNotification() {
        this.writeTrap();
    }

    private void writeTrap() {
        this.out.append("notficationGroup     OBJECT-IDENTITY\n");
        this.out.append("    STATUS           current\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Used to register TRIDIUM agent notify object.\"\n");
        this.out.append("    ::=   { tridiumStation 8 }\n");
        this.out.append("\n");
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  SNMP v2 Notification Type declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append("snmpv2Notify NOTIFICATION-TYPE\n");
        this.out.append("    OBJECTS { sysUpTime,\n");
        this.out.append("                timestamp,\n");
        this.out.append("                uuid,\n");
        this.out.append("                sourceState,\n");
        this.out.append("                ackState,\n");
        this.out.append("                ackRequired,\n");
        this.out.append("                source,\n");
        this.out.append("                alarmClass,\n");
        this.out.append("                priority,\n");
        this.out.append("                normalTime,\n");
        this.out.append("                ackTime,\n");
        this.out.append("                user,\n");
        this.out.append("                alarmData,\n");
        this.out.append("                alarmTransition,\n");
        this.out.append("                lastUpdate }\n");
        this.out.append("    STATUS        current\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("        \"The Notification trap is generated when a SNMP V2 Niagara alarm is received\n");
        this.out.append("         by an snmp recipient which has routing alarms to a network manager\n");
        this.out.append("         enabled.  It contains useful information from the alarm record.\"\n");
        this.out.append("    ::= {notficationGroup 1}\n");
        this.out.append("\n");
        this.out.append("\n");
    }

    public static BSnmpExportFolder[] getExportFolders(BSnmpAgent ldev) {
        Array a = new Array(BSnmpExportFolder.class);
        LocalToMibSnmpV2.getExportFolders(ldev, (Array<BSnmpExportFolder>)a);
        Comparator<BSnmpExportFolder> comp = new Comparator<BSnmpExportFolder>(){

            @Override
            public int compare(BSnmpExportFolder arg0, BSnmpExportFolder arg1) {
                return arg0.getObjectIdentifier().compareTo(arg1.getObjectIdentifier());
            }
        };
        a.sort((Comparator)comp);
        return (BSnmpExportFolder[])a.trim();
    }

    private static void getExportFolders(BComponent c, Array<BSnmpExportFolder> a) {
        SlotCursor sc = c.getProperties();
        while (sc.next()) {
            BValue o = sc.get();
            if (o instanceof BSnmpExportFolder) {
                a.add((Object)((BSnmpExportFolder)o));
                continue;
            }
            if (!(o instanceof BComponent)) continue;
            LocalToMibSnmpV2.getExportFolders((BComponent)o, a);
        }
    }
}

