/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class DisplayHintParser {
    public static String numericDisplay(String value, String displayHint) throws Exception {
        String sValue = value;
        if (displayHint == null || displayHint.equals("")) {
            return sValue;
        }
        int i = Integer.parseInt(value);
        int decimalPosition = DisplayHintParser.checkDisplayFormatForInteger(displayHint);
        if (displayHint.startsWith("d")) {
            if (decimalPosition == 0) {
                return sValue;
            }
            double d = (double)i / Math.pow(10.0, Integer.valueOf(decimalPosition).intValue());
            sValue = Double.toString(d);
        }
        if (displayHint.equals("o")) {
            sValue = Integer.toOctalString(i);
        }
        if (displayHint.equals("x")) {
            sValue = Integer.toHexString(i);
        }
        if (displayHint.equals("b")) {
            sValue = Integer.toBinaryString(i);
        }
        return sValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int checkDisplayFormatForInteger(String displayHint) throws Exception {
        int decimalPosition = 0;
        int displayHintLength = displayHint.length();
        if (displayHintLength == 0) {
            throw new Exception("The DISPLAY-HINT field is empty");
        }
        char displayHintChar = displayHint.charAt(0);
        if (displayHintChar != 'd' && displayHintChar != 'o' && displayHintChar != 'x' && displayHintChar != 'b') {
            throw new Exception("Encountered display format other than 'd','o','x','b'");
        }
        if (displayHintChar == 'd') {
            if (displayHintLength <= 2) return decimalPosition;
            if (displayHint.charAt(1) != '-') throw new Exception("Invalid DISPLAY_HINT format");
            String str = displayHint.substring(2, displayHintLength);
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException localNumberFormatException) {
                throw new Exception("Invalid number in the DISPLAY-HINT");
            }
        }
        if (displayHintChar != 'o' && displayHintChar != 'x') {
            if (displayHintChar != 'b') return decimalPosition;
        }
        if (displayHintLength <= 1) return decimalPosition;
        throw new Exception("Invalid DISPLAY-HINT format");
    }

    public static String stringDisplay(byte[] byteValue, String displayHint) {
        char lastChar;
        String stringToDisplay = new String(byteValue);
        if (displayHint == null || displayHint.equals("")) {
            return stringToDisplay;
        }
        stringToDisplay = "";
        String str2 = "";
        String str3 = "";
        ArrayList<String> sepList = new ArrayList<String>();
        int repeatCount = 0;
        int j = 0;
        int length = byteValue.length;
        Vector<String> displayFormat = null;
        try {
            displayFormat = DisplayHintParser.returnDispFormat(displayHint, byteValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int displayFormatLength = displayFormat.size();
        for (int n = 0; n < displayFormatLength; ++n) {
            char asciOfDisplayFormatChar = '\u0000';
            String str4 = displayFormat.elementAt(n);
            String displayFormatSeparator = "";
            String str6 = "";
            String str7 = "";
            StringTokenizer localStringTokenizer = new StringTokenizer(str4, "*");
            while (localStringTokenizer.hasMoreTokens()) {
                repeatCount = Integer.parseInt(localStringTokenizer.nextToken());
                asciOfDisplayFormatChar = localStringTokenizer.nextToken().charAt(0);
                displayFormatSeparator = localStringTokenizer.nextToken();
                str6 = localStringTokenizer.nextToken();
                str3 = localStringTokenizer.nextToken();
                sepList.add(displayFormatSeparator);
            }
            if (!displayFormatSeparator.equals("0")) {
                str7 = !str6.equals("0") ? displayFormatSeparator + str6 : displayFormatSeparator;
            }
            if (repeatCount > length - j) {
                repeatCount = length - j;
            }
            byte[] arrayOfByte = new byte[repeatCount];
            if (str3.equals("true")) {
                String str8 = "";
                for (int i3 = 0; i3 < repeatCount; ++i3) {
                    str8 = str8 + displayFormatSeparator;
                }
                arrayOfByte = str8.getBytes();
                str7 = "";
            } else {
                for (int i2 = 0; i2 < repeatCount && j <= length - 1; ++j, ++i2) {
                    arrayOfByte[i2] = byteValue[j];
                }
            }
            if (arrayOfByte.length == 0) continue;
            if (asciOfDisplayFormatChar == 'o') {
                str2 = DisplayHintParser.octalStringDisplay(str7, arrayOfByte);
            }
            if (asciOfDisplayFormatChar == 'x') {
                str2 = DisplayHintParser.hexStringDisplay(str7, arrayOfByte);
            }
            if (asciOfDisplayFormatChar == 'a') {
                str2 = DisplayHintParser.asciiStringDisplay(str7, arrayOfByte);
            }
            if (asciOfDisplayFormatChar == 'd') {
                str2 = DisplayHintParser.decimalStringDisplay(str7, arrayOfByte);
            }
            stringToDisplay = stringToDisplay + str2;
        }
        if (stringToDisplay != null && !stringToDisplay.equals("") && sepList.contains(Character.toString(lastChar = stringToDisplay.charAt(stringToDisplay.length() - 1))) && lastChar != '0') {
            stringToDisplay = stringToDisplay.substring(0, stringToDisplay.length() - 1);
        }
        return stringToDisplay;
    }

    private static String decimalStringDisplay(String separator, byte[] paramArrayOfByte) {
        String str = "";
        long l = 0L;
        int i = 1;
        for (int j = paramArrayOfByte.length - 1; j >= 0; --j) {
            l += (long)(i * (paramArrayOfByte[j] & 0xFF));
            i *= 256;
        }
        str = new Long(l).toString();
        str = str + separator;
        return str;
    }

    private static String asciiStringDisplay(String separator, byte[] paramArrayOfByte) {
        String str = "";
        str = str + new String(paramArrayOfByte);
        if (!separator.equals("")) {
            str = str + separator;
        }
        return str;
    }

    private static String hexStringDisplay(String separator, byte[] paramArrayOfByte) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            sb.append(String.format("%02x", paramArrayOfByte[i]));
        }
        sb.append(separator);
        return sb.toString();
    }

    private static String octalStringDisplay(String separator, byte[] paramArrayOfByte) {
        String str = "";
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            str = str + Integer.toOctalString(paramArrayOfByte[i]);
        }
        str = str + separator;
        return str;
    }

    private static Vector<String> returnDispFormat(String displayHint, byte[] paramArrayOfByte) throws Exception {
        int repeatCount;
        Vector<String> displayFormat = new Vector<String>();
        int displayHintLength = (displayHint = displayHint.trim()).length();
        if (displayHintLength == 0) {
            throw new Exception("The DISPLAY-HINT field is empty");
        }
        int j = 0;
        int k = 1;
        int m = 0;
        int n = 0;
        int i1 = 0;
        boolean i2 = false;
        boolean i3 = false;
        boolean bool = false;
        String str = "";
        while (j < displayHintLength - 1) {
            i2 = false;
            i3 = false;
            bool = false;
            for (m = j; m < displayHintLength; ++m) {
                char displayFormatChar;
                if (!i2 && displayHint.charAt(m) == '*') {
                    ++m;
                    ++j;
                    bool = true;
                }
                if (!Character.isDigit(displayFormatChar = displayHint.charAt(m))) {
                    if (displayFormatChar != 'd' && displayFormatChar != 'x' && displayFormatChar != 'o' && displayFormatChar != 'a' && i2) {
                        throw new Exception("Encountered character other than 'd','x','o','a' after repeat count");
                    }
                    if (!i2) {
                        throw new Exception("Expecting the repeat count number");
                    }
                    k = Integer.parseInt(displayHint.substring(j, m));
                    i3 = true;
                    j = m;
                    break;
                }
                i2 = true;
            }
            if (paramArrayOfByte != null && bool) {
                k = new Byte(paramArrayOfByte[i1]).intValue();
                ++i1;
            }
            if (!i3) {
                throw new Exception("Expecting display format at the end");
            }
            n += k;
            int displaySep = 48;
            repeatCount = 48;
            char c3 = displayHint.charAt(j);
            if (displayHintLength > j + 1) {
                displaySep = displayHint.charAt(j + 1);
                if (displaySep == 42) {
                    throw new Exception("\nThe '*' should not be used as a seperation character");
                }
                if (displaySep > 48 && displaySep < 58) {
                    displaySep = 48;
                    ++j;
                } else if (displayHintLength > (j += 2)) {
                    repeatCount = displayHint.charAt(j);
                    if (repeatCount > 48 && repeatCount < 58) {
                        repeatCount = 48;
                    } else {
                        ++j;
                        if (repeatCount == 42) {
                            throw new Exception("\nThe '*' should not be used as a repeat terminator character");
                        }
                    }
                }
            }
            str = Integer.toString(k) + "*" + c3 + "*" + (char)displaySep + "*" + (char)repeatCount + "*" + bool;
            displayFormat.addElement(str);
        }
        if (paramArrayOfByte != null) {
            int i4 = paramArrayOfByte.length;
            repeatCount = 0;
            if (i4 > n) {
                int i5 = (i4 - n) / k;
                if ((i4 - n) % k != 0) {
                    ++i5;
                }
                while (i5 != 0) {
                    displayFormat.addElement(str);
                    --i5;
                }
            }
        }
        return displayFormat;
    }
}

