/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.table;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.table.BSnmpSequenceElement;
import com.tridium.nSnmp.table.BSnmpTable;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpTableRow
extends BComponent
implements BIStatus {
    public static final Property index = BSnmpTableRow.newProperty((int)0, (String)"1", null);
    public static final Type TYPE = Sys.loadType(BSnmpTableRow.class);

    public String getIndex() {
        return this.getString(index);
    }

    public void setIndex(String v) {
        this.setString(index, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSnmpTable;
    }

    public void changed(Property p, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (context == BSnmpTable.noWrite) {
            return;
        }
        BValue o = this.get(p);
        if (!(o instanceof BStatusValue)) {
            return;
        }
        BSnmpTable tab = (BSnmpTable)this.getParent();
        BSnmpSequenceElement seqElem = (BSnmpSequenceElement)tab.getSequence().get(p.getName());
        if (seqElem == null || !seqElem.getWriteable()) {
            return;
        }
        SnmpVar var = null;
        if (o instanceof BStatusNumeric) {
            var = SnmpUtil.getSnmpVar(((BStatusNumeric)o).getNumeric(), seqElem.getVariableType());
        } else if (o instanceof BStatusEnum) {
            var = SnmpUtil.getSnmpVar(((BStatusEnum)o).getEnum().getOrdinal(), seqElem.getVariableType());
        } else if (o instanceof BStatusString) {
            var = SnmpUtil.getSnmpVar(((BStatusString)o).getValue(), seqElem.getVariableType());
        } else if (o instanceof BStatusBoolean) {
            var = SnmpUtil.getSnmpVar(((BStatusBoolean)o).getValue(), seqElem.getVariableType(), BFacets.makeBoolean());
        } else {
            return;
        }
        BSnmpDevice dev = tab.snmpDev();
        dev.setVar(var, seqElem.getObjectIdentifier() + "." + this.getIndex());
    }

    public BStatus getStatus() {
        BStatusValue[] a = (BStatusValue[])this.getChildren(BStatusValue.class);
        if (a.length == 0) {
            return BStatus.DEFAULT;
        }
        return a[0].getStatus();
    }
}

