/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.table;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.snmptypes.SnmpExceptionVar;
import com.tridium.nSnmp.snmptypes.SnmpNull;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.table.BSnmpSequence;
import com.tridium.nSnmp.table.BSnmpSequenceElement;
import com.tridium.nSnmp.table.BSnmpTableRow;
import com.tridium.nSnmp.table.BSnmpTableWalkMibJob;
import com.tridium.nSnmp.util.DisplayHintParser;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.nSnmp.version3.BSnmpV3Communicator;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpTable
extends BComponent {
    public static final Property objectIdentifier = BSnmpTable.newProperty((int)0, (String)"", null);
    public static final Property sequence = BSnmpTable.newProperty((int)0, (BValue)new BSnmpSequence(), null);
    public static final Property enablePoll = BSnmpTable.newProperty((int)0, (boolean)true, null);
    public static final Action walkMib = BSnmpTable.newAction((int)0, null);
    public static final Action update = BSnmpTable.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpTable.class);
    BSnmpDevice device = null;
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/widgets/table.png");
    public static BasicContext noWrite = new BasicContext();
    private final Map<String, Boolean> oidMismatchWarningsAlreadyLogged = new HashMap<String, Boolean>();

    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    public BSnmpSequence getSequence() {
        return (BSnmpSequence)this.get(sequence);
    }

    public void setSequence(BSnmpSequence v) {
        this.set(sequence, (BValue)v, null);
    }

    public boolean getEnablePoll() {
        return this.getBoolean(enablePoll);
    }

    public void setEnablePoll(boolean v) {
        this.setBoolean(enablePoll, v, null);
    }

    public BOrd walkMib() {
        return (BOrd)this.invoke(walkMib, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snmpDev().registerTable(this);
    }

    public void stopped() throws Exception {
        this.snmpDev().unregisterTable(this);
        super.stopped();
    }

    public BSnmpDevice snmpDev() {
        if (this.device == null) {
            BComplex c = this.getParent();
            while (!(c instanceof BSnmpDevice)) {
                c = c.getParent();
            }
            this.device = (BSnmpDevice)c;
        }
        return this.device;
    }

    public void poll() {
        if (this.getEnablePoll()) {
            this.readTable(null);
        }
    }

    public void doUpdate() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BSnmpTable.this.readTable(null);
            }
        };
        this.snmpDev().snmpNet().postRequest(r);
    }

    public SnmpVarBind[] newSnmpVarBind(long[] oidArray) {
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(oidArray), new SnmpNull());
        return new SnmpVarBind[]{vb};
    }

    public SnmpPDU getNewSnmpPdumsg() {
        BSnmpDevice dev = this.snmpDev();
        if (dev.getSnmpVersion() != 3) {
            return new SnmpPDU(dev, 161);
        }
        return new SnmpV3Message(dev, 165);
    }

    public SnmpPDU getNewSnmpPdumsg(BSnmpDevice dev) {
        if (dev.getVersion() != 3) {
            return new SnmpPDU(dev, 161);
        }
        return new SnmpV3Message(dev, 165);
    }

    public SnmpPDU getSnmpPdu(BSnmpDevice dev, SnmpPDU msg) {
        SnmpPDU pdu = null;
        try {
            if (dev.getVersion() != 3) {
                pdu = (SnmpPDU)dev.snmpNet().sendSyncMessage(msg);
            } else {
                BSnmpV3Communicator snmpCommunicator = BSnmpV3Communicator.getBSnmpV3CommunicatorInstance(dev.snmpNet());
                pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
                if (pdu != null && pdu.getErrindex() != 0) {
                    pdu = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdu;
    }

    void readTable(BSnmpTableWalkMibJob job) {
        SnmpVarBind[] vars;
        BSnmpDevice dev = this.snmpDev();
        BSnmpNetwork net = dev.snmpNet();
        int maxBindings = dev.getMaxVariableBindingsPerRequest();
        boolean useBulkReq = dev.getSnmpVersion() > 2;
        long[] testOid = SnmpUtil.getLongArray(this.getObjectIdentifier());
        int colNdx = testOid.length + 1;
        BSnmpSequenceElement[] seqElms = this.getSequence().getElements();
        if (useBulkReq) {
            vars = this.newSnmpVarBind(testOid);
        } else {
            vars = new SnmpVarBind[seqElms.length];
            for (int i = 0; i < seqElms.length; ++i) {
                BSnmpSequenceElement se = seqElms[i];
                long[] coid = SnmpUtil.getLongArray(se.getObjectIdentifier());
                SnmpOID oid = new SnmpOID(coid);
                vars[i] = new SnmpVarBind(oid, new SnmpNull());
                if (i != 0) continue;
                testOid = coid;
            }
        }
        BSnmpTableRow[] rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
        Hashtable<String, BSnmpTableRow> rowHash = new Hashtable<String, BSnmpTableRow>();
        int cnt = 0;
        int iteration = 0;
        boolean done = false;
        while (!done) {
            int i;
            if (job != null) {
                if (job.walkCanceled) {
                    return;
                }
                job.progress(iteration++);
                if (iteration >= 95) {
                    iteration = 50;
                }
            }
            int firstColNdx = -1;
            SnmpPDU msg = this.getNewSnmpPdumsg();
            if (useBulkReq) {
                msg.setMaxRepetitions(maxBindings);
                msg.addVariableBinding(vars[0]);
            } else {
                for (int i2 = 0; i2 < maxBindings && i2 < vars.length; ++i2) {
                    if (cnt == 0) {
                        firstColNdx = i2;
                    }
                    msg.addVariableBinding(vars[cnt++]);
                    if (cnt < vars.length) continue;
                    cnt = 0;
                }
            }
            msg.setResponseTimeOut(dev.getResponseTimeout().getSeconds() * 1000);
            msg.setRetryCount(dev.getRetryCount());
            SnmpPDU pdu = this.getSnmpPdu(dev, msg);
            if (pdu == null) {
                dev.snmpNet().log().severe("poll failed in " + this.getName());
                return;
            }
            Vector<SnmpVarBind> vals = pdu.getVariableBindings();
            if (vals.size() == 0) break;
            for (i = 0; i < vals.size(); ++i) {
                SnmpVarBind vb = vals.get(i);
                SnmpVar var = vb.getVariable();
                long[] oida = vb.getObjectID().toLongArray();
                if (var instanceof SnmpExceptionVar) {
                    done = true;
                    break;
                }
                if ((useBulkReq || i == firstColNdx) && !this.isOidForMyTable(testOid, oida)) {
                    done = true;
                    break;
                }
                int col = BSnmpTable.findColumnOIDWithinSequenceElements(seqElms, colNdx, (int)oida[colNdx]);
                if (col == -1) {
                    this.logOIDMismatchIfNeeded(vb.getObjectID().toString());
                    continue;
                }
                String rowNdx = SnmpUtil.rowIdFromOid(oida, colNdx);
                vars[useBulkReq ? 0 : i] = vb;
                BSnmpTableRow row = null;
                for (int n = 0; n < rows.length; ++n) {
                    if (!rows[n].getIndex().equals(rowNdx)) continue;
                    row = rows[n];
                    break;
                }
                if (row == null) {
                    Property p = this.add(SlotPath.escape((String)("row" + rowNdx)), (BValue)this.createRow(rowNdx, seqElms), null);
                    row = (BSnmpTableRow)this.get(p);
                    rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
                }
                rowHash.put(rowNdx, row);
                BStatusValue sv = (BStatusValue)row.get(SlotPath.escape((String)seqElms[col].getElementName()));
                try {
                    if (sv instanceof BStatusNumeric) {
                        ((BStatusNumeric)sv).setDouble(BStatusNumeric.value, SnmpUtil.getNumeric(var), (Context)noWrite);
                    } else if (sv instanceof BStatusEnum) {
                        BEnumRange range = (BEnumRange)seqElms[col].getFacets().getFacet("range");
                        ((BStatusEnum)sv).set(BStatusEnum.value, (BValue)SnmpUtil.getEnum(var, range), (Context)noWrite);
                    } else if (sv instanceof BStatusBoolean) {
                        int[] oa;
                        BFacets f = seqElms[col].getFacets();
                        BEnumRange range = (BEnumRange)f.getFacet("range");
                        if (range != null && (oa = range.getOrdinals()).length == 2) {
                            String trueText = range.getTag(oa[0]);
                            String falseText = range.getTag(oa[1]);
                            f = BFacets.make((BFacets)f, (BFacets)BFacets.makeBoolean((String)trueText, (String)falseText));
                        }
                        ((BStatusBoolean)sv).setBoolean(BStatusBoolean.value, SnmpUtil.getBoolean(var, f), (Context)noWrite);
                    } else if (sv instanceof BStatusString) {
                        ((BStatusString)sv).setString(BStatusString.value, this.getDisplayValue(var, seqElms[col].getDisplayHint()), (Context)noWrite);
                    }
                    sv.setStatusNull(false);
                    continue;
                }
                catch (Throwable e) {
                    sv.setStatusNull(true);
                }
            }
            for (i = 0; i < vars.length; ++i) {
                vars[i].setVariable(new SnmpNull());
            }
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rowHash.get(rows[i].getIndex()) != null) continue;
            this.remove((BComplex)rows[i]);
        }
    }

    private static int findColumnOIDWithinSequenceElements(BSnmpSequenceElement[] sequenceElements, int colIndex, int targetOID) {
        for (int i = 0; i < sequenceElements.length; ++i) {
            long oid = SnmpUtil.getLongArray(sequenceElements[i].getObjectIdentifier())[colIndex];
            if (oid != (long)targetOID) continue;
            return i;
        }
        return -1;
    }

    private void logOIDMismatchIfNeeded(String mismatchedObjectId) {
        if (this.oidMismatchWarningsAlreadyLogged.containsKey(mismatchedObjectId)) {
            return;
        }
        BSnmpNetwork net = (BSnmpNetwork)this.snmpDev().getNetwork();
        String msg = "Column OID match was not found for object " + mismatchedObjectId + ". This warning will appear once but could be happening during every table read.";
        net.getLogger().warning(msg);
        this.oidMismatchWarningsAlreadyLogged.put(mismatchedObjectId, true);
    }

    private String getDisplayValue(SnmpVar var, String displayHint) {
        String displayValue = var instanceof SnmpString ? DisplayHintParser.stringDisplay(((SnmpString)var).getRawData(), displayHint) : SnmpUtil.getString(var);
        return displayValue;
    }

    private boolean isOidForMyTable(long[] myOid, long[] aOid) {
        if (aOid.length < myOid.length) {
            return false;
        }
        for (int i = 0; i < myOid.length; ++i) {
            if (aOid[i] == myOid[i]) continue;
            return false;
        }
        return true;
    }

    public BOrd doWalkMib() {
        if (!this.snmpDev().isActive()) {
            throw new LocalizableRuntimeException("snmp", "walkMib.deviceInactive");
        }
        return new BSnmpTableWalkMibJob(this.snmpDev(), this).submit(null);
    }

    private BSnmpTableRow createRow(String rowId, BSnmpSequenceElement[] seqs) {
        BSnmpTableRow row = new BSnmpTableRow();
        row.setIndex(rowId);
        for (int i = 0; i < seqs.length; ++i) {
            int flags;
            BStatusValue elem = seqs[i].getElementType().getInstance();
            int n = flags = seqs[i].getWriteable() ? 0 : 1;
            if (seqs[i].getFacets().isNull()) {
                row.add(SlotPath.escape((String)seqs[i].getElementName()), (BValue)elem, flags);
                continue;
            }
            row.add(SlotPath.escape((String)seqs[i].getElementName()), (BValue)elem, flags, seqs[i].getFacets(), null);
        }
        return row;
    }

    public void updateStatus() {
        try {
            BSnmpDevice dev = this.snmpDev();
            boolean isDown = dev.isDown();
            boolean isFault = dev.isFault();
            boolean isDisabled = dev.isDisabled();
            BSnmpTableRow[] rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
            for (int i = 0; i < rows.length; ++i) {
                BStatusValue[] va = (BStatusValue[])rows[i].getChildren(BStatusValue.class);
                for (int n = 0; n < va.length; ++n) {
                    int status;
                    int newStatus = status = va[n].getStatus().getBits();
                    newStatus = isDisabled ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
                    newStatus = isDown ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
                    newStatus = isFault ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
                    if (status == newStatus) continue;
                    va[n].set(BStatusValue.status, (BValue)BStatus.make((int)newStatus), (Context)noWrite);
                }
            }
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

