/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.point.agent;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.IAccessNetwork;
import com.tridium.nSnmp.point.agent.BSnmpAgentPointFolder;
import com.tridium.nSnmp.point.agent.BSnmpAgentProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpAgentPointDeviceExt
extends BPointDeviceExt {
    public static final Action findNextInputIndex = BSnmpAgentPointDeviceExt.newAction((int)6, (BValue)BInteger.make((int)1), null);
    public static final Action findNextOutputIndex = BSnmpAgentPointDeviceExt.newAction((int)6, (BValue)BInteger.make((int)1), null);
    public static final Type TYPE = Sys.loadType(BSnmpAgentPointDeviceExt.class);

    public BInteger findNextInputIndex(BInteger offset) {
        return (BInteger)this.invoke(findNextInputIndex, (BValue)offset, null);
    }

    public BInteger findNextOutputIndex(BInteger offset) {
        return (BInteger)this.invoke(findNextOutputIndex, (BValue)offset, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BSnmpAgent.TYPE;
    }

    public Type getProxyExtType() {
        return BSnmpAgentProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return BSnmpAgentPointFolder.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSnmpAgent;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        try {
            IAccessNetwork snmpNetwork = (IAccessNetwork)this.getParent();
            if (snmpNetwork.snmpNet() != null) {
                BControlPoint[] points = this.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    if (!(points[i].getProxyExt() instanceof BSnmpAgentProxyExt)) continue;
                    snmpNetwork.snmpNet().registerIoObject((BSnmpAgentProxyExt)points[i].getProxyExt());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void childParented(Property prop, BValue newChild, Context context) {
        super.childParented(prop, newChild, context);
        try {
            IAccessNetwork snmpNetwork;
            if (newChild instanceof BControlPoint && ((BControlPoint)newChild).getProxyExt() instanceof BSnmpAgentProxyExt && (snmpNetwork = (IAccessNetwork)this.getParent()).snmpNet() != null) {
                snmpNetwork.snmpNet().registerIoObject((BSnmpAgentProxyExt)((BControlPoint)newChild).getProxyExt());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void childUnparented(Property prop, BValue oldChild, Context context) {
        super.childUnparented(prop, oldChild, context);
        try {
            if (oldChild instanceof BControlPoint) {
                IAccessNetwork snmpNetwork = (IAccessNetwork)this.getParent();
                if (((BControlPoint)oldChild).getProxyExt() instanceof BSnmpAgentProxyExt && snmpNetwork.snmpNet() != null) {
                    snmpNetwork.snmpNet().unregisterIoObject((BSnmpAgentProxyExt)((BControlPoint)oldChild).getProxyExt());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public BInteger doFindNextInputIndex(BInteger offset) {
        int startIndex = offset.getInt();
        IAccessNetwork snmpNetwork = (IAccessNetwork)this.getParent();
        int nextIndex = snmpNetwork.snmpNet().inputs().getNextIndex(startIndex);
        return BInteger.make((int)nextIndex);
    }

    public BInteger doFindNextOutputIndex(BInteger offset) {
        int startIndex = offset.getInt();
        IAccessNetwork snmpNetwork = (IAccessNetwork)this.getParent();
        int nextIndex = snmpNetwork.snmpNet().outputs().getNextIndex(startIndex);
        return BInteger.make((int)nextIndex);
    }
}

