/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.point.agent;

import com.tridium.nSnmp.datatypes.BSnmpAgentStringDefaultValue;
import com.tridium.nSnmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.control.BEnumPoint;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpAgentEnumProxyExt
extends BSnmpAgentProxyExt {
    public static final Property defaultValue = BSnmpAgentEnumProxyExt.newProperty((int)0, (BValue)new BSnmpAgentStringDefaultValue(), null);
    public static final Action resetPointToDefault = BSnmpAgentEnumProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpAgentEnumProxyExt.class);

    public BSnmpAgentStringDefaultValue getDefaultValue() {
        return (BSnmpAgentStringDefaultValue)this.get(defaultValue);
    }

    public void setDefaultValue(BSnmpAgentStringDefaultValue v) {
        this.set(defaultValue, (BValue)v, null);
    }

    public void resetPointToDefault() {
        this.invoke(resetPointToDefault, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)defaultValue, 4);
            this.setFlags((Slot)resetPointToDefault, 4);
        } else {
            this.doResetPointToDefault();
        }
    }

    public void doResetPointToDefault() {
        String tag;
        BEnumRange range = (BEnumRange)this.getDeviceFacets().getFacet("range");
        if (range.isTag(tag = this.getDefaultValue().getDefaultValue())) {
            this.readOk((BStatusValue)new BStatusEnum(range.get(tag)));
        }
    }

    @Override
    public SnmpVar getValue() {
        BEnumPoint pnt = (BEnumPoint)this.getParentPoint();
        return SnmpUtil.getSnmpVar(pnt.getEnum(), this.getVariableType());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        BEnumRange range = (BEnumRange)this.getDeviceFacets().getFacet("range");
        SnmpUtil.getEnum(var, range);
    }

    @Override
    public SnmpVar setValue(SnmpVar var) {
        try {
            BEnumRange range = (BEnumRange)this.getDeviceFacets().getFacet("range");
            BEnum v = SnmpUtil.getEnum(var, range);
            this.readOk((BStatusValue)new BStatusEnum(v));
            this.getParentPoint().doExecute();
            return this.getValue();
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }
}

