/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.point.agent;

import com.tridium.nSnmp.datatypes.BSnmpAgentBooleanDefaultValue;
import com.tridium.nSnmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpAgentBooleanProxyExt
extends BSnmpAgentProxyExt {
    public static final Property defaultValue = BSnmpAgentBooleanProxyExt.newProperty((int)0, (BValue)new BSnmpAgentBooleanDefaultValue(), null);
    public static final Action resetPointToDefault = BSnmpAgentBooleanProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpAgentBooleanProxyExt.class);

    public BSnmpAgentBooleanDefaultValue getDefaultValue() {
        return (BSnmpAgentBooleanDefaultValue)this.get(defaultValue);
    }

    public void setDefaultValue(BSnmpAgentBooleanDefaultValue v) {
        this.set(defaultValue, (BValue)v, null);
    }

    public void resetPointToDefault() {
        this.invoke(resetPointToDefault, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)defaultValue, 4);
            this.setFlags((Slot)resetPointToDefault, 4);
        } else {
            this.doResetPointToDefault();
        }
    }

    public void doResetPointToDefault() {
        this.readOk((BStatusValue)new BStatusBoolean(this.getDefaultValue().getDefaultValue()));
    }

    @Override
    public SnmpVar getValue() {
        BBooleanPoint pnt = (BBooleanPoint)this.getParentPoint();
        return SnmpUtil.getSnmpVar(pnt.getBoolean(), this.getVariableType(), this.getDeviceFacets());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        SnmpUtil.getBoolean(var, this.getDeviceFacets());
    }

    @Override
    public SnmpVar setValue(SnmpVar var) {
        try {
            boolean bval = SnmpUtil.getBoolean(var, this.getDeviceFacets());
            this.readOk((BStatusValue)new BStatusBoolean(bval));
            if (this.getDefaultValue().getAutoSet()) {
                this.getDefaultValue().setDefaultValue(bval);
            }
            this.getParentPoint().doExecute();
            return this.getValue();
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }
}

