/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.point;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.messages.SnmpWriteAsyncRequest;
import com.tridium.nSnmp.point.BSnmpPointDeviceExt;
import com.tridium.nSnmp.snmptypes.SnmpNull;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.ndriver.point.BNProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSnmpProxyExt
extends BNProxyExt {
    public static final Property objectIdentifier = BSnmpProxyExt.newProperty((int)0, (String)"", null);
    public static final Property variableType = BSnmpProxyExt.newProperty((int)1, (BValue)BSnmpVariableTypeEnum.integerType, null);
    public static final Property displayHint = BSnmpProxyExt.newProperty((int)0, (String)"", null);
    public static final Action forceRead = BSnmpProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpProxyExt.class);
    public static final String ILLEGAL_OID = "Illegal Object Identifier";
    protected boolean configFault = false;
    protected boolean currentlySubscribed = false;

    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return (BSnmpVariableTypeEnum)this.get(variableType);
    }

    public void setVariableType(BSnmpVariableTypeEnum v) {
        this.set(variableType, (BValue)v, null);
    }

    public String getDisplayHint() {
        return this.getString(displayHint);
    }

    public void setDisplayHint(String v) {
        this.setString(displayHint, v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BSnmpPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isValidOID()) {
            this.configFault = true;
            this.readFail(ILLEGAL_OID);
        } else {
            this.configFault = false;
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == objectIdentifier) {
            if (!this.isValidOID()) {
                this.configFault = true;
                this.readFail(ILLEGAL_OID);
            } else {
                this.configFault = false;
                this.setStale(true, null);
                if (this.getParentPoint().isWritablePoint()) {
                    this.getTuning().writeDesired();
                }
            }
        } else if (prop == variableType && this.getParentPoint().isWritablePoint()) {
            this.getTuning().writeDesired();
        }
    }

    public boolean write(Context cx) throws Exception {
        if (this.configFault || !this.getParentPoint().isWritablePoint()) {
            return false;
        }
        BStatusValue out = this.getWriteValue();
        if (out.getStatus().isNull()) {
            return false;
        }
        try {
            this.snmpNet().postRequest(new SnmpWriteAsyncRequest(this, out));
        }
        catch (Exception e) {
            this.snmpNet().log().severe("Could not post write for " + this.getParentPoint().getName());
            this.writeFail(BSnmpNetwork.lex.getText("postWriteFail") + ": " + e);
            return false;
        }
        return true;
    }

    public void readSubscribed(Context cx) throws Exception {
        if (this.currentlySubscribed) {
            return;
        }
        this.currentlySubscribed = true;
    }

    public void readUnsubscribed(Context cx) throws Exception {
        if (!this.currentlySubscribed) {
            return;
        }
        this.currentlySubscribed = false;
    }

    public synchronized BSnmpNetwork snmpNet() {
        BDevice device = this.getDevice();
        if (device == null || !(device instanceof BSnmpDevice)) {
            return null;
        }
        return ((BSnmpDevice)device).getSnmpNetwork();
    }

    public boolean isValidOID() {
        long[] a;
        SnmpOID oid = new SnmpOID(this.getObjectIdentifier());
        return oid.isValid() && (a = oid.toValue()).length >= 2;
    }

    public boolean isCurrentlySubscribed() {
        return this.currentlySubscribed;
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public abstract void setValue(SnmpVar var1);

    public void doWrite(BStatusValue out) {
        BSnmpNetwork net = this.snmpNet();
        if (net == null || !net.isCommActive() || this.configFault) {
            return;
        }
        if (this.getParentPoint().isWritablePoint()) {
            SnmpVar var = this.getVariable(out);
            if (var == null) {
                this.writeFail("Cannot write null SNMP variable value");
                return;
            }
            int errRtn = ((BSnmpDevice)this.getDevice()).setVar(var, this.getObjectIdentifier());
            if (errRtn == 0) {
                this.writeOk(out);
            } else if (errRtn == -1) {
                this.writeFail("No response to SNMP write request");
            } else {
                this.writeFail(SnmpPDU.translateErrorStatus(errRtn));
            }
        }
    }

    protected abstract SnmpVar getVariable(BStatusValue var1);

    public void doForceRead() {
        BSnmpDevice dev = (BSnmpDevice)this.getDevice();
        SnmpPDU msg = new SnmpPDU(dev, 160);
        SnmpOID oid = new SnmpOID(this.getObjectIdentifier());
        msg.addVariableBinding(new SnmpVarBind(oid, new SnmpNull()));
        msg.setRetryCount(dev.getRetryCount());
        msg.setResponseTimeOut(dev.getResponseTimeout().getSeconds() * 1000);
        SnmpPDU pdu = null;
        try {
            pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
            if (pdu == null) {
                this.snmpNet().log().severe("doForceRead failed in " + dev.getName() + ":" + this.getParent().getName());
                return;
            }
        }
        catch (Exception e) {
            this.snmpNet().log().severe("doForceRead failed in " + dev.getName() + ":" + this.getParent().getName());
            return;
        }
        SnmpVarBind vb = pdu.getVariableBindings().elementAt(0);
        if (!oid.equals(vb.getObjectID())) {
            this.snmpNet().log().severe("doForceRead failed in " + dev.getName() + ":" + this.getParent().getName());
            return;
        }
        this.setValue(vb.getVariable());
    }

    public static BFacets adjustFacets(BFacets f, BSnmpVariableTypeEnum typ) {
        return f;
    }
}

