/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.enums.BSnmpAccessEnum;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.mib.MibConst;
import com.tridium.nSnmp.mib.MibObject;
import com.tridium.nSnmp.mib.OidElement;
import com.tridium.nSnmp.mib.OidEntry;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpExceptionVar;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import java.util.StringTokenizer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;

public class GenericMib
implements MibConst,
SnmpConst {
    private OidElement oidBase = new OidElement(1L);
    protected BSnmpNetwork snmp;
    public static final String SYSTEM_DESCR = "1.3.6.1.2.1.1.1.0";
    public static final String SYSTEM_OBJECT_ID = "1.3.6.1.2.1.1.2.0";
    public static final String SYSTEM_UP_TIME = "1.3.6.1.2.1.1.3.0";
    public static final String SYSTEM_CONTACT = "1.3.6.1.2.1.1.4.0";
    public static final String SYSTEM_NAME = "1.3.6.1.2.1.1.5.0";
    public static final String SYSTEM_LOCATION = "1.3.6.1.2.1.1.6.0";
    public static final String SYSTEM_SERVICES = "1.3.6.1.2.1.1.7.0";
    public static final String MIBII_SNMP = "1.3.6.1.2.1.11";
    public static final String SNMP_V2_TRAP_OID = "1.3.6.1.6.3.1.1.4.1.0";

    public GenericMib(BSnmpNetwork snmp) {
        this.snmp = snmp;
    }

    public int validateForSet(SnmpVarBind var, SnmpPDU resp, int ver) {
        SnmpOID oid = var.getObjectID();
        OidElement element = this.findElement(oid.toLongArray());
        int err = 0;
        err = element == null || !element.isOidEntry() ? 11 : ((OidEntry)element).getMibObject().validateForSet(var);
        if (ver == 0) {
            err = this.makeV1Error(err);
        }
        return err;
    }

    private int makeV1Error(int err) {
        if (err < 6) {
            return err;
        }
        switch (err) {
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 17: {
                return 4;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                return 5;
            }
        }
        return 5;
    }

    public int processSet(SnmpVarBind var, SnmpPDU resp, int ver) {
        SnmpOID oid = var.getObjectID();
        OidElement element = this.findElement(oid.toLongArray());
        if (element == null || !element.isOidEntry()) {
            return ver == 0 ? 2 : 6;
        }
        return ((OidEntry)element).getMibObject().setValue(var, resp);
    }

    public int processGet(SnmpOID oid, SnmpPDU resp, int ver) {
        OidElement element = this.findElement(oid.toLongArray());
        SnmpVar respVar = null;
        if (element == null || !element.isOidEntry()) {
            if (ver == 0) {
                return 2;
            }
            respVar = new SnmpExceptionVar(128);
        } else {
            respVar = ((OidEntry)element).getMibObject().getValue(oid);
            if (respVar == null) {
                if (ver == 0) {
                    return 2;
                }
                respVar = new SnmpExceptionVar(129);
            }
        }
        resp.addVariableBinding(new SnmpVarBind(oid, respVar));
        return 0;
    }

    public SnmpVarBind processGetNext(SnmpOID oid) {
        OidEntry entry = this.findNext(oid);
        if (entry == null) {
            return null;
        }
        SnmpOID soid = null;
        SnmpVar respVar = null;
        switch (entry.entryType) {
            case 4: {
                MibObject obj = entry.mibObj;
                soid = obj.getNextOid(oid);
                respVar = obj.getValue(soid);
                break;
            }
            default: {
                soid = new SnmpOID(entry.getOid());
                respVar = entry.mibObj.getValue(soid);
            }
        }
        return new SnmpVarBind(soid, respVar);
    }

    protected OidElement findElement(long[] oid) {
        OidElement element = this.oidBase;
        int level = 1;
        while (level < oid.length) {
            if ((element = element.getChild(oid[level++])) == null) {
                return null;
            }
            if (!element.isOidEntry()) continue;
            return element;
        }
        return element;
    }

    protected OidEntry findNext(SnmpOID oid) {
        OidEntry oe = (OidEntry)this.findElementForNext(oid.toLongArray());
        do {
            if (oe == null) {
                return null;
            }
            if (oe.entryType == 3) {
                return oe;
            }
            SnmpOID nxtOid = oe.mibObj.getNextOid(oid);
            if (nxtOid == null) continue;
            return oe;
        } while ((oe = this.findNextEntry(oe)) != null);
        return null;
    }

    private OidElement findElementForNext(long[] oid) {
        OidElement element = this.oidBase;
        for (int level = 1; level < oid.length; ++level) {
            long oNdx = oid[level];
            OidElement child = element.child;
            while (true) {
                if (child == null) {
                    return null;
                }
                if (child.index == oNdx) break;
                if (child.index > oNdx) {
                    return this.bury(child);
                }
                child = child.next;
            }
            element = child;
            if (!element.isOidEntry()) continue;
            break;
        }
        if (!element.isOidEntry()) {
            return this.bury(element);
        }
        if (element.entryType == 3) {
            return this.findNextEntry((OidEntry)element);
        }
        return element;
    }

    private OidElement bury(OidElement e) {
        OidElement nxt = e;
        while (!nxt.isOidEntry()) {
            nxt = nxt.child;
        }
        return nxt;
    }

    private OidEntry findNextEntry(OidEntry entry) {
        OidEntry[] entries = this.getOidEntries();
        for (int i = 0; i < entries.length - 1; ++i) {
            if (entries[i] != entry) continue;
            return entries[i + 1];
        }
        return null;
    }

    protected OidEntry findOidEntry(SnmpOID oid) {
        OidEntry[] entries = this.getOidEntries();
        String sOid = oid.toString();
        String properOID = sOid + ".0";
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].oid.compareTo(sOid) != 0 && entries[i].oid.compareTo(properOID) != 0) continue;
            return entries[i];
        }
        return null;
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    protected void init() {
    }

    protected void addOidEntry(String oid, int type, String status, BSnmpAccessEnum access, MibObject mib, String name, String desc) {
        OidElement element = this.oidBase;
        StringTokenizer tok = new StringTokenizer(oid, ".");
        tok.nextElement();
        long ndx = Long.parseLong((String)tok.nextElement());
        while (tok.hasMoreElements()) {
            OidElement child = element.getChild(ndx);
            if (child == null) {
                child = new OidElement(ndx);
                element.addChild(child);
            }
            element = child;
            ndx = Long.parseLong((String)tok.nextElement());
        }
        element.addChild(new OidEntry(oid, type, name, status, desc, mib, ndx, access));
    }

    public OidEntry[] getOidEntries() {
        return this.oidBase.getOidEntries();
    }

    public OidElement getOidBase() {
        return this.oidBase;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(true);
        out.w((Object)"<tr>").th((Object)(this.getName() + " as of " + BAbsTime.now())).w((Object)"</tr>\n");
        this.spyElem(out, this.oidBase);
        out.endTable();
    }

    private void spyElem(SpyWriter out, OidElement oe) {
        out.tr((Object)oe.toString());
        if (oe.child != null) {
            this.spyElem(out, oe.child);
        }
        if (oe.next != null) {
            this.spyElem(out, oe.next);
        }
    }

    public void dump() {
        System.out.println(this.getName() + " as of " + BAbsTime.now());
        this.dumpElem(this.oidBase);
    }

    private void dumpElem(OidElement oe) {
        System.out.println((oe instanceof OidEntry ? "Entry:" : "Elem :") + oe.toString());
        if (oe.child != null) {
            this.dumpElem(oe.child);
        }
        if (oe.next != null) {
            this.dumpElem(oe.next);
        }
    }

    protected String getName() {
        return "GenericMib";
    }
}

