/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.export;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.export.BISnmpExportFolder;
import com.tridium.nSnmp.export.BSnmpExportTable;
import com.tridium.nSnmp.mib.table.PointContainer;
import com.tridium.nSnmp.mib.table.PointEntry;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSnmpExportObject
extends BComponent
implements PointEntry,
BIStatus {
    public static final Property status = BSnmpExportObject.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BSnmpExportObject.newProperty((int)3, (String)"", null);
    public static final Property objectOrd = BSnmpExportObject.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property objectIdentifier = BSnmpExportObject.newProperty((int)65, (String)"", null);
    public static final Property deviceFacets = BSnmpExportObject.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Type TYPE = Sys.loadType(BSnmpExportObject.class);
    int lastHash = -1;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getObjectOrd() {
        return (BOrd)this.get(objectOrd);
    }

    public void setObjectOrd(BOrd v) {
        this.set(objectOrd, (BValue)v, null);
    }

    @Override
    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    @Override
    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    public BFacets getDeviceFacets() {
        return (BFacets)this.get(deviceFacets);
    }

    public void setDeviceFacets(BFacets v) {
        this.set(deviceFacets, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return BSnmpVariableTypeEnum.stringType;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == objectOrd) {
            try {
                PointContainer pc = this.getPointContainer();
                this.faultCheck();
                this.getObject();
                if (this.getStatus().isFault()) {
                    pc.unregisterIoObject(this);
                    return;
                }
                if (!this.isValidObjId(pc)) {
                    pc.unregisterIoObject(this);
                    this.initObjId(pc);
                }
                pc.registerIoObject(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void started() throws Exception {
        super.started();
        this.faultCheck();
        this.getObject();
        if (this.getStatus().isFault()) {
            return;
        }
        PointContainer pc = this.getPointContainer();
        if (!this.isValidObjId(pc)) {
            this.initObjId(pc);
        }
        pc.registerIoObject(this);
    }

    private void initObjId(PointContainer pc) {
        String oid = pc.getObjectIdentifier() + (this.isSettablePoint() ? ".1.1.3.0" : ".2.1.3.0");
        this.setObjectIdentifier(oid);
    }

    private boolean isValidObjId(PointContainer pc) {
        if (this.isSettablePoint()) {
            return this.getObjectIdentifier().indexOf(pc.getObjectIdentifier() + ".1.1.3") == 0;
        }
        return this.getObjectIdentifier().indexOf(pc.getObjectIdentifier() + ".2.1.3") == 0;
    }

    public void stopped() throws Exception {
        try {
            this.getPointContainer().unregisterIoObject(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopped();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISnmpExportFolder;
    }

    public BControlPoint getObject() {
        try {
            return (BControlPoint)this.getObjectOrd().get((BObject)this.getComponentSpace());
        }
        catch (Exception e) {
            this.setFail("Unable to resolve objectOrd.");
            return null;
        }
    }

    private void faultCheck() {
        BSnmpExportTable exports = null;
        BSnmpAgent local = null;
        BSnmpNetwork network = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BSnmpExportTable) {
                exports = (BSnmpExportTable)parent;
                continue;
            }
            if (!(parent instanceof BSnmpAgent)) continue;
            local = (BSnmpAgent)parent;
            break;
        }
        if (exports == null || local == null) {
            this.setFail("Not under Snmp Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.setFail("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BSnmpNetwork)local.getParent();
        if (network == null) {
            this.setFail("Not under SnmpNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.setFail("Network fault: " + network.getFaultCause());
            return;
        }
        this.setOk();
    }

    public BISnmpExportFolder getFolder() {
        return (BISnmpExportFolder)this.getParent();
    }

    public PointContainer getPointContainer() {
        return (PointContainer)this.getParent();
    }

    @Override
    public int getIndex() {
        return SnmpUtil.getIndex(this.getObjectIdentifier());
    }

    @Override
    public void setIndex(int ndx) {
        this.setObjectIdentifier(SnmpUtil.replaceIndex(this.getObjectIdentifier(), ndx));
    }

    @Override
    public String getPointName() {
        return this.getName();
    }

    @Override
    public int getLastHash() {
        return this.lastHash;
    }

    @Override
    public void setLastHash(int n) {
        this.lastHash = n;
    }

    @Override
    public boolean isSettablePoint() {
        return this.getObject().isWritablePoint();
    }

    public String toString(Context context) {
        return this.getName() + " (" + this.getObjectIdentifier() + ")";
    }

    protected void setOk() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    protected void setFail(String cause) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(cause);
    }
}

