/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.datatypes;

import java.net.InetAddress;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNetworkManagerConfiguration
extends BStruct {
    public static final Property routeAlarmsToNetworkManager = BNetworkManagerConfiguration.newProperty((int)0, (boolean)true, null);
    public static final Property useDefaultNetworkManager = BNetworkManagerConfiguration.newProperty((int)0, (boolean)true, null);
    public static final Property networkManagerIpAddress = BNetworkManagerConfiguration.newProperty((int)0, (String)"", null);
    public static final Property networkManagerTrapsPort = BNetworkManagerConfiguration.newProperty((int)0, (int)162, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property networkManagerSnmpVersion = BNetworkManagerConfiguration.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)3));
    public static final Property networkManagerTrapsCommunity = BNetworkManagerConfiguration.newProperty((int)0, (String)"public", null);
    public static final Type TYPE = Sys.loadType(BNetworkManagerConfiguration.class);

    public boolean getRouteAlarmsToNetworkManager() {
        return this.getBoolean(routeAlarmsToNetworkManager);
    }

    public void setRouteAlarmsToNetworkManager(boolean v) {
        this.setBoolean(routeAlarmsToNetworkManager, v, null);
    }

    public boolean getUseDefaultNetworkManager() {
        return this.getBoolean(useDefaultNetworkManager);
    }

    public void setUseDefaultNetworkManager(boolean v) {
        this.setBoolean(useDefaultNetworkManager, v, null);
    }

    public String getNetworkManagerIpAddress() {
        return this.getString(networkManagerIpAddress);
    }

    public void setNetworkManagerIpAddress(String v) {
        this.setString(networkManagerIpAddress, v, null);
    }

    public int getNetworkManagerTrapsPort() {
        return this.getInt(networkManagerTrapsPort);
    }

    public void setNetworkManagerTrapsPort(int v) {
        this.setInt(networkManagerTrapsPort, v, null);
    }

    public int getNetworkManagerSnmpVersion() {
        return this.getInt(networkManagerSnmpVersion);
    }

    public void setNetworkManagerSnmpVersion(int v) {
        this.setInt(networkManagerSnmpVersion, v, null);
    }

    public String getNetworkManagerTrapsCommunity() {
        return this.getString(networkManagerTrapsCommunity);
    }

    public void setNetworkManagerTrapsCommunity(String v) {
        this.setString(networkManagerTrapsCommunity, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNetworkManagerConfiguration(boolean routeAlarms, boolean useDefault, String managerIp, int managerPort, String managerCommunity) {
        this.setRouteAlarmsToNetworkManager(routeAlarms);
        this.setUseDefaultNetworkManager(useDefault);
        this.setNetworkManagerIpAddress(managerIp);
        this.setNetworkManagerTrapsPort(managerPort);
        this.setNetworkManagerTrapsCommunity(managerCommunity);
    }

    public BNetworkManagerConfiguration() {
    }

    public InetAddress getManagerIp() {
        try {
            return InetAddress.getByName(this.getNetworkManagerIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }
}

