/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp;

import com.tridium.nSnmp.BSnmpDeviceFolder;
import com.tridium.nSnmp.BSnmpMibServer;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.IAccessNetwork;
import com.tridium.nSnmp.datatypes.BCreateMibParameters;
import com.tridium.nSnmp.export.BSnmpExportTable;
import com.tridium.nSnmp.point.agent.BSnmpAgentPointDeviceExt;
import com.tridium.nSnmp.util.LocalToMib;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUserTable;
import com.tridium.nSnmp.version3.vacm.BVacmAccessTable;
import com.tridium.nSnmp.version3.vacm.BVacmContextTable;
import com.tridium.nSnmp.version3.vacm.BVacmGroupTable;
import com.tridium.nSnmp.version3.vacm.BVacmViewTreeTable;
import com.tridium.nSnmp.version3.vacm.SnmpVACMTablesFactory;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="points", type="BPointDeviceExt", defaultValue="new BSnmpAgentPointDeviceExt()"), @NiagaraProperty(name="exports", type="BSnmpExportTable", defaultValue="new BSnmpExportTable()"), @NiagaraProperty(name="mipServer", type="BSnmpMibServer", defaultValue="new BSnmpMibServer()"), @NiagaraProperty(name="status", type="BStatus", flags=75, defaultValue="BStatus.ok"), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="health", type="BPingHealth", defaultValue="new BPingHealth()", flags=65), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraActions(value={@NiagaraAction(name="createMib", parameterType="BCreateMibParameters", returnType="BString", defaultValue="new BCreateMibParameters()", flags=4), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", returnType="BBoolean", defaultValue="new BAlarmRecord()", flags=4)})
public class BSnmpAgent
extends BComponent
implements BIPingable,
IAccessNetwork {
    public static final Property points = BSnmpAgent.newProperty((int)0, (BValue)new BSnmpAgentPointDeviceExt(), null);
    public static final Property exports = BSnmpAgent.newProperty((int)0, (BValue)new BSnmpExportTable(), null);
    public static final Property mipServer = BSnmpAgent.newProperty((int)0, (BValue)new BSnmpMibServer(), null);
    public static final Property status = BSnmpAgent.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enabled = BSnmpAgent.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BSnmpAgent.newProperty((int)67, (String)"", null);
    public static final Property health = BSnmpAgent.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BSnmpAgent.newProperty((int)0, (BValue)BSnmpAgent.initAlarmSourceInfo(), null);
    public static final Action createMib = BSnmpAgent.newAction((int)4, (BValue)new BCreateMibParameters(), null);
    public static final Action ackAlarm = BSnmpAgent.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSnmpAgent.class);
    private static final BIcon icon = BIcon.std((String)"deviceLocal.png");
    private BSnmpNetwork network;
    private boolean fatalFault;
    private boolean configFault;
    private int oldStatus = 0;
    private static final Logger logger = Logger.getLogger("snmp.agent");

    public BPointDeviceExt getPoints() {
        return (BPointDeviceExt)this.get(points);
    }

    public void setPoints(BPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BSnmpExportTable getExports() {
        return (BSnmpExportTable)this.get(exports);
    }

    public void setExports(BSnmpExportTable v) {
        this.set(exports, (BValue)v, null);
    }

    public BSnmpMibServer getMipServer() {
        return (BSnmpMibServer)this.get(mipServer);
    }

    public void setMipServer(BSnmpMibServer v) {
        this.set(mipServer, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BString createMib(BCreateMibParameters parameter) {
        return (BString)this.invoke(createMib, (BValue)parameter, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault(null);
        this.doPing();
    }

    public int getEnterprise() {
        return SnmpUtil.getIndex(this.snmpNet().getEnterprise());
    }

    protected IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        this.pingOk();
    }

    public void pingOk() {
        this.getHealth().pingOk();
    }

    public void pingFail(String cause) {
        this.getHealth().pingFail(cause);
    }

    public Type getNetworkType() {
        return BSnmpNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSnmpNetwork || parent instanceof BSnmpDeviceFolder;
    }

    @Override
    public BSnmpNetwork snmpNet() {
        return this.getNetwork();
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!(value instanceof BVacmContextTable || value instanceof BVacmAccessTable || value instanceof BVacmGroupTable || value instanceof BVacmViewTreeTable || value instanceof BUsmUserTable)) {
            return;
        }
        super.checkAdd(name, value, flags, facets, context);
        BComponent[] components = this.getChildComponents();
        for (int index = 0; index < components.length; ++index) {
            if (components[index] instanceof BVacmContextTable && value instanceof BVacmContextTable) {
                throw new LocalizableRuntimeException("nSnmp", "addVacmContextTableError");
            }
            if (components[index] instanceof BVacmAccessTable && value instanceof BVacmAccessTable) {
                throw new LocalizableRuntimeException("nSnmp", "addVacmAccessTableError");
            }
            if (components[index] instanceof BVacmGroupTable && value instanceof BVacmGroupTable) {
                throw new LocalizableRuntimeException("nSnmp", "addVacmGroupTableError");
            }
            if (components[index] instanceof BVacmViewTreeTable && value instanceof BVacmViewTreeTable) {
                throw new LocalizableRuntimeException("nSnmp", "addVacmViewTreeTableError");
            }
            if (components[index] instanceof BUsmUserTable && value instanceof BUsmUserTable) {
                throw new LocalizableRuntimeException("nSnmp", "addUsmUserTableError");
            }
            SnmpVACMTablesFactory.setTableComponent(value);
            if (!(value instanceof BUsmUserTable)) continue;
            BUsmUserTable.setUsmUserTable((BUsmUserTable)value);
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final BDeviceExt[] getDeviceExts() {
        return (BDeviceExt[])this.getChildren(BDeviceExt.class);
    }

    public final void updateStatus() {
        BStatus network;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = network = this.network == null ? BStatus.ok : this.network.getStatus();
        newStatus = !this.getEnabled() || network.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.getHealth().getDown() || network.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault || this.configFault || network.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        BDeviceExt[] exts = this.getDeviceExts();
        for (int i = 0; i < exts.length; ++i) {
            try {
                exts[i].updateStatus();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    public void ping() {
        this.doPing();
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getHealth().doAckAlarm(ackRequest);
    }

    public BComponent getAssociatedDevice(BSnmpAgentPointDeviceExt pointDeviceExt) {
        return (BComponent)pointDeviceExt.getParent();
    }

    public final BSnmpNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    protected static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return asi;
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public BString doCreateMib(BCreateMibParameters p) {
        String rtn = LocalToMib.createMib(this, p);
        return BString.make((String)rtn);
    }

    public BIcon getIcon() {
        return icon;
    }

    private void checkFatalFault(String badGroups) {
        BSnmpNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BSnmpNetwork)) continue;
            network = (BSnmpNetwork)parent;
            break;
        }
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (!network.getType().is(this.getNetworkType())) {
            this.fatalFault = true;
            this.setFaultCause("Parent DeviceNetwork " + network.getType() + " is not " + this.getNetworkType());
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        this.network = network;
        this.setFaultCause("");
    }
}

