/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.pin;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.pin.BPinPad;
import com.tridium.wiresheet.pin.SlotModel;
import com.tridium.workbench.util.SlotBarUtil;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;

public class SlotRenderer
extends TableCellRenderer {
    static BImage pinIcon = BImage.make((String)"module://icons/x16/pushPin.png");
    BPinPad pad;
    SlotModel model;

    public SlotRenderer(BPinPad pad, SlotModel model) {
        this.pad = pad;
        this.model = model;
    }

    public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
        Slot slot = (Slot)cell.value;
        double wixelWidth = cell.width / (double)this.model.glyph.ws.grid.wixel + 1.0;
        BTable table = this.getTable();
        g.drawImage(SlotBarUtil.getSlotBar((BWidget)table, (Slot)slot, (int)((int)wixelWidth)), 0.0, 0.0);
        double cellH = cell.height;
        if (this.model.pinned[cell.row]) {
            g.drawImage(pinIcon, 3.0, (cellH - pinIcon.getHeight() - 1.0) / 2.0);
        }
        g.setBrush(BColor.black);
        BFont font = BFont.make((BFont)Theme.wiresheet().glyph().getFont((IStylable)this.model.glyph), (double)12.5);
        g.setFont(font);
        g.drawString(this.model.displayNames[cell.row], 30.0, cellH - (cellH - font.getAscent()) / 2.0 - font.getDescent() + 1.0);
    }
}

