/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.pdf;

import com.tridium.pdf.BIPdfWidget;
import java.util.ArrayList;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class BPdfWsTitleBox
extends BWidget
implements BIPdfWidget {
    public static final Type TYPE = Sys.loadType(BPdfWsTitleBox.class);
    static Lexicon lex = Lexicon.make((String)"wiresheet");
    private BFont font = BFont.make((String)lex.getText("ws.pdf.titleBox.font"));
    private double pad = 3.0;
    private ArrayList<String> lines = new ArrayList();

    public Type getType() {
        return TYPE;
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void removeAllLines() {
        this.lines.clear();
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        for (int i = 0; i < this.lines.size(); ++i) {
            String s = this.lines.get(i);
            pw = Math.max(pw, this.font.width(s));
            ph += this.font.getHeight();
        }
        pw = Math.max(75.0, pw);
        this.setPreferredSize(pw += this.pad + this.pad, ph += this.pad + this.pad);
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        double tx = this.pad;
        double ty = this.pad + this.font.getAscent();
        g.setBrush(BColor.black.toBrush());
        g.setFont(this.font);
        for (int i = 0; i < this.lines.size(); ++i) {
            String s = this.lines.get(i);
            g.drawString(s, tx, ty);
            ty += this.font.getHeight();
        }
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
    }

    public void fromWidget(BWidget widget, PdfOp op) {
    }
}

