/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.UiEnv;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkSnakeGlyph;
import com.tridium.wiresheet.LinkStubGlyph;
import com.tridium.wiresheet.RelationKnobGlyph;
import com.tridium.wiresheet.RelationStubGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.TextBlockGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsSelectedState;
import com.tridium.wiresheet.WsSelection;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import com.tridium.workbench.commands.PasteSpecialCommand;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.transfer.NTransferContext;
import com.tridium.workbench.transfer.TransferArtifact;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BFont;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.BWsTextBlock;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentCompositeCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;

public class WsController
implements WsConst {
    public final BWireSheetPane ws;
    public final WsSelection selection;
    public BComponent container;
    public Point dropPoint;
    private WsState state;
    private HashMap<String, ComponentGlyph> byName = new HashMap();
    private HashMap<Object, ComponentGlyph> byHandle = new HashMap();
    private int auto = -2;
    private boolean reload;
    int id = nextId++;
    static int nextId;

    public WsController(BWireSheetPane ws) {
        this.ws = ws;
        this.selection = ws.selection;
        this.state = new NormalState(ws, this);
    }

    public WsState getState() {
        return this.state;
    }

    public void transition(WsState newState) {
        this.state = newState;
    }

    public ComponentGlyph[] getAllComponentGlyphs() {
        Glyph[] g = this.ws.getCanvas().getRootGlyph().componentLayer.getChildGlyphs();
        ComponentGlyph[] r = new ComponentGlyph[g.length];
        System.arraycopy(g, 0, r, 0, g.length);
        return r;
    }

    public void load(BComponent container) {
        ComponentGlyph glyph;
        int i;
        this.container = container;
        WsSelectedState[] states = this.selection.preLoad();
        this.ws.getCanvas().preLoad();
        this.byName.clear();
        this.byHandle.clear();
        this.auto = -2;
        this.dropPoint = null;
        ArrayList<ComponentGlyph> glyphs = new ArrayList<ComponentGlyph>();
        SlotCursor c = container.getProperties();
        while (c.nextComponent()) {
            BComponent kid = c.get().asComponent();
            if (Flags.isHidden((BComplex)container, (Slot)c.property()) || kid instanceof BVector) continue;
            glyphs.add(this.addComponentGlyph(kid));
        }
        Array toSub = new Array(BComponent.class);
        for (i = 0; i < glyphs.size(); ++i) {
            glyph = (ComponentGlyph)glyphs.get(i);
            glyph.checkForSubscribe(this.ws.getView(), (Array<BComponent>)toSub);
        }
        if (toSub.size() > 0) {
            this.ws.getView().registerForComponentEvents((BComponent[])toSub.trim(), 0);
        }
        for (i = 0; i < glyphs.size(); ++i) {
            glyph = (ComponentGlyph)glyphs.get(i);
            glyph.loadLinks();
            glyph.loadRelations();
        }
        for (i = 0; i < glyphs.size(); ++i) {
            glyph = (ComponentGlyph)glyphs.get(i);
            glyph.loadKnobs();
            glyph.loadRelationKnobs();
        }
        for (i = 0; i < glyphs.size(); ++i) {
            glyph = (ComponentGlyph)glyphs.get(i);
            glyph.postSubscribe();
        }
        this.ws.getCanvas().postLoad();
        this.selection.postLoad(states);
        this.ws.getThumbnail().postLoad();
    }

    public void reload() {
        this.reload = true;
        this.ws.getCanvas().relayout();
    }

    public void doLayout() {
        int numReloads = 0;
        while (this.reload) {
            this.reload = false;
            if (numReloads++ > 10) {
                System.out.println("ERROR: WsController recursive reload!");
                break;
            }
            this.load(this.container);
        }
    }

    public void saveAnnotations(ComponentGlyph[] glyphs) throws Exception {
        HashMap<BComponent, ComponentGlyph> toSave = new HashMap<BComponent, ComponentGlyph>();
        for (int i = 0; i < glyphs.length; ++i) {
            toSave.put(glyphs[i].component, glyphs[i]);
        }
        ComponentGlyph[] all = this.getAllComponentGlyphs();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].component.getProperty("wsAnnotation") != null) continue;
            toSave.put(all[i].component, all[i]);
        }
        Context tx = Transaction.start((BComponent)this.container, null);
        Iterator it = toSave.values().iterator();
        while (it.hasNext()) {
            this.saveAnnotation((ComponentGlyph)it.next(), tx);
        }
        Transaction.end((BComponent)this.container, (Context)tx);
    }

    private void saveAnnotation(ComponentGlyph glyph, Context tx) throws Exception {
        BComponent comp = glyph.component;
        BWsAnnotation anno = glyph.toAnnotation();
        Property prop = comp.getProperty("wsAnnotation");
        if (prop == null) {
            comp.add("wsAnnotation", (BValue)anno, 1, tx);
        } else {
            BWsAnnotation old = (BWsAnnotation)comp.get(prop);
            if (!old.equals((Object)anno)) {
                comp.set(prop, (BValue)anno, tx);
            }
        }
    }

    public void zoom(int distance) {
        RectGeom viewport = this.ws.getScrollPane().getViewport();
        double wx = (viewport.width / 2.0 + viewport.x) / (double)this.ws.grid.wixel;
        double wy = (viewport.height / 2.0 + viewport.y) / (double)this.ws.grid.wixel;
        int newWixel = this.ws.grid.wixel + distance;
        if (newWixel < 2) {
            newWixel = 2;
        }
        if (newWixel > 20) {
            newWixel = 20;
        }
        if (this.ws.grid.wixel != newWixel) {
            this.ws.grid.wixel = newWixel;
            this.ws.doLayout(this.ws.getChildWidgets());
            this.ws.getScrollPane().getContent().repaint();
            this.ws.getThumbnail().repaintBuffer();
        }
        RectGeom orig = this.ws.getScrollPane().getViewport();
        if (orig.width > 0.0) {
            double ww = orig.width / (double)this.ws.grid.wixel;
            double wh = orig.height / (double)this.ws.grid.wixel;
            double p = wx - ww / 2.0;
            double q = wy - wh / 2.0;
            viewport = new RectGeom(p * (double)this.ws.grid.wixel, q * (double)this.ws.grid.wixel, orig.width, orig.height);
            this.ws.getScrollPane().scrollToVisible(viewport);
        }
    }

    public void zoomReset() {
        this.zoom(12 - this.ws.grid.wixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentGlyph addComponentGlyph(BComponent comp) {
        if (comp instanceof BVector) {
            throw new IllegalStateException();
        }
        HashMap<String, ComponentGlyph> hashMap = this.byName;
        synchronized (hashMap) {
            ComponentGlyph glyph = this.byName.get(comp.getName());
            if (glyph != null) {
                return glyph;
            }
            BWsAnnotation anno = null;
            BValue annoRaw = comp.get("wsAnnotation");
            anno = annoRaw instanceof BWsAnnotation ? (BWsAnnotation)annoRaw : this.nextAutoAnnotation();
            int p = anno.p;
            int q = anno.q;
            int w = anno.wixelWidth;
            int h = anno.wixelHeight;
            if (w < 2) {
                w = 2;
            }
            if (p + w > BWsOptions.make().getMaxWidth()) {
                p = BWsOptions.make().getMaxWidth() - w;
            }
            if (q + h > BWsOptions.make().getMaxHeight()) {
                q = BWsOptions.make().getMaxHeight() - h;
            }
            if (p < 0) {
                p = 0;
            }
            if (q < 0) {
                q = 0;
            }
            anno = BWsAnnotation.make((int)p, (int)q, (int)w, (int)h);
            glyph = comp instanceof BWsTextBlock ? new TextBlockGlyph(this.ws, comp, anno) : new StdComponentGlyph(this.ws, comp, anno);
            this.byName.put(comp.getName(), glyph);
            this.byHandle.put(glyph.handle, glyph);
            this.ws.getCanvas().getRootGlyph().componentLayer.addToTop(glyph);
            return glyph;
        }
    }

    public LinkGlyph addLinkGlyph(LinkGlyph glyph) {
        this.ws.getCanvas().getRootGlyph().linkLayer.add(glyph);
        return glyph;
    }

    LinkGlyph makeLinkGlyph(StdComponentGlyph target, BLink link) {
        StdComponentGlyph source = this.toStdComponentGlyph(link.getSourceOrd());
        if (source == null) {
            return new LinkStubGlyph(this.ws, link, target);
        }
        return new LinkSnakeGlyph(this.ws, link, target, source);
    }

    public LinkGlyph addRelationLinkGlyph(StdComponentGlyph source, BRelation relation) {
        BOrd relationOrd = relation.getEndpointOrd();
        StdComponentGlyph target = this.toStdComponentGlyph(relationOrd);
        if (target != null) {
            return null;
        }
        RelationStubGlyph glyph = new RelationStubGlyph(this.ws, relation, source);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(glyph);
        return glyph;
    }

    public LinkGlyph addRelationLinkGlyph(StdComponentGlyph target, RelationKnob knob) {
        StdComponentGlyph source;
        BRelation relation = null;
        BOrd relationOrd = knob.getRelationOrd();
        BComponent relationSource = relationOrd.resolve((BObject)target.component).get().asComponent();
        relationSource.lease();
        for (BRelation bRelation : (BRelation[])relationSource.getChildren(BRelation.class)) {
            BObject relationEndpoint;
            if (bRelation instanceof BLink || !(relationEndpoint = bRelation.getEndpointOrd().resolve((BObject)target.component).get()).equals((Object)target.component) || !bRelation.getId().toString().equals(knob.getRelationId())) continue;
            relation = bRelation;
            break;
        }
        LinkGlyph glyph = (source = this.toStdComponentGlyph(relationOrd)) == null || relation == null ? new RelationKnobGlyph(this.ws, knob, target) : new LinkSnakeGlyph(this.ws, relation, target, source);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(glyph);
        return glyph;
    }

    public LinkGlyph addKnobGlyph(ComponentGlyph source, Knob knob) {
        if (!(source instanceof StdComponentGlyph)) {
            return null;
        }
        StdComponentGlyph target = this.toStdComponentGlyph(knob.getTargetOrd());
        if (target != null) {
            return null;
        }
        LinkKnobGlyph glyph = new LinkKnobGlyph(this.ws, knob, (StdComponentGlyph)source);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(glyph);
        return glyph;
    }

    public LinkGlyph addRelationKnobGlyph(ComponentGlyph target, RelationKnob rKnob) {
        if (!(target instanceof StdComponentGlyph)) {
            return null;
        }
        StdComponentGlyph source = this.toStdComponentGlyph(rKnob.getRelationOrd());
        if (source != null) {
            return null;
        }
        RelationKnobGlyph glyph = new RelationKnobGlyph(this.ws, rKnob, (StdComponentGlyph)target);
        this.ws.getCanvas().getRootGlyph().linkLayer.add(glyph);
        return glyph;
    }

    public ComponentGlyph toComponentGlyph(BOrd ord) {
        String s = String.valueOf(ord);
        if (s.startsWith("h:")) {
            String handle = s.substring(2).trim();
            return this.byHandle.get(handle);
        }
        if (s.startsWith("station:") || s.startsWith("slot:")) {
            try {
                BObject obj = ord.get((BObject)this.ws.controller.container);
                if (obj.isComponent()) {
                    return this.byHandle.get(obj.asComponent().getHandle());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public StdComponentGlyph toStdComponentGlyph(BOrd ord) {
        ComponentGlyph glyph = this.toComponentGlyph(ord);
        if (glyph instanceof StdComponentGlyph) {
            return (StdComponentGlyph)glyph;
        }
        return null;
    }

    private BWsAnnotation nextAutoAnnotation() {
        this.auto += 4;
        if (this.auto > this.ws.grid.getWixelWidth() - 8 || this.auto > this.ws.grid.getWixelWidth() - 8) {
            this.auto = 2;
        }
        return BWsAnnotation.make((int)this.auto, (int)this.auto, (int)8);
    }

    public void doBackgroundPopup(double mx, double my) {
        this.dropPoint = new Point(mx, my);
        BMenu menu = new BMenu();
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        BWsAnnotation anno = BWsAnnotation.make((int)p, (int)q);
        BWsCanvas canvas = this.ws.getCanvas();
        BMenu newMenu = BComponentMenuAgent.makeNewMenu((BWidget)this.ws, (BComponent)this.container, (BWsAnnotation)anno);
        if (newMenu != null) {
            menu.add("new", (BValue)new BSubMenuItem((BIMenu)newMenu));
            menu.add("sep0", (BValue)new BSeparator());
        }
        menu.add("cut", (Command)new CutCommand((BTransferWidget)canvas));
        menu.add("copy", (Command)new CopyCommand((BTransferWidget)canvas));
        menu.add("paste", (Command)new PasteCommand((BTransferWidget)canvas));
        menu.add("pasteSpecial", (Command)new PasteSpecialCommand((BTransferWidget)canvas, this.container));
        menu.add("duplicate", (Command)new DuplicateCommand((BTransferWidget)canvas));
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("delete", (Command)new DeleteCommand((BTransferWidget)canvas));
        if (BWsOptions.make().getShowRelations() || BWsOptions.make().getShowLinks()) {
            menu.add("deleteRelationss", (Command)this.ws.commands.deleteRelations);
            menu.add("editRelation", (Command)this.ws.commands.editRelation);
            menu.add("editRelationTags", (Command)this.ws.commands.editRelationTags);
        }
        menu.add("rename", (Command)new RenameCommand((BTransferWidget)canvas));
        menu.add("sep2", (BValue)new BSeparator());
        if (this.addLinkSelection(menu, p, q)) {
            menu.add("sepLinkSep1", (BValue)new BSeparator());
        }
        menu.add("arrange", (Command)this.ws.commands.arrange);
        menu.add("selectAll", (Command)this.ws.commands.selectAll);
        menu.add("sep3", (BValue)new BSeparator());
        menu.add("reorder", (Command)new ComponentReorderCommand((BWidget)this.ws, this.container));
        menu.add("composite", (Command)new ComponentCompositeCommand((BWidget)this.ws, this.container));
        menu = this.ws.getView().makeBackgroundPopup(menu);
        if (menu != null) {
            menu.removeConsecutiveSeparators();
            menu.open((BWidget)canvas, mx, my);
        }
    }

    public boolean addLinkSelection(BMenu menu, int p, int q) {
        LinkGlyph[] linkGlyphs = this.ws.getCanvas().rootGlyph.linkLayer.getLinkGlyphsAt(p, q);
        if (linkGlyphs.length > 1) {
            menu.add("sepLinkSep0", (BValue)new BSeparator());
            boolean isRelation = linkGlyphs[0].isRelation();
            BMenu linkSelMenu = new BMenu();
            for (int i = 0; i < linkGlyphs.length; ++i) {
                linkSelMenu.add("linkSel?", (Command)new LinkSelectCommand(linkGlyphs[i]));
            }
            String selectionText = isRelation ? lex.get("relationSelection") : lex.get("linkSelection");
            menu.add("linkMenu", (BValue)new BSubMenuItem(selectionText, (BIMenu)linkSelMenu));
            return true;
        }
        return false;
    }

    public void keyPressed(BKeyEvent event) {
        if (this.processInput()) {
            this.state.keyPressed(event);
        }
    }

    public void keyReleased(BKeyEvent event) {
        if (this.processInput()) {
            this.state.keyReleased(event);
        }
    }

    public void keyTyped(BKeyEvent event) {
        if (this.processInput()) {
            this.state.keyTyped(event);
        }
    }

    public void mousePressed(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mousePressed(event);
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mouseReleased(event);
        }
    }

    public void mouseEntered(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mouseEntered(event);
        }
    }

    public void mouseExited(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mouseExited(event);
        }
    }

    public void mouseMoved(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mouseMoved(event);
        }
    }

    public void mouseDragged(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mouseDragged(event);
        }
    }

    public void mousePulsed(BMouseEvent event) {
        if (this.processInput()) {
            this.state.mousePulsed(event);
        }
    }

    public void mouseWheel(BMouseWheelEvent event) {
        if (this.processInput()) {
            this.state.mouseWheel(event);
        }
    }

    boolean processInput() {
        return this.ws.getShell() != null && this.ws.initialized;
    }

    public boolean pulseViewport(double xCanvas, double yCanvas) {
        return this.ws.getScrollPane().pulseViewport(new Point(xCanvas, yCanvas), (double)(this.ws.grid.wixel * 2));
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.container == null) {
            return;
        }
        int id = event.getId();
        BComponent src = event.getSourceComponent();
        Object h = src.getHandle();
        String slotName = event.getSlotName();
        if (this.container.getHandle().equals(h)) {
            switch (id) {
                case 1: 
                case 3: {
                    this.reload();
                    break;
                }
                case 2: {
                    ComponentGlyph glyph = this.byName.get(slotName);
                    if (glyph != null) {
                        this.ws.grid.set(glyph.p, glyph.q, glyph.ww, glyph.wh, 0);
                        this.ws.grid.clearLinks();
                    }
                    this.reload();
                }
            }
            return;
        }
        ComponentGlyph glyph = this.byHandle.get(h);
        if (glyph != null) {
            switch (id) {
                case 0: {
                    if (slotName.equals("wsAnnotation")) {
                        this.reload();
                        break;
                    }
                    glyph.changed(slotName);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    this.reload();
                    break;
                }
                case 2: 
                case 6: {
                    this.ws.grid.set(glyph.p, glyph.q, glyph.ww, glyph.wh, 0);
                    this.ws.grid.clearLinks();
                    this.reload();
                }
            }
            return;
        }
        BComponent parent = (BComponent)src.getParent();
        if (parent != null) {
            glyph = this.byHandle.get(parent.getHandle());
        }
        if (glyph != null) {
            switch (id) {
                case 0: {
                    glyph.changed(src.getPropertyInParent().getName());
                }
            }
            return;
        }
    }

    public void updateTransferStates() {
        boolean hasComponents = false;
        boolean hasLinks = false;
        Glyph[] selectedGlyphs = this.selection.get();
        for (int i = 0; i < selectedGlyphs.length; ++i) {
            Glyph sel = selectedGlyphs[i];
            if (sel instanceof ComponentGlyph) {
                hasComponents = true;
            }
            if (!(sel instanceof LinkGlyph)) continue;
            hasLinks = true;
        }
        BWsCanvas canvas = this.ws.getCanvas();
        canvas.setCutEnabled(hasComponents);
        canvas.setCopyEnabled(hasComponents);
        canvas.setPasteEnabled(true);
        canvas.setPasteSpecialEnabled(true);
        canvas.setDuplicateEnabled(hasComponents);
        canvas.setDeleteEnabled(hasComponents);
        canvas.setRenameEnabled(hasComponents);
        if (this.ws.commands != null) {
            if (this.ws.commands.deleteRelations != null) {
                this.ws.commands.deleteRelations.setEnabled(hasLinks);
            }
            if (this.ws.commands.editRelation != null) {
                this.ws.commands.editRelation.setEnabled(this.ws.selection.getRelations().length == 1);
            }
            if (this.ws.commands.editRelationTags != null) {
                this.ws.commands.editRelationTags.setEnabled(this.ws.selection.getRelations().length == 1);
            }
        }
    }

    public TransferContext makeTransferContext(Context src, int action, TransferEnvelope envelope) {
        NTransferContext cx = new NTransferContext(src, action, envelope);
        cx.params = this.getTransferParameters(false);
        return cx;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        CommandArtifact art = null;
        art = TransferUtil.insert((BWidget)this.ws.getCanvas(), (TransferContext)cx, (BObject)this.container, (BComponent)this.getTransferParameters(true));
        if (art instanceof TransferArtifact) {
            this.completeTransfer((TransferArtifact)art);
        }
        return art;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTransfer(TransferArtifact artifact) {
        if (artifact == null) {
            return;
        }
        BWbShell shell = this.ws.getWbShell();
        if (shell != null) {
            shell.enterBusy();
        }
        try {
            String[] names = artifact.getInsertNames();
            this.selection.unselectAll();
            ComponentGlyph[] glyphs = new ComponentGlyph[names.length];
            HashMap<String, ComponentGlyph> hashMap = this.byName;
            synchronized (hashMap) {
                for (int i = 0; i < names.length; ++i) {
                    BValue value = this.container.get(names[i]);
                    if (value == null || !value.isComponent() || value instanceof BVector) continue;
                    glyphs[i] = this.addComponentGlyph(value.asComponent());
                    this.selection.select(glyphs[i]);
                }
            }
            for (int i = 0; i < glyphs.length; ++i) {
                glyphs[i].loadLinks();
                glyphs[i].loadRelations();
                glyphs[i].loadKnobs();
                glyphs[i].loadRelationKnobs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    public BComponent getTransferParameters(boolean clear) {
        BComponent params = new BComponent();
        if (this.dropPoint != null) {
            params.add("origin", (BValue)BWsAnnotation.make((int)((int)this.dropPoint.x / this.ws.grid.wixel), (int)((int)this.dropPoint.y / this.ws.grid.wixel), (int)2));
            if (clear) {
                this.dropPoint = null;
            }
        }
        return params;
    }

    public Mark getSelectionAsMark() {
        ComponentGlyph[] glyphs = this.selection.getComponentGlyphs();
        if (glyphs.length == 0) {
            return null;
        }
        BComponent[] comp = new BComponent[glyphs.length];
        for (int i = 0; i < comp.length; ++i) {
            comp[i] = glyphs[i].component;
        }
        Arrays.sort(comp, new SlotOrder(this.container));
        return new Mark((BObject[])comp);
    }

    public static BFont getFont(BFont font, int size) {
        if (UiEnv.get().isMicroEdition()) {
            return BFont.make((String)font.getName(), (double)Math.max(10, size), (int)font.getStyle());
        }
        return BFont.make((String)font.getName(), (double)size, (int)font.getStyle());
    }

    private class LinkSelectCommand
    extends ToggleCommand {
        private LinkGlyph linkGlyph;

        private LinkSelectCommand(LinkGlyph linkGlyph) {
            super((BWidget)WsController.this.ws.getCanvas(), linkGlyph.getStatusMessage());
            this.linkGlyph = linkGlyph;
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            if (event != null && event.isControlDown()) {
                if (this.linkGlyph.isSelected()) {
                    WsController.this.ws.selection.unselect(this.linkGlyph);
                } else {
                    WsController.this.ws.selection.select(this.linkGlyph);
                }
            } else {
                WsController.this.ws.selection.unselectAll();
                WsController.this.ws.selection.select(this.linkGlyph);
            }
            return null;
        }

        public synchronized boolean isSelected() {
            return this.linkGlyph.isSelected();
        }
    }

    static class SlotOrder
    implements Comparator<BComponent> {
        HashMap<String, Integer> lookup = new HashMap();

        public SlotOrder(BComponent parent) {
            Property[] props = parent.getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                this.lookup.put(props[i].getName(), new Integer(i));
            }
        }

        @Override
        public int compare(BComponent obj1, BComponent obj2) {
            int b;
            String na = obj1.getName();
            String nb = obj2.getName();
            int a = this.lookup.get(na);
            if (a < (b = this.lookup.get(nb).intValue())) {
                return -1;
            }
            if (a == b) {
                return 0;
            }
            return 1;
        }
    }
}

