/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsConst;

public class WixelGrid
implements WsConst {
    private BWireSheetPane ws;
    private byte[] grid;
    private int width;
    private int height;
    public int wixel = 12;

    public WixelGrid(BWireSheetPane ws) {
        this.ws = ws;
        this.setWixelSize(120, 120);
    }

    public final int get(int p, int q) {
        return this.grid[q * this.width + p];
    }

    public final void set(int p, int q, int w, int h, int mask) {
        int pLen = p + w;
        int qLen = q + h;
        for (int i = p; i < pLen; ++i) {
            for (int j = q; j < qLen; ++j) {
                if (i < 0 || i >= this.width || j < 0 || j >= this.height) continue;
                this.grid[j * this.width + i] = (byte)mask;
            }
        }
    }

    public final void set(int p, int q, int mask) {
        if (p >= 0 && p < this.width && q >= 0 && q < this.height) {
            this.grid[q * this.width + p] = (byte)mask;
        }
    }

    public final boolean isComponent(int p, int q) {
        int g = this.get(p, q);
        return g == 12 || g == 11;
    }

    public final void setComponent(int p, int q, int w, int h) {
        int i;
        this.set(p + 1, q + 1, w - 2, h - 2, 12);
        for (i = p; i < p + w; ++i) {
            this.set(i, q, 11);
            this.set(i, q + h - 1, 11);
        }
        for (i = q; i < q + h; ++i) {
            this.set(p, i, 11);
            this.set(p + w - 1, i, 11);
        }
    }

    public void postLoad() {
        this.grid = new byte[this.width * this.height];
    }

    public void clearLinks() {
        for (int i = 0; i < this.grid.length; ++i) {
            if (this.grid[i] == 12 || this.grid[i] == 11 || this.grid[i] == 0) continue;
            this.grid[i] = 0;
        }
    }

    public int getWixelWidth() {
        return this.width;
    }

    public void setWixelWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.postLoad();
        }
    }

    public int getWixelHeight() {
        return this.height;
    }

    public void setWixelHeight(int height) {
        if (this.height != height) {
            this.height = height;
            this.postLoad();
        }
    }

    public void setWixelSize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.postLoad();
        }
    }
}

