/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.BWsTextBlock;

public class TextBlockGlyph
extends ComponentGlyph {
    String[] text;
    BColor fg;
    BColor bg;
    BFont font;
    boolean border;
    boolean hasText;

    public TextBlockGlyph(BWireSheetPane ws, BComponent component, BWsAnnotation anno) {
        super(ws, component, anno);
        this.mapConfig();
    }

    @Override
    public boolean isSelectable() {
        return ((BWsTextBlock)this.component).getSelectable();
    }

    @Override
    protected void fillGrid() {
        if (this.isSelectable()) {
            super.fillGrid();
        }
    }

    @Override
    protected void doLayout(Glyph[] kids) {
        this.setWixelBounds(this.p, this.q, this.ww, this.wh);
    }

    @Override
    public void paint(Graphics g) {
        if (this.bg.getAlpha() == 0 && !this.hasText && !this.border) {
            g.setBrush(hatchFg);
            g.strokeRect(0.0, 0.0, (double)(this.pw - 1), (double)(this.ph - 1));
            PaintUtil.fillHatched((Graphics)g, (int)0, (int)0, (int)this.pw, (int)this.ph);
            return;
        }
        g.setBrush(this.bg);
        g.fillRect(0.0, 0.0, (double)this.pw, (double)this.ph);
        g.setBrush(this.fg);
        if (this.border) {
            g.strokeRect(0.0, 0.0, (double)(this.pw - 1), (double)(this.ph - 1));
        }
        double fontSize = this.font.getSize() - this.font.getSize() * ((12.0 - (double)this.ws.grid.wixel) / 12.0);
        BFont ft = WsController.getFont(this.font, (int)fontSize);
        g.setFont(ft);
        double th = ft.getHeight();
        double ty = Math.max(0.0, ((double)this.ph - th * (double)this.text.length) / 2.0) + th - ft.getDescent();
        for (int i = 0; i < this.text.length; ++i) {
            g.drawString(this.text[i], 5.0, ty);
            ty += th;
        }
    }

    @Override
    public void paintSelection(Graphics g) {
        double w = this.pw;
        double h = this.ph;
        WiresheetTheme theme = Theme.wiresheet();
        g.setBrush(theme.glyph().getSelectionForeground((IStylable)this));
        g.strokeRect(-1.0, -1.0, w + 1.0, h + 1.0);
        g.fillRect(-3.0, -3.0, 5.0, 5.0);
        g.fillRect(w - 2.0, -3.0, 5.0, 5.0);
        g.fillRect(-3.0, h - 2.0, 5.0, 5.0);
        g.fillRect(w - 2.0, h - 2.0, 5.0, 5.0);
        g.setBrush(theme.glyph().getSelectionBackground((IStylable)this));
        g.strokeRect(-4.0, -4.0, 6.0, 6.0);
        g.strokeRect(w - 3.0, -4.0, 6.0, 6.0);
        g.strokeRect(-4.0, h - 3.0, 6.0, 6.0);
        g.strokeRect(w - 3.0, h - 3.0, 6.0, 6.0);
    }

    @Override
    public ResizeZone getResizeAt(double x, double y) {
        return ResizeZone.make(this, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(WsPrinting p) {
        Graphics g = p.graphics;
        double w = (double)this.ww * p.wixel;
        double h = (double)this.wh * p.wixel;
        p.graphics.push();
        try {
            p.graphics.clip(0.0, 0.0, w - 1.0, h - 1.0);
            if (this.border) {
                g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
            }
            if (!this.hasText) {
                return;
            }
            double th = this.font.getHeight();
            double ty = Math.max(0.0, (h - th * (double)this.text.length) / 2.0) + th - this.font.getDescent();
            for (int i = 0; i < this.text.length; ++i) {
                g.setBrush(this.fg.isNull() ? BColor.black : this.fg);
                g.setFont(this.font);
                g.drawString(this.text[i], 5.0, ty - th + this.font.getAscent());
                ty += th;
            }
        }
        finally {
            p.graphics.pop();
        }
    }

    @Override
    public void changed(String propName) {
        super.changed(propName);
        this.mapConfig();
        this.repaint();
    }

    private void mapConfig() {
        try {
            BWsTextBlock c = (BWsTextBlock)this.component;
            this.text = TextUtil.splitAndTrim((String)c.getText(), (char)'\n');
            this.hasText = false;
            for (int i = 0; i < this.text.length; ++i) {
                if (this.text[i].length() <= 0) continue;
                this.hasText = true;
                break;
            }
            this.border = c.getBorder();
            this.fg = BColor.make((String)c.getForeground());
            this.bg = BColor.make((String)c.getBackground());
            this.font = (BFont)BFont.DEFAULT.decodeFromString(c.getFont());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public BWsAnnotation toAnnotation() {
        return BWsAnnotation.make((int)this.p, (int)this.q, (int)this.ww, (int)this.wh);
    }
}

