/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.WsConst;
import javax.baja.ui.MouseCursor;

public class ResizeZone
implements WsConst {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP_LEFT = 5;
    public static final int TOP_RIGHT = 9;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 10;
    public final ComponentGlyph glyph;
    public final int edge;
    public final MouseCursor mouseCursor;

    public static MouseCursor edgeToCursor(int edge) {
        switch (edge) {
            case 1: {
                return MouseCursor.nResize;
            }
            case 2: {
                return MouseCursor.sResize;
            }
            case 4: {
                return MouseCursor.wResize;
            }
            case 8: {
                return MouseCursor.eResize;
            }
            case 5: {
                return MouseCursor.nwResize;
            }
            case 9: {
                return MouseCursor.neResize;
            }
            case 6: {
                return MouseCursor.swResize;
            }
            case 10: {
                return MouseCursor.seResize;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean inX(Glyph g, double x) {
        return (double)(g.x - 3) <= x && x <= (double)(g.x + g.pw + 3);
    }

    public static boolean inY(Glyph g, double y) {
        return (double)(g.y - 3) <= y && y <= (double)(g.y + g.ph + 3);
    }

    public static boolean onLeft(Glyph g, double x, double y) {
        return ResizeZone.inY(g, y) && (double)(g.x - 3) <= x && x <= (double)(g.x + 3);
    }

    public static boolean onRight(Glyph g, double x, double y) {
        return ResizeZone.inY(g, y) && (double)(g.x + g.pw - 3) <= x && x <= (double)(g.x + g.pw + 3);
    }

    public static boolean onTop(Glyph g, double x, double y) {
        return ResizeZone.inX(g, x) && (double)(g.y - 3) <= y && y <= (double)(g.y + 3);
    }

    public static boolean onBottom(Glyph g, double x, double y) {
        return ResizeZone.inX(g, x) && (double)(g.y + g.ph - 3) <= y && y <= (double)(g.y + g.ph + 3);
    }

    public static int onEdge(Glyph g, double x, double y) {
        boolean left = ResizeZone.onLeft(g, x, y);
        boolean right = ResizeZone.onRight(g, x, y);
        boolean top = ResizeZone.onTop(g, x, y);
        boolean bottom = ResizeZone.onBottom(g, x, y);
        if (left) {
            if (top) {
                return 5;
            }
            if (bottom) {
                return 6;
            }
            return 4;
        }
        if (right) {
            if (top) {
                return 9;
            }
            if (bottom) {
                return 10;
            }
            return 8;
        }
        if (top) {
            return 1;
        }
        if (bottom) {
            return 2;
        }
        return 0;
    }

    public static ResizeZone make(ComponentGlyph g, double x, double y) {
        int edge = ResizeZone.onEdge(g, x, y);
        if (edge == 0) {
            return null;
        }
        return new ResizeZone(g, edge);
    }

    public ResizeZone(ComponentGlyph glyph, int edge) {
        this.glyph = glyph;
        this.edge = edge;
        this.mouseCursor = ResizeZone.edgeToCursor(edge);
    }

    public final boolean onLeft() {
        return (this.edge & 4) != 0;
    }

    public final boolean onRight() {
        return (this.edge & 8) != 0;
    }

    public final boolean onTop() {
        return (this.edge & 1) != 0;
    }

    public final boolean onBottom() {
        return (this.edge & 2) != 0;
    }
}

