/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.util.LinkUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.commands.DeleteRelationsCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BRelation;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class RelationStubGlyph
extends LinkLinkGlyph {
    String statusMessage;

    protected RelationStubGlyph(BWireSheetPane ws, BRelation relation, StdComponentGlyph targetComp) {
        super(ws, relation, targetComp, null);
        this.selectionKey = "Relation:" + relation.getEndpointOrd() + "." + targetComp.handle + "." + relation.getId();
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    BOrd getGotoOrd() {
        return this.relation.getEndpointOrd();
    }

    @Override
    public void popup(double mx, double my) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new GotoRelationCommand());
        menu.add(null, (Command)new GotoCommand());
        menu.add(null, (Command)new DeleteRelationsCommand(this.ws));
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        this.ws.controller.addLinkSelection(menu, p, q);
        menu.open((BWidget)this.ws.getCanvas(), mx, my);
    }

    @Override
    protected String getGotoLinkSourceHandle() {
        return this.getHandleFromOrd(this.relation.getEndpointOrd());
    }

    @Override
    protected String getGotoLinkSourceSlotName() {
        return this.relation.getRelationId();
    }

    @Override
    protected String getGotoLinkTargetHandle() {
        return this.getHandleFromOrd(this.targetComp.component.getHandleOrd());
    }

    @Override
    protected String getGotoLinkTargetSlotName() {
        return this.relation.getRelationId();
    }

    @Override
    public void doubleClicked(BMouseEvent event) {
        new GotoRelationCommand().invoke(new CommandEvent((BInputEvent)event));
    }

    @Override
    public StdComponentGlyph getSourceComponentGlyph() {
        return null;
    }

    @Override
    public SlotBarGlyph getSourceSlotGlyph() {
        return null;
    }

    @Override
    public String getStatusMessage() {
        if (this.statusMessage == null) {
            this.statusMessage = LinkUtil.toDisplay((BRelation)this.relation);
        }
        return this.statusMessage;
    }

    @Override
    public void findLinks(WsPrinting p) {
        this.linkName = p.addStubLink(LinkUtil.toDisplaySource((BRelation)this.link), LinkUtil.toDisplayTarget((BRelation)this.link));
    }

    @Override
    public LinkGlyph.Tile[] buildTiles() {
        if (this.targetSlot == null) {
            System.out.println("ERROR: RelationStubGlyph.noTargetSlot: " + this.relation);
            return new LinkGlyph.Tile[0];
        }
        int p = this.targetSlot.absP() + this.targetSlot.ww;
        int q = this.targetSlot.absQ();
        return new LinkGlyph.Tile[]{new LinkGlyph.Tile(p, q, 4, this.ws)};
    }

    protected class GotoRelationCommand
    extends LinkGlyph.GotoLinkCommand {
        protected GotoRelationCommand() {
            super((BWidget)RelationStubGlyph.this.ws.getCanvas(), WsConst.lex, "relationGotoRelation");
        }
    }

    class GotoCommand
    extends LinkGlyph.GotoCommand {
        GotoCommand() {
            super((BWidget)RelationStubGlyph.this.ws.getCanvas(), WsConst.lex, "relationGoto");
        }
    }
}

