/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.WsSelectedState;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

public abstract class Glyph
implements WsConst,
IStylable {
    private static final Glyph[] empty = new Glyph[0];
    public final BWireSheetPane ws;
    public int x;
    public int y;
    public int p;
    public int q;
    public int pw;
    public int ph;
    public int ww;
    public int wh;
    public boolean visible = true;
    private Glyph parent;
    private ArrayList<Glyph> children = new ArrayList();
    private boolean selected;
    private boolean mouseOver;
    private int linkOver;
    private String styleId = "";
    private String styleClasses = "";

    protected Glyph(BWireSheetPane ws) {
        this.ws = ws;
    }

    public final Glyph getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Glyph[] getChildGlyphs() {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            int size = this.children.size();
            if (size == 0) {
                return empty;
            }
            return this.children.toArray(new Glyph[size]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Glyph glyph) {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(glyph);
            glyph.parent = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTop(Glyph glyph) {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(0, glyph);
            glyph.parent = this;
        }
        this.ws.doLayout(this.ws.getChildWidgets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Glyph glyph) {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) != glyph) continue;
                this.children.remove(i);
                if (glyph.selected) {
                    this.ws.selection.unselect(glyph);
                }
                glyph.parent = null;
                return;
            }
        }
        this.ws.doLayout(this.ws.getChildWidgets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            this.children.clear();
        }
        this.ws.doLayout(this.ws.getChildWidgets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toTop(Glyph glyph) {
        ArrayList<Glyph> arrayList = this.children;
        synchronized (arrayList) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) != glyph) continue;
                this.children.remove(i);
                this.children.add(0, glyph);
                return;
            }
        }
    }

    public boolean isSelectable() {
        return false;
    }

    public Object getSelectionKey() {
        throw new IllegalStateException();
    }

    public final boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            StyleUtils.addStyleClass((IStylable)this, (String)"selected");
        } else {
            StyleUtils.removeStyleClass((IStylable)this, (String)"selected");
        }
    }

    WsSelectedState saveSelectedState() {
        return WsSelectedState.make(this.getSelectionKey());
    }

    void restoreSelectedState(WsSelectedState state) {
    }

    public int getLinkHotSpot(int p, int q) {
        return 0;
    }

    public int getRelateHotSpot(int p, int q) {
        return 0;
    }

    public int getLinkHotSpotWidth() {
        if (this.ww <= 6) {
            return 2;
        }
        return 3;
    }

    public int getLinkOver() {
        return this.linkOver;
    }

    public final void setLinkOver(int linkOver) {
        this.linkOver = linkOver;
        this.repaint();
    }

    public BComponent getLinkComponent() {
        return null;
    }

    public Slot getLinkSlot() {
        return null;
    }

    public int getGridType() {
        return 0;
    }

    public RectGeom getGeom() {
        Glyph[] kids = this.getChildGlyphs();
        RectGeom bounds = null;
        for (int i = 0; i < kids.length; ++i) {
            RectGeom kidBounds = kids[i].getGeom();
            if (kidBounds == null) continue;
            bounds = bounds == null ? kidBounds : RectGeom.bounds((IRectGeom)bounds, (IRectGeom)kidBounds, (RectGeom)bounds);
        }
        return bounds;
    }

    public final int absX() {
        return this.parent == null ? this.x : this.parent.absX() + this.x;
    }

    public final int absY() {
        return this.parent == null ? this.y : this.parent.absY() + this.y;
    }

    public final int absP() {
        return this.parent == null ? this.p : this.parent.absP() + this.p;
    }

    public final int absQ() {
        return this.parent == null ? this.q : this.parent.absQ() + this.q;
    }

    public boolean contains(int p, int q) {
        return p >= 0 && p < this.ww && q >= 0 && q < this.wh;
    }

    public Glyph childAt(int p, int q) {
        Glyph[] kids = this.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            Glyph kid = kids[i];
            if (!kid.contains(p - kid.p, q - kid.q) || !kid.visible) continue;
            return kid;
        }
        return null;
    }

    public Glyph descendentAt(int p, int q) {
        Glyph kid = this.childAt(p, q);
        if (kid != null && kid.visible) {
            Glyph d = kid.descendentAt(p - kid.p, q - kid.q);
            return d != null ? d : kid;
        }
        return null;
    }

    public void setWixelBounds(int p, int q, int ww, int wh) {
        this.p = p;
        this.x = p * this.ws.grid.wixel;
        this.q = q;
        this.y = q * this.ws.grid.wixel;
        this.ww = ww;
        this.pw = ww * this.ws.grid.wixel;
        this.wh = wh;
        this.ph = wh * this.ws.grid.wixel;
    }

    public void layout() {
        Glyph[] kids = this.getChildGlyphs();
        this.doLayout(kids);
        this.fillGrid();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].visible) continue;
            kids[i].layout();
        }
    }

    protected void fillGrid() {
    }

    protected void doLayout(Glyph[] kids) {
    }

    public ResizeZone getResizeAt(double x, double y) {
        return null;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public final void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
        if (mouseOver) {
            this.mouseEntered();
        } else {
            this.mouseExited();
        }
    }

    protected void mouseEntered() {
    }

    protected void mouseExited() {
    }

    public void showStatus(String msg) {
        this.ws.getShell().showStatus(msg);
    }

    public void popup(double mx, double my) {
    }

    public void doubleClicked(BMouseEvent event) {
    }

    public final void repaint() {
        this.ws.getCanvas().repaint(this.absX(), this.absY(), this.pw, this.ph);
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChildren(Graphics g) {
        IGeom clip = g.getClip();
        Glyph[] children = this.getChildGlyphs();
        for (int i = children.length - 1; i >= 0; --i) {
            Glyph child = children[i];
            if (!child.visible || !clip.intersects((double)child.x, (double)child.y, (double)child.pw, (double)child.ph)) continue;
            g.push();
            try {
                g.clip((double)child.x, (double)child.y, (double)child.pw, (double)child.ph);
                g.translate((double)child.x, (double)child.y);
                child.paint(g);
                continue;
            }
            finally {
                g.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChild(Graphics g, Glyph child) {
        if (!child.visible) {
            return;
        }
        IGeom clip = g.getClip();
        if (clip.intersects((double)child.x, (double)child.y, (double)child.pw, (double)child.ph)) {
            g.push();
            try {
                g.clip((double)child.x, (double)child.y, (double)child.pw, (double)child.ph);
                g.translate((double)child.x, (double)child.y);
                child.paint(g);
            }
            finally {
                g.pop();
            }
        }
    }

    public void paintSelection(Graphics g) {
        throw new IllegalStateException();
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getStyleClasses() {
        return this.styleClasses;
    }

    public void setStyleClasses(String styleClasses) {
        this.styleClasses = styleClasses;
    }

    public String getStyleSelector() {
        return "wire-sheet glyph";
    }

    public RectGeom getPrintBounds() {
        return new RectGeom((double)this.absP(), (double)this.absQ(), (double)this.ww, (double)this.wh);
    }

    public void print(WsPrinting p) {
        this.printChildren(p);
    }

    public void printChildren(WsPrinting p) {
        Glyph[] children = this.getChildGlyphs();
        for (int i = children.length - 1; i >= 0; --i) {
            this.printChild(p, children[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printChild(WsPrinting p, Glyph child) {
        if (!child.visible) {
            return;
        }
        Graphics g = p.graphics;
        g.push();
        try {
            double tx = (double)child.p * p.wixel;
            double ty = (double)child.q * p.wixel;
            p.graphics.translate(tx, ty);
            child.print(p);
        }
        finally {
            g.pop();
        }
    }

    public void findLinks(WsPrinting p) {
        Glyph[] children = this.getChildGlyphs();
        for (int i = 0; i < children.length; ++i) {
            children[i].findLinks(p);
        }
    }

    public String toString() {
        return TextUtil.getClassName(this.getClass()) + " [" + this.p + "," + this.q + "," + this.ww + "," + this.wh + "]";
    }

    public void dump() {
        System.out.println(this);
        Glyph[] kids = this.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            System.out.println("  kids[" + i + "] " + kids[i]);
        }
    }
}

