/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.poll;

import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.poll.BDdfPollableWrapper;
import com.tridium.ddf.poll.BIDdfPollScheduler;
import com.tridium.ddf.poll.BIDdfPollable;
import java.util.Hashtable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfPollScheduler
extends BPollScheduler
implements BIDdfPollScheduler {
    public static final Type TYPE = Sys.loadType(BDdfPollScheduler.class);
    Hashtable<BIDdfPollable, BDdfPollableWrapper> wrappers = new Hashtable();

    public Type getType() {
        return TYPE;
    }

    protected void doPoll(BIDdfPollable ddfPollable) {
        BIDdfReadRequest ddfPollRequest = ddfPollable.makePollRequest();
        DdfRequestUtil.communicateSync(ddfPollable.getDdfCommunicator(), ddfPollRequest);
    }

    boolean isStartable() {
        for (BComponent parent = (BComponent)this.getParent(); parent != null; parent = (BComponent)parent.getParent()) {
            if (parent instanceof BDevice) {
                return !((BDevice)parent).isDisabled() && !((BDevice)parent).isFault();
            }
            if (!(parent instanceof BDeviceNetwork)) continue;
            return !((BDeviceNetwork)parent).isDisabled() && !((BDeviceNetwork)parent).isFault();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(BIDdfPollable ddfPollableValue) {
        BDdfPollableWrapper wrapper = null;
        Hashtable<BIDdfPollable, BDdfPollableWrapper> hashtable = this.wrappers;
        synchronized (hashtable) {
            wrapper = this.wrappers.get(ddfPollableValue);
            if (wrapper == null) {
                wrapper = new BDdfPollableWrapper(ddfPollableValue);
                this.wrappers.put(ddfPollableValue, wrapper);
            }
        }
        super.subscribe((BIPollable)wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(BIDdfPollable ddfPollableValue) {
        BDdfPollableWrapper wrapper = null;
        Hashtable<BIDdfPollable, BDdfPollableWrapper> hashtable = this.wrappers;
        synchronized (hashtable) {
            wrapper = this.wrappers.get(ddfPollableValue);
            if (wrapper == null) {
                return;
            }
        }
        super.unsubscribe((BIPollable)wrapper);
    }

    public void subscribe(BIPollable p) {
        throw new IllegalAccessError("Use ddfSubscribe instead.");
    }

    public boolean unsubscribe(BIPollable p) {
        throw new IllegalAccessError("Use ddfUnsubscribe instead.");
    }

    public final void doPoll(BIPollable p) throws Exception {
        if (this.isStartable()) {
            BDdfPollableWrapper ddfPollableWrapper = (BDdfPollableWrapper)p;
            BIDdfPollable ddfPollable = ddfPollableWrapper.wrappedDdfPollable;
            this.doPoll(ddfPollable);
        } else {
            Thread.sleep(1000L);
        }
    }
}

