/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req;

import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfWriteParams;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BDdfWriteRequest
extends BDdfRequest
implements BIDdfWriteRequest {
    public static final Property writeParameters = BDdfWriteRequest.newProperty((int)0, (BValue)new BDdfIdParams(), null);
    public static final Type TYPE = Sys.loadType(BDdfWriteRequest.class);
    private IDdfWritable[] writableSource = null;

    @Override
    public BDdfIdParams getWriteParameters() {
        return (BDdfIdParams)this.get(writeParameters);
    }

    @Override
    public void setWriteParameters(BDdfIdParams v) {
        this.set(writeParameters, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDdfWriteRequest() {
    }

    public BDdfWriteRequest(BRelTime responseTimeout, int maxRetryCount, BDdfIdParams deviceId, BIDdfWriteParams writeParams) {
        super(responseTimeout, maxRetryCount, deviceId);
        this.setWriteParameters((BDdfIdParams)((BDdfIdParams)((Object)writeParams)).newCopy());
    }

    public BDdfWriteRequest(BRelTime responseTimeout, int maxRetryCount, BDdfProxyExt ddfProxyExt) {
        this(responseTimeout, maxRetryCount, ddfProxyExt.getDdfDevice().getDeviceId(), (BIDdfWriteParams)((Object)ddfProxyExt.getWriteParameters()));
        this.setWritableSource(new IDdfWritable[]{ddfProxyExt});
    }

    public BDdfWriteRequest(BDdfIdParams deviceId, BIDdfWriteParams writeParams) {
        super(deviceId);
        this.setWriteParameters((BDdfIdParams)((BDdfIdParams)((Object)writeParams)).newCopy());
    }

    public BDdfWriteRequest(BDdfProxyExt ddfProxyExt) {
        this(ddfProxyExt.getDdfDevice().getDeviceId(), (BIDdfWriteParams)((Object)ddfProxyExt.getWriteParameters()));
        this.setWritableSource(new IDdfWritable[]{ddfProxyExt});
    }

    @Override
    public boolean isGroupable() {
        return this.getWriteParameters().getPropertiesArray().length > 0;
    }

    @Override
    public boolean getAutoWriteFailOnTimeout() {
        return true;
    }

    @Override
    public boolean getAutoWriteFailOnError() {
        return true;
    }

    @Override
    public boolean getAutoWriteOk() {
        return true;
    }

    @Override
    public boolean getAutoWriteOkLate() {
        return true;
    }

    @Override
    public IDdfWritable[] getWritableSource() {
        return this.writableSource;
    }

    @Override
    public void setWritableSource(IDdfWritable[] writeableSource) {
        this.writableSource = writeableSource;
    }

    protected double getRawValue(IDdfWritable ddfWritable) {
        BStatusValue writeValue = ddfWritable.getWriteValue();
        if (writeValue instanceof BStatusNumeric) {
            return ((BStatusNumeric)writeValue).getNumeric();
        }
        if (writeValue instanceof BStatusEnum) {
            return ((BStatusEnum)writeValue).getEnum().getOrdinal();
        }
        if (writeValue instanceof BStatusBoolean) {
            return ((BStatusBoolean)writeValue).getBoolean() ? 1.0 : 0.0;
        }
        if (writeValue instanceof BStatusString) {
            String s = ((BStatusString)writeValue).getValue();
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe1) {
                try {
                    int radix = this.getWritableSource()[0].getFacets().geti("radix", 10);
                    return (int)Long.parseLong(s, radix);
                }
                catch (NumberFormatException nfe2) {
                    String trueText;
                    BEnumRange range = (BEnumRange)this.getWritableSource()[0].getFacets().get("range", null);
                    if (range != null) {
                        try {
                            return range.tagToOrdinal(s);
                        }
                        catch (InvalidEnumException invalidEnumException) {
                            // empty catch block
                        }
                    }
                    if (s.equals(trueText = this.getWritableSource()[0].getFacets().gets("trueText", "True"))) {
                        return 1.0;
                    }
                    String falseText = this.getWritableSource()[0].getFacets().gets("falseText", "False");
                    if (s.equals(falseText)) {
                        return 0.0;
                    }
                    throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat(this.getWritableSource()[0].toString(), s));
                }
            }
        }
        throw new BajaRuntimeException(DdfDefaultCommLexicon.unsupportedStringFormat(this.getWritableSource()[0].toString(), this.getWritableSource()[0].getWriteValue().toString()));
    }
}

