/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.multipleTransaction;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionCommunicator;
import com.tridium.ddf.comm.multipleTransaction.BIDdfMultipleTransactionMgr;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class BDdfMultipleTransactionMgr
extends BDdfTransactionMgr
implements BIDdfMultipleTransactionMgr {
    public static final Property outstandingCount = BDdfMultipleTransactionMgr.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property expiredCount = BDdfMultipleTransactionMgr.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property maxExpired = BDdfMultipleTransactionMgr.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Type TYPE = Sys.loadType(BDdfMultipleTransactionMgr.class);
    Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> outstandingRequestTags = new Hashtable();
    Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> expiredRequestTags = new Hashtable();
    Queue expiredRequestTagsFifoHelper = new Queue();
    private static final BDdfResponse NACK_RESPONSE = new BDdfResponse();

    public int getOutstandingCount() {
        return this.getInt(outstandingCount);
    }

    public void setOutstandingCount(int v) {
        this.setInt(outstandingCount, v, null);
    }

    public int getExpiredCount() {
        return this.getInt(expiredCount);
    }

    public void setExpiredCount(int v) {
        this.setInt(expiredCount, v, null);
    }

    public int getMaxExpired() {
        return this.getInt(maxExpired);
    }

    public void setMaxExpired(int v) {
        this.setInt(maxExpired, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BDdfMultipleTransactionCommunicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTransactionMgr() {
        try {
            super.stopTransactionMgr();
        }
        finally {
            Enumeration<BSimple> outstandingTags = this.outstandingRequestTags.keys();
            if (outstandingTags != null) {
                while (outstandingTags.hasMoreElements()) {
                    BSimple outstandingTag = outstandingTags.nextElement();
                    Hashtable<BIDdfRequest, BIDdfRequest> outstandingRequestsForTag = this.outstandingRequestTags.get(outstandingTag);
                    if (outstandingRequestsForTag == null) continue;
                    Enumeration<BIDdfRequest> outstandingRequests = outstandingRequestsForTag.keys();
                    while (outstandingRequests.hasMoreElements()) {
                        BIDdfRequest outstandingRequest = outstandingRequests.nextElement();
                        if (this.getDdfCommunicator().getLog().isTraceOn()) {
                            this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.requestTimedOut(outstandingRequest));
                        }
                        BDdfMultipleTransactionMgr.removeIdentifiableRequest(outstandingRequest, this.outstandingRequestTags);
                        DdfRequestUtil.processTimeout(outstandingRequest);
                    }
                }
            }
        }
    }

    @Override
    protected void frameReceived(IDdfDataFrame ddfReceiveFrame) {
        boolean frameConsumed = false;
        if (this.matchOutstandingRequest(ddfReceiveFrame)) {
            frameConsumed = true;
        }
        if (this.matchExpiredRequest(ddfReceiveFrame)) {
            frameConsumed = true;
        }
        if (!frameConsumed) {
            this.routeToUnsolicited(ddfReceiveFrame);
        }
    }

    @Override
    protected void beginTransaction(BIDdfRequest req) {
        try {
            BDdfMultipleTransactionMgr.addIdentifiableRequest(req, this.outstandingRequestTags);
        }
        finally {
            this.updateCounts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCheckOutstandingTimeout(BIDdfRequest ddfRequest) {
        block13: {
            try {
                if (!BDdfMultipleTransactionMgr.containsIdentifiableRequest(ddfRequest, this.outstandingRequestTags)) break block13;
                BIDdfRequest bIDdfRequest = ddfRequest;
                synchronized (bIDdfRequest) {
                    if (ddfRequest.getRemainingRetryCount() > 0) {
                        block14: {
                            ddfRequest.setRemainingRetryCount(ddfRequest.getRemainingRetryCount() - 1);
                            try {
                                this.getDdfCommunicator().getDdfTransmitter().forceTransmit(ddfRequest);
                                this.getDdfCommunicator().getDdfTransmitter().setRetransmissionCount(this.getDdfCommunicator().getDdfTransmitter().getRetransmissionCount() + 1L);
                            }
                            catch (Exception e) {
                                if (!this.getDdfCommunicator().getLog().isTraceOn()) break block14;
                                this.getDdfCommunicator().getLog().trace("RetransmissionError - " + e.toString());
                            }
                        }
                        this.scheduleToCheckForTimeout(ddfRequest);
                    } else {
                        if (this.getDdfCommunicator().getLog().isTraceOn()) {
                            this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.requestTimedOut(ddfRequest));
                        }
                        BDdfMultipleTransactionMgr.removeIdentifiableRequest(ddfRequest, this.outstandingRequestTags);
                        this.addExpiredRequest(ddfRequest);
                        DdfRequestUtil.processTimeout(ddfRequest);
                    }
                }
            }
            catch (Exception e) {
                this.getDdfCommunicator().getLog().error(e.toString(), (Throwable)e);
            }
            finally {
                this.updateCounts();
            }
        }
    }

    private void addExpiredRequest(BIDdfRequest expiredReq) {
        int maxExpiredRequestsAllowed = this.getMaxExpired() - 1;
        while (this.expiredRequestTagsFifoHelper.size() > maxExpiredRequestsAllowed) {
            BIDdfRequest purgeRequest = (BIDdfRequest)this.expiredRequestTagsFifoHelper.dequeue();
            BDdfMultipleTransactionMgr.removeIdentifiableRequest(purgeRequest, this.expiredRequestTags);
        }
        this.expiredRequestTagsFifoHelper.enqueue((Object)expiredReq);
        BDdfMultipleTransactionMgr.addIdentifiableRequest(expiredReq, this.expiredRequestTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addIdentifiableRequest(BIDdfRequest req, Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> tagsToRequests) {
        BSimple reqTag = req.getTag();
        if (reqTag == null) {
            throw new NullPointerException(DdfDefaultCommLexicon.mutTagCannotBeNull(req));
        }
        Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> hashtable = tagsToRequests;
        synchronized (hashtable) {
            Hashtable<BIDdfRequest, BIDdfRequest> requestsForTag = tagsToRequests.get(reqTag);
            if (requestsForTag == null) {
                requestsForTag = new Hashtable();
                tagsToRequests.put(reqTag, requestsForTag);
            }
            requestsForTag.put(req, req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeIdentifiableRequest(BIDdfRequest req, Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> tagsToRequests) {
        BSimple reqTag = req.getTag();
        Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> hashtable = tagsToRequests;
        synchronized (hashtable) {
            Hashtable<BIDdfRequest, BIDdfRequest> requestsForTag = tagsToRequests.get(reqTag);
            if (requestsForTag != null) {
                requestsForTag.remove(req);
                if (requestsForTag.size() < 1) {
                    tagsToRequests.remove(reqTag);
                }
            }
        }
    }

    private static int countIdentifiableRequests(Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> tagsToRequests) {
        int count = 0;
        Enumeration<Hashtable<BIDdfRequest, BIDdfRequest>> allRequestsForAllTags = tagsToRequests.elements();
        while (allRequestsForAllTags.hasMoreElements()) {
            Hashtable<BIDdfRequest, BIDdfRequest> requestsForSomeTag = allRequestsForAllTags.nextElement();
            count += requestsForSomeTag.size();
        }
        return count;
    }

    private static boolean containsIdentifiableRequest(BIDdfRequest req, Hashtable<BSimple, Hashtable<BIDdfRequest, BIDdfRequest>> tagsToRequests) {
        BSimple reqTag = req.getTag();
        Hashtable<BIDdfRequest, BIDdfRequest> requestsForTag = tagsToRequests.get(reqTag);
        if (requestsForTag != null) {
            return requestsForTag.containsKey(req);
        }
        return false;
    }

    private boolean matchExpiredRequest(IDdfDataFrame ddfReceiveFrame) {
        BSimple frameId = ddfReceiveFrame.getFrameTag();
        Hashtable<BIDdfRequest, BIDdfRequest> requestsForSameTag = this.expiredRequestTags.get(frameId);
        boolean frameConsumed = false;
        if (requestsForSameTag != null) {
            Enumeration<BIDdfRequest> requests = requestsForSameTag.keys();
            while (requests.hasMoreElements()) {
                BIDdfRequest ddfExpiredRequest = requests.nextElement();
                BIDdfResponse ddfRsp = this.expiredFrameReceived(ddfReceiveFrame, ddfExpiredRequest);
                if (ddfRsp == null) continue;
                frameConsumed = true;
                if (!(ddfRsp instanceof IDdfTransmitAckResponse)) continue;
                this.transmitRspAckBytes((IDdfTransmitAckResponse)((Object)ddfRsp));
            }
        }
        return frameConsumed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchOutstandingRequest(IDdfDataFrame ddfReceiveFrame) {
        BSimple frameTag = ddfReceiveFrame.getFrameTag();
        Hashtable<BIDdfRequest, BIDdfRequest> requestsForSameTag = this.outstandingRequestTags.get(frameTag);
        boolean frameConsumed = false;
        if (requestsForSameTag != null) {
            Enumeration<BIDdfRequest> requests = requestsForSameTag.keys();
            while (requests.hasMoreElements()) {
                BIDdfRequest ddfRequest;
                BIDdfRequest bIDdfRequest = ddfRequest = requests.nextElement();
                synchronized (bIDdfRequest) {
                    BIDdfResponse ddfRsp = this.frameReceived(ddfReceiveFrame, ddfRequest);
                    if (ddfRsp != null) {
                        frameConsumed = true;
                        if (ddfRsp instanceof IDdfTransmitAckResponse) {
                            this.transmitRspAckBytes((IDdfTransmitAckResponse)((Object)ddfRsp));
                        }
                        if (ddfRsp instanceof BIDdfMultiFrameResponse) {
                            this.reScheduleToCheckForTimeout(ddfRequest);
                        }
                    }
                }
            }
        }
        return frameConsumed;
    }

    private void updateCounts() {
        this.setOutstandingCount(BDdfMultipleTransactionMgr.countIdentifiableRequests(this.outstandingRequestTags));
        this.setExpiredCount(BDdfMultipleTransactionMgr.countIdentifiableRequests(this.expiredRequestTags));
    }

    protected BIDdfResponse expiredFrameReceived(IDdfDataFrame ddfReceiveFrame, BIDdfRequest expiredRequest) {
        try {
            BIDdfResponse ddfResponse = expiredRequest.processReceive(ddfReceiveFrame);
            if (ddfResponse != null && this.isCompletedResponse(ddfResponse)) {
                this.expiredFrameReceived(expiredRequest, ddfResponse);
            }
            return ddfResponse;
        }
        catch (DdfResponseException ere) {
            this.expiredResponseError(expiredRequest, ere);
            return NACK_RESPONSE;
        }
        catch (Exception e) {
            this.expiredResponseError(expiredRequest, new DdfResponseException(e));
            return NACK_RESPONSE;
        }
    }

    protected BIDdfResponse frameReceived(IDdfDataFrame ddfReceiveFrame, BIDdfRequest outstandingRequest) {
        try {
            BIDdfResponse ddfResponse = DdfRequestUtil.processReceive(outstandingRequest, ddfReceiveFrame);
            if (ddfResponse != null && this.isCompletedResponse(ddfResponse)) {
                this.frameReceived(outstandingRequest, ddfResponse);
            }
            return ddfResponse;
        }
        catch (DdfResponseException ere) {
            if (ere instanceof IDdfTransmitAckResponse) {
                this.transmitRspAckBytes((IDdfTransmitAckResponse)((Object)ere));
            }
            this.outstandingResponseError(outstandingRequest, ere);
            return NACK_RESPONSE;
        }
        catch (Exception e) {
            this.outstandingResponseError(outstandingRequest, new DdfResponseException(e));
            return NACK_RESPONSE;
        }
    }

    protected void frameReceived(BIDdfRequest outstandingRequest, BIDdfResponse ddfResponse) {
        try {
            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedResponseForRequest(outstandingRequest));
            }
            BDdfMultipleTransactionMgr.removeIdentifiableRequest(outstandingRequest, this.outstandingRequestTags);
            DdfRequestUtil.processResponse(outstandingRequest, ddfResponse);
        }
        finally {
            this.updateCounts();
        }
    }

    protected void outstandingResponseError(BIDdfRequest outstandingRequest, DdfResponseException errorResponse) {
        try {
            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedErrorResponseForRequest(outstandingRequest, errorResponse), (Throwable)((Object)errorResponse));
            }
            BDdfMultipleTransactionMgr.removeIdentifiableRequest(outstandingRequest, this.outstandingRequestTags);
            DdfRequestUtil.processErrorResponse(outstandingRequest, errorResponse);
        }
        finally {
            this.updateCounts();
        }
    }

    protected void expiredResponseError(BIDdfRequest expiredRequest, DdfResponseException errorResponse) {
        try {
            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedLateResponseForRequest(expiredRequest));
                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedErrorResponseForRequest(expiredRequest, errorResponse));
            }
            BDdfMultipleTransactionMgr.removeIdentifiableRequest(expiredRequest, this.expiredRequestTags);
            DdfRequestUtil.processErrorResponse(expiredRequest, errorResponse);
        }
        finally {
            this.updateCounts();
        }
    }

    protected void expiredFrameReceived(BIDdfRequest expiredRequest, BIDdfResponse ddfResponse) {
        try {
            if (this.getDdfCommunicator().getLog().isTraceOn()) {
                this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.receivedLateResponseForRequest(expiredRequest));
            }
            BDdfMultipleTransactionMgr.removeIdentifiableRequest(expiredRequest, this.expiredRequestTags);
            DdfRequestUtil.processLateResponse(expiredRequest, ddfResponse);
        }
        finally {
            this.updateCounts();
        }
    }
}

