/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.services.BSnmpRecipient;
import com.tridium.snmp.snmptypes.SnmpTrap;

public class AlarmTrap
extends SnmpTrap {
    public AlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        super(snmp, 6, 1);
        this.init(entry, snmp.getDefaultNetworkManagerSnmpVersion());
    }

    public AlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        super(recipient, 6, 1);
        this.init(entry, recipient.getNetworkManagerConfig().getNetworkManagerSnmpVersion());
    }

    private void init(AlarmEntry entry, int snmpVersion) {
        if (snmpVersion == 2) {
            this.addStringVariable("1.3.6.1.2.1.1.3.0", "" + this.snmp.getTimeTick());
            this.addStringVariable("1.3.6.1.6.3.1.1.4.1.0", "1.3.6.1.4.1.4131.1.8.1");
        }
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.1", entry.getTimestampString());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.2", entry.getUuid());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.3", entry.getSourceState());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.4", entry.getAckState());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.5", entry.getAckRequired());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.6", entry.getSource());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.7", entry.getAlarmClass());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.8", entry.getPriority());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.9", entry.getNormalTime());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.10", entry.getAckTime());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.11", entry.getUser());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.12", entry.getAlarmData());
        this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.13", entry.getAlarmTransition());
        this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.14", entry.getLastUpdate());
    }

    public static void sendAlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        AlarmTrap trap = new AlarmTrap(snmp, entry);
        trap.send();
    }

    public static void sendAlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        AlarmTrap trap = new AlarmTrap(recipient, entry);
        trap.send();
    }
}

