/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.SnmpConst;

public class ASNOutput
implements SnmpConst {
    private byte[] data = new byte[500];
    private int pos = 0;
    private int endOfData = 0;

    public byte[] getBytes() {
        byte[] a = new byte[this.endOfData];
        System.arraycopy(this.data, 0, a, 0, this.endOfData);
        return a;
    }

    public int getPosition() {
        return this.pos;
    }

    public void addInt(int val) {
        int position = this.pos;
        this.writeInt(val);
        this.insertTag(2, position);
    }

    public void addString(String val) {
        this.addOctetString(val.getBytes());
    }

    public void addOctetString(byte[] a) {
        int position = this.pos;
        this.writeBytes(a);
        this.insertTag(4, position);
    }

    public void addOpaque(byte[] a) {
        int position = this.pos;
        this.writeBytes(a);
        this.insertTag(68, position);
    }

    public void addTimeticks(long val) {
        int position = this.pos;
        this.writeUnsignedLong(val);
        this.insertTag(67, position);
    }

    public void addNull() {
        this.write(5);
        this.write(0);
    }

    public void addObjectId(long[] a) {
        int position = this.pos;
        long num12 = a[0] * 40L + a[1];
        this.writeTagLong(num12);
        for (int i = 2; i < a.length; ++i) {
            this.writeTagLong(a[i]);
        }
        this.insertTag(6, position);
    }

    public void addIpAddress(byte[] a) {
        int position = this.pos;
        this.writeBytes(a);
        this.insertTag(64, position);
    }

    public void addCounter(long val) {
        int position = this.pos;
        this.writeUnsignedInt(val);
        this.insertTag(65, position);
    }

    public void addCounter64(long val) {
        int position = this.pos;
        this.writeUnsignedInt(val);
        this.insertTag(70, position);
    }

    public void addGauge(long val) {
        int position = this.pos;
        this.writeUnsignedInt(val);
        this.insertTag(66, position);
    }

    public void writeBytes(byte[] a) {
        for (int i = 0; i < a.length; ++i) {
            this.write(a[i]);
        }
    }

    public void writeInt(int value) {
        int mask;
        int dataLength = ASNOutput.findIntegerLength(value);
        if (value > 0 && (value & (mask = 1 << 8 * dataLength - 1)) != 0) {
            ++dataLength;
        }
        int position = this.pos;
        for (int i = 1; i <= dataLength; ++i) {
            this.insert(value & 0xFF, position);
            value >>= 8;
        }
    }

    private static int findIntegerLength(long value) {
        if (value == 0L) {
            return 1;
        }
        if (value > 0L) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(value));
            }
            if ((value & 0xFFFFFFFFFF000000L) != 0L) {
                return 4;
            }
            if ((value & 0xFF0000L) != 0L) {
                return 3;
            }
            if ((value & 0xFF00L) != 0L) {
                return 2;
            }
            return 1;
        }
        if (value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(value));
        }
        if ((value & 0xFFFFFFFFFF000000L) != -16777216L) {
            return 4;
        }
        if ((value & 0x800000L) == 0L) {
            return 4;
        }
        if ((value & 0xFF0000L) != 0xFF0000L) {
            return 3;
        }
        if ((value & 0x8000L) == 0L) {
            return 3;
        }
        if ((value & 0xFF00L) != 65280L) {
            return 2;
        }
        if ((value & 0x80L) == 0L) {
            return 2;
        }
        return 1;
    }

    public void writeUnsignedInt(long value) {
        this.writeUnsignedLong(value);
    }

    public void writeUnsignedLong(long value) {
        int position = this.pos;
        int c = 255;
        while (value > 0L || c > 127) {
            c = (int)(value & 0xFFL);
            this.insert(c, position);
            value >>= 8;
        }
    }

    public void insertLong(long value, int position) {
        if (value == 0L) {
            this.insert(0, position);
        }
        while (value > 0L) {
            this.insert((int)(value & 0xFFL), position);
            value >>= 8;
        }
    }

    public void writeTagLong(long value) {
        int position = this.pos;
        this.insert((int)(value & 0x7FL), position);
        value >>= 7;
        while (value > 0L) {
            this.insert((int)(value & 0x7FL | 0x80L), position);
            value >>= 7;
        }
    }

    private void insertLength(int len, int position) {
        int fieldLen = this.lengthForLength(len);
        this.insertLong(len, position);
        if (fieldLen > 1) {
            this.insert(fieldLen - 1 | 0x80, position);
        }
    }

    private int lengthForLength(int len) {
        if (len <= 127) {
            return 1;
        }
        int size = 1;
        while (len > 255) {
            len >>= 8;
            ++size;
        }
        return size + 1;
    }

    public String toString() {
        if (this.endOfData <= 0) {
            return "no data";
        }
        StringBuffer sb = new StringBuffer();
        int len = this.endOfData;
        if (this.endOfData > this.data.length) {
            len = this.data.length;
        }
        if (len == 0) {
            return "";
        }
        int bytes = len;
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(Integer.toString(this.data[i] & 0xFF, 16));
        }
        return sb.toString();
    }

    public void insertTag(int tag, int position) {
        int dataLen = this.endOfData - position;
        this.insert(tag, position);
        this.insertLength(dataLen, position + 1);
    }

    private void insert(int val, int position) {
        this.pos = position;
        int dataLen = this.endOfData - this.pos;
        ++this.endOfData;
        if (this.endOfData >= this.data.length) {
            this.expand(50);
        }
        System.arraycopy(this.data, position, this.data, position + 1, dataLen);
        this.write(val);
        this.pos = this.endOfData;
    }

    public void write(int val) {
        if (this.pos >= this.data.length) {
            this.expand(100);
        }
        this.data[this.pos] = (byte)val;
        ++this.pos;
        if (this.pos > this.endOfData) {
            this.endOfData = this.pos;
        }
    }

    private void expand(int len) {
        byte[] newArray = new byte[this.data.length + len];
        System.arraycopy(this.data, 0, newArray, 0, this.data.length);
        this.data = newArray;
    }
}

