/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpPDU;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;

public class SnmpDriver {
    protected DatagramSocket sock = null;
    private ResponseReceive rec;
    private Thread recThread;
    private BSnmpNetwork snmp;

    public SnmpDriver(BSnmpNetwork snmp) {
        this.snmp = snmp;
    }

    public void start() {
        try {
            this.sock = new DatagramSocket();
            this.rec = new ResponseReceive();
            this.recThread = new Thread((Runnable)this.rec, "Snmp:SchedulerRcv");
            this.recThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.rec != null) {
            this.rec.done = true;
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.recThread != null) {
                this.recThread.interrupt();
            }
        }
    }

    public synchronized SnmpPDU sendRequest(SnmpPDU req, int timeout, int retryCount) {
        SnmpPDU resp = null;
        for (int retries = 0; retries <= retryCount; ++retries) {
            this.rec.reset(req.getReqid());
            ComUtil.send(this.snmp, req, this.sock);
            resp = this.rec.getResponse(timeout);
            if (resp == null) continue;
            return resp;
        }
        return null;
    }

    public synchronized void send(SnmpPDU req) {
        ComUtil.send(this.snmp, req, this.sock);
    }

    private class ResponseReceive
    implements Runnable {
        boolean done = false;
        SnmpPDU msg = null;
        Object sync = new Object();
        int reqId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] ba = new byte[1500];
            DatagramPacket pack = new DatagramPacket(ba, ba.length);
            while (!this.done) {
                if (SnmpDriver.this.sock == null) {
                    try {
                        SnmpDriver.this.sock = new DatagramSocket();
                    }
                    catch (Exception e) {
                        if (SnmpDriver.this.snmp == null || !SnmpDriver.this.snmp.log().isLoggable(Level.FINE)) continue;
                        SnmpDriver.this.snmp.log().fine("SnmpDriver could not initialize socket connection");
                        continue;
                    }
                }
                pack.setLength(ba.length);
                SnmpPDU pdu = ComUtil.receive(SnmpDriver.this.snmp, SnmpDriver.this.sock, pack);
                if (pdu == null) {
                    if (this.done) {
                        return;
                    }
                    if (SnmpDriver.this.snmp.log().isLoggable(Level.FINE)) {
                        SnmpDriver.this.snmp.log().fine("SnmpDriver reinitializing socket connection");
                    }
                    try {
                        if (SnmpDriver.this.sock != null) {
                            SnmpDriver.this.sock.close();
                        }
                        SnmpDriver.this.sock = new DatagramSocket();
                    }
                    catch (Exception e) {
                        if (SnmpDriver.this.snmp == null || !SnmpDriver.this.snmp.log().isLoggable(Level.FINE)) continue;
                        SnmpDriver.this.snmp.log().fine("SnmpDriver could not reinitialize socket connection");
                    }
                    continue;
                }
                if (pdu.getCommand() != 162) continue;
                Object object = this.sync;
                synchronized (object) {
                    if (pdu.getReqid() == this.reqId) {
                        this.msg = pdu;
                        this.sync.notify();
                    }
                }
            }
        }

        public void reset(int reqId) {
            this.reqId = reqId;
            this.msg = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SnmpPDU getResponse(int timeout) {
            Object object = this.sync;
            synchronized (object) {
                if (this.msg == null) {
                    try {
                        this.sync.wait(timeout);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return this.msg;
        }
    }
}

