/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.point.agent;

import com.tridium.snmp.datatypes.BSnmpAgentStringDefaultValue;
import com.tridium.snmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpAgentStringProxyExt
extends BSnmpAgentProxyExt {
    public static final Property defaultValue = BSnmpAgentStringProxyExt.newProperty((int)0, (BValue)new BSnmpAgentStringDefaultValue(), null);
    public static final Action resetPointToDefault = BSnmpAgentStringProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpAgentStringProxyExt.class);

    public BSnmpAgentStringDefaultValue getDefaultValue() {
        return (BSnmpAgentStringDefaultValue)this.get(defaultValue);
    }

    public void setDefaultValue(BSnmpAgentStringDefaultValue v) {
        this.set(defaultValue, (BValue)v, null);
    }

    public void resetPointToDefault() {
        this.invoke(resetPointToDefault, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)defaultValue, 4);
            this.setFlags((Slot)resetPointToDefault, 4);
        } else {
            this.doResetPointToDefault();
        }
    }

    public void doResetPointToDefault() {
        this.readOk((BStatusValue)new BStatusString(this.getDefaultValue().getDefaultValue()));
    }

    @Override
    public SnmpVar getValue() {
        BStringPoint pnt = (BStringPoint)this.getParentPoint();
        return SnmpUtil.getSnmpVar(pnt.getOutStatusString().getValue(), this.getVariableType());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        SnmpUtil.getString(var);
    }

    @Override
    public SnmpVar setValue(SnmpVar var) {
        try {
            String sval = SnmpUtil.getString(var);
            this.readOk((BStatusValue)new BStatusString(sval));
            if (this.getDefaultValue().getAutoSet()) {
                this.getDefaultValue().setDefaultValue(sval);
            }
            this.getParentPoint().doExecute();
            return this.getValue();
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }
}

