/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.point.agent;

import com.tridium.snmp.datatypes.BSnmpAgentNumericDefaultValue;
import com.tridium.snmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpAgentNumericProxyExt
extends BSnmpAgentProxyExt {
    public static final Property defaultValue = BSnmpAgentNumericProxyExt.newProperty((int)0, (BValue)new BSnmpAgentNumericDefaultValue(), null);
    public static final Action resetPointToDefault = BSnmpAgentNumericProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSnmpAgentNumericProxyExt.class);

    public BSnmpAgentNumericDefaultValue getDefaultValue() {
        return (BSnmpAgentNumericDefaultValue)this.get(defaultValue);
    }

    public void setDefaultValue(BSnmpAgentNumericDefaultValue v) {
        this.set(defaultValue, (BValue)v, null);
    }

    public void resetPointToDefault() {
        this.invoke(resetPointToDefault, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)defaultValue, 4);
            this.setFlags((Slot)resetPointToDefault, 4);
        } else {
            this.doResetPointToDefault();
        }
    }

    public void doResetPointToDefault() {
        this.readOk((BStatusValue)new BStatusNumeric(this.getDefaultValue().getDefaultValue()));
    }

    @Override
    public SnmpVar getValue() {
        BNumericPoint pnt = (BNumericPoint)this.getParentPoint();
        return SnmpUtil.getSnmpVar(pnt.getNumeric(), this.getVariableType());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        SnmpUtil.getNumeric(var);
    }

    @Override
    public SnmpVar setValue(SnmpVar var) {
        try {
            double dval = SnmpUtil.getNumeric(var);
            this.readOk((BStatusValue)new BStatusNumeric(dval));
            if (this.getDefaultValue().getAutoSet()) {
                this.getDefaultValue().setDefaultValue(dval);
            }
            this.getParentPoint().doExecute();
            return this.getValue();
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }
}

