/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.object;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.object.BSnmpObjectDeviceExt;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSnmpObjectExt
extends BProxyExt
implements PointEntry {
    public static final Property status = BSnmpObjectExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property objectIdentifier = BSnmpObjectExt.newProperty((int)64, (String)"", null);
    public static final Property variableType = BSnmpObjectExt.newProperty((int)0, (BValue)BSnmpVariableTypeEnum.integerType, null);
    public static final Property description = BSnmpObjectExt.newProperty((int)64, (String)"", null);
    public static final Type TYPE = Sys.loadType(BSnmpObjectExt.class);
    int lastHash = -1;

    @Override
    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    @Override
    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return (BSnmpVariableTypeEnum)this.get(variableType);
    }

    public void setVariableType(BSnmpVariableTypeEnum v) {
        this.set(variableType, (BValue)v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BSnmpNetwork snmp = this.snmp();
        if (this.getObjectIdentifier().indexOf(snmp.getEnterprise()) != 0) {
            String oid = snmp.getEnterprise() + ".1.7.0.0";
            this.setObjectIdentifier(oid);
        }
        snmp.objects().registerIoObject(this);
        snmp.mibChanged();
    }

    public void stopped() throws Exception {
        this.snmp().objects().unregisterIoObject(this);
        this.snmp().mibChanged();
        super.stopped();
    }

    public Type getDeviceExtType() {
        return BSnmpObjectDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public boolean write(Context cx) throws Exception {
        BStatusValue out = this.getWriteValue();
        this.writeOk(out);
        this.readOk(out);
        return true;
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public BSnmpNetwork snmp() {
        return (BSnmpNetwork)SnmpUtil.getParent((BComponent)this, BSnmpNetwork.TYPE);
    }

    public PointContainer getPointContainer() {
        return (PointContainer)this.getParent();
    }

    @Override
    public int getIndex() {
        String oid = this.getObjectIdentifier();
        int lastNdx = oid.lastIndexOf(46);
        int pentuNdx = oid.lastIndexOf(46, lastNdx - 1);
        return Integer.parseInt(oid.substring(pentuNdx + 1, lastNdx));
    }

    @Override
    public void setIndex(int ndx) {
        String oid = this.getObjectIdentifier();
        int pentuNdx = oid.lastIndexOf(46, oid.lastIndexOf(46) - 1);
        oid = oid.substring(0, pentuNdx + 1).concat(Integer.toString(ndx)).concat(".0");
        this.setObjectIdentifier(oid);
    }

    @Override
    public String getPointName() {
        return this.getParentPoint().getName();
    }

    @Override
    public int getLastHash() {
        return this.lastHash;
    }

    @Override
    public void setLastHash(int n) {
        this.lastHash = n;
    }

    @Override
    public boolean isSettablePoint() {
        return !this.getParentPoint().isWritablePoint();
    }

    public String toString(Context context) {
        return this.getPointName() + " (" + this.getObjectIdentifier() + ")";
    }
}

