/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.datatypes;

import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNetworkManagerList
extends BComponent {
    public static final Action addIpAddress = BNetworkManagerList.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action clear = BNetworkManagerList.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BNetworkManagerList.class);

    public void addIpAddress(BString param) {
        this.invoke(addIpAddress, (BValue)param, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNetworkManagerList() {
    }

    public BNetworkManagerList(BString[] list) {
        this.setAddressList(list);
    }

    public synchronized String[] getAddressList() {
        String[] temp = new String[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BString.class)) {
            BValue kid = c.get();
            temp[count] = ((BString)kid).getString();
            ++count;
        }
        String[] result = new String[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void addEntry(BString entry) {
        String name = this.makeValidName(this.getLexicon().getText("manager.strings.source"));
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        this.add(name, (BValue)entry);
    }

    private String makeValidName(String name) {
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        int count = 2;
        boolean firstRename = true;
        while (this.getSlot(name) != null) {
            if (firstRename) {
                name = name + "_" + count;
                firstRename = false;
            } else {
                name = name.substring(0, name.lastIndexOf(95)) + "_" + count;
            }
            ++count;
        }
        return name;
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void setAddressList(BString[] pointList) {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        if (pointList != null) {
            for (int i = 0; i < pointList.length; ++i) {
                this.addEntry(pointList[i]);
            }
        }
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void doClear() {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void doAddIpAddress(BString param) {
        this.addEntry(param);
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }
}

