/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.datatypes;

import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMibListEntry
extends BComponent {
    public static final Property entryName = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property oid = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property objectSyntax = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property displayHint = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property variableType = BMibListEntry.newProperty((int)0, (BValue)BSnmpVariableTypeEnum.integerType, null);
    public static final Property status = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property access = BMibListEntry.newProperty((int)0, (BValue)BSnmpAccessEnum.notAccessible, null);
    public static final Property desc = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property elementType = BMibListEntry.newProperty((int)0, (BValue)BSnmpMipEntryTypeEnum.DEFAULT, null);
    public static final Property value = BMibListEntry.newProperty((int)0, (String)"", null);
    public static final Property tableValues = BMibListEntry.newProperty((int)0, (BValue)new BMibListTable(), null);
    public static final Property enumRange = BMibListEntry.newProperty((int)0, (BValue)BEnumRange.NULL, null);
    public static final Property constraint = BMibListEntry.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BMibListEntry.class);

    public String getEntryName() {
        return this.getString(entryName);
    }

    public void setEntryName(String v) {
        this.setString(entryName, v, null);
    }

    public String getOid() {
        return this.getString(oid);
    }

    public void setOid(String v) {
        this.setString(oid, v, null);
    }

    public String getObjectSyntax() {
        return this.getString(objectSyntax);
    }

    public void setObjectSyntax(String v) {
        this.setString(objectSyntax, v, null);
    }

    public String getDisplayHint() {
        return this.getString(displayHint);
    }

    public void setDisplayHint(String v) {
        this.setString(displayHint, v, null);
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return (BSnmpVariableTypeEnum)this.get(variableType);
    }

    public void setVariableType(BSnmpVariableTypeEnum v) {
        this.set(variableType, (BValue)v, null);
    }

    public String getStatus() {
        return this.getString(status);
    }

    public void setStatus(String v) {
        this.setString(status, v, null);
    }

    public BSnmpAccessEnum getAccess() {
        return (BSnmpAccessEnum)this.get(access);
    }

    public void setAccess(BSnmpAccessEnum v) {
        this.set(access, (BValue)v, null);
    }

    public String getDesc() {
        return this.getString(desc);
    }

    public void setDesc(String v) {
        this.setString(desc, v, null);
    }

    public BSnmpMipEntryTypeEnum getElementType() {
        return (BSnmpMipEntryTypeEnum)this.get(elementType);
    }

    public void setElementType(BSnmpMipEntryTypeEnum v) {
        this.set(elementType, (BValue)v, null);
    }

    public String getValue() {
        return this.getString(value);
    }

    public void setValue(String v) {
        this.setString(value, v, null);
    }

    public BMibListTable getTableValues() {
        return (BMibListTable)this.get(tableValues);
    }

    public void setTableValues(BMibListTable v) {
        this.set(tableValues, (BValue)v, null);
    }

    public BEnumRange getEnumRange() {
        return (BEnumRange)this.get(enumRange);
    }

    public void setEnumRange(BEnumRange v) {
        this.set(enumRange, (BValue)v, null);
    }

    public BFacets getConstraint() {
        return (BFacets)this.get(constraint);
    }

    public void setConstraint(BFacets v) {
        this.set(constraint, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMibListEntry() {
    }

    public BMibListEntry(String entryName, String oid, String syntax, String displayHint, BSnmpVariableTypeEnum variableType, BSnmpAccessEnum access, String status, String desc, BSnmpMipEntryTypeEnum elementType) {
        if (entryName != null) {
            this.setEntryName(entryName);
        }
        if (oid != null) {
            this.setOid(oid);
        }
        if (syntax != null) {
            this.setObjectSyntax(syntax);
        }
        if (displayHint != null) {
            if (displayHint.startsWith("\"") && displayHint.endsWith("\"")) {
                displayHint = displayHint.substring(1, displayHint.length() - 1);
            }
            this.setDisplayHint(displayHint);
        }
        if (variableType != null) {
            this.setVariableType(variableType);
        }
        if (access != null) {
            this.setAccess(access);
        }
        if (status != null) {
            this.setStatus(status);
        }
        if (desc != null) {
            this.setDesc(desc);
        }
        if (elementType != null) {
            this.setElementType(elementType);
        }
    }

    public BMibListEntry(BMibListEntry entry) {
        this.copyFrom((BComplex)entry);
    }

    public String toString(Context context) {
        return this.getDesc();
    }

    public String toDebugString() {
        return this.toString(null);
    }

    public String toDisplayString() {
        return "name           " + this.getEntryName() + "\noid           " + this.getOid() + "\ntype          " + this.getObjectSyntax() + "\naccess        " + this.getAccess().getTag() + "\nstatus        " + this.getStatus() + "\nelementType   " + (Object)((Object)this.getElementType()) + "\ndescription   " + this.getDesc();
    }

    public void addChild(BMibListEntry child) {
        this.getTableValues().addEntry(child);
    }

    public void clearChildren() {
        this.getTableValues().clearEntries();
    }

    public boolean hasChildren() {
        return this.getTableValues().getPointList().length > 0;
    }

    public BMibListEntry[] getChildren() {
        return this.getTableValues().getPointList();
    }

    public boolean hasEnumRange() {
        return !this.getEnumRange().equals((Object)BEnumRange.NULL);
    }
}

