/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp;

import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpDeviceFolder;
import com.tridium.snmp.BSnmpPollScheduler;
import com.tridium.snmp.datatypes.BNetworkManagerList;
import com.tridium.snmp.messages.SnmpRequest;
import com.tridium.snmp.messages.SnmpStopRequest;
import com.tridium.snmp.mib.TridiumMib;
import com.tridium.snmp.mib.table.AlarmTable;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.services.SnmpDriver;
import com.tridium.snmp.services.SnmpReceive;
import com.tridium.snmp.services.SnmpReceiveTraps;
import com.tridium.snmp.snmptypes.GenericTrap;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.util.SnmpUtil;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.firewall.BServerPort;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

public class BSnmpNetwork
extends BDeviceNetwork
implements BIService,
PointContainer {
    public static final Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property tuningPolicies = BSnmpNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property dispatcher = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicWorker(), null);
    public static final Property worker = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property writeWorker = BSnmpNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property pollScheduler = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpPollScheduler(), null);
    public static final Property enterprise = BSnmpNetwork.newProperty((int)1, (String)"1.3.6.1.4.1.4131", null);
    public static final Property contact = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.contact"), null);
    public static final Property systemName = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.name"), null);
    public static final Property location = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.location"), null);
    public static final Property snmpReceiveRequests = BSnmpNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("network.enableReceive"), (String)lex.getText("network.disableReceive")));
    public static final Property snmpReceivePort = BSnmpNetwork.newProperty((int)0, (BValue)BSnmpNetwork.initSnmpReceivePort(), null);
    public static final Property ignoreRequestsFromUnrecognizedSources = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property recognizedSources = BSnmpNetwork.newProperty((int)0, (BValue)new BNetworkManagerList(), null);
    public static final Property checkCommunityOnRequests = BSnmpNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property readOnlyCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property readWriteCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property snmpReceiveTraps = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property snmpReceiveTrapsPort = BSnmpNetwork.newProperty((int)0, (BValue)BSnmpNetwork.initSnmpReceiveTrapsPort(), null);
    public static final Property defaultNetworkManagerIpAddress = BSnmpNetwork.newProperty((int)0, (String)"", null);
    public static final Property defaultNetworkManagerTrapsPort = BSnmpNetwork.newProperty((int)0, (int)162, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property defaultNetworkManagerSnmpVersion = BSnmpNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    public static final Property defaultNetworkManagerTrapsCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    public static final Property snmpAlarmTableCapacity = BSnmpNetwork.newProperty((int)0, (int)500, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)0, (int)250000));
    public static final Property localDevice = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpAgent(), null);
    public static final Action clearSnmpAlarmTable = BSnmpNetwork.newAction((int)144, null);
    public static final Type TYPE = Sys.loadType(BSnmpNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private Logger log = null;
    private int reqId = 0;
    private AlarmTable alarms;
    private PointTable inputs;
    private PointTable outputs;
    private PointTable objects;
    private SnmpReceiveTraps unsolicitedReceive = null;
    private SnmpDriver snmpDriver = null;
    private boolean networkInitComplete = false;
    private boolean networkStartComplete = false;
    private Object reqIdSync = new Object();
    private long startupTime = 0L;
    private static TridiumMib mib = null;
    private static SnmpReceive snmpReceive;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BBasicWorker getDispatcher() {
        return (BBasicWorker)this.get(dispatcher);
    }

    public void setDispatcher(BBasicWorker v) {
        this.set(dispatcher, (BValue)v, null);
    }

    public BBasicCoalescingWorker getWorker() {
        return (BBasicCoalescingWorker)this.get(worker);
    }

    public void setWorker(BBasicCoalescingWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public BBasicCoalescingWorker getWriteWorker() {
        return (BBasicCoalescingWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BBasicCoalescingWorker v) {
        this.set(writeWorker, (BValue)v, null);
    }

    public BSnmpPollScheduler getPollScheduler() {
        return (BSnmpPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BSnmpPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public String getEnterprise() {
        return this.getString(enterprise);
    }

    public void setEnterprise(String v) {
        this.setString(enterprise, v, null);
    }

    public String getContact() {
        return this.getString(contact);
    }

    public void setContact(String v) {
        this.setString(contact, v, null);
    }

    public String getSystemName() {
        return this.getString(systemName);
    }

    public void setSystemName(String v) {
        this.setString(systemName, v, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    public boolean getSnmpReceiveRequests() {
        return this.getBoolean(snmpReceiveRequests);
    }

    public void setSnmpReceiveRequests(boolean v) {
        this.setBoolean(snmpReceiveRequests, v, null);
    }

    public BServerPort getSnmpReceivePort() {
        return (BServerPort)this.get(snmpReceivePort);
    }

    public void setSnmpReceivePort(BServerPort v) {
        this.set(snmpReceivePort, (BValue)v, null);
    }

    public boolean getIgnoreRequestsFromUnrecognizedSources() {
        return this.getBoolean(ignoreRequestsFromUnrecognizedSources);
    }

    public void setIgnoreRequestsFromUnrecognizedSources(boolean v) {
        this.setBoolean(ignoreRequestsFromUnrecognizedSources, v, null);
    }

    public BNetworkManagerList getRecognizedSources() {
        return (BNetworkManagerList)this.get(recognizedSources);
    }

    public void setRecognizedSources(BNetworkManagerList v) {
        this.set(recognizedSources, (BValue)v, null);
    }

    public boolean getCheckCommunityOnRequests() {
        return this.getBoolean(checkCommunityOnRequests);
    }

    public void setCheckCommunityOnRequests(boolean v) {
        this.setBoolean(checkCommunityOnRequests, v, null);
    }

    public String getReadOnlyCommunity() {
        return this.getString(readOnlyCommunity);
    }

    public void setReadOnlyCommunity(String v) {
        this.setString(readOnlyCommunity, v, null);
    }

    public String getReadWriteCommunity() {
        return this.getString(readWriteCommunity);
    }

    public void setReadWriteCommunity(String v) {
        this.setString(readWriteCommunity, v, null);
    }

    public boolean getSnmpReceiveTraps() {
        return this.getBoolean(snmpReceiveTraps);
    }

    public void setSnmpReceiveTraps(boolean v) {
        this.setBoolean(snmpReceiveTraps, v, null);
    }

    public BServerPort getSnmpReceiveTrapsPort() {
        return (BServerPort)this.get(snmpReceiveTrapsPort);
    }

    public void setSnmpReceiveTrapsPort(BServerPort v) {
        this.set(snmpReceiveTrapsPort, (BValue)v, null);
    }

    public String getDefaultNetworkManagerIpAddress() {
        return this.getString(defaultNetworkManagerIpAddress);
    }

    public void setDefaultNetworkManagerIpAddress(String v) {
        this.setString(defaultNetworkManagerIpAddress, v, null);
    }

    public int getDefaultNetworkManagerTrapsPort() {
        return this.getInt(defaultNetworkManagerTrapsPort);
    }

    public void setDefaultNetworkManagerTrapsPort(int v) {
        this.setInt(defaultNetworkManagerTrapsPort, v, null);
    }

    public int getDefaultNetworkManagerSnmpVersion() {
        return this.getInt(defaultNetworkManagerSnmpVersion);
    }

    public void setDefaultNetworkManagerSnmpVersion(int v) {
        this.setInt(defaultNetworkManagerSnmpVersion, v, null);
    }

    public String getDefaultNetworkManagerTrapsCommunity() {
        return this.getString(defaultNetworkManagerTrapsCommunity);
    }

    public void setDefaultNetworkManagerTrapsCommunity(String v) {
        this.setString(defaultNetworkManagerTrapsCommunity, v, null);
    }

    public int getSnmpAlarmTableCapacity() {
        return this.getInt(snmpAlarmTableCapacity);
    }

    public void setSnmpAlarmTableCapacity(int v) {
        this.setInt(snmpAlarmTableCapacity, v, null);
    }

    public BSnmpAgent getLocalDevice() {
        return (BSnmpAgent)this.get(localDevice);
    }

    public void setLocalDevice(BSnmpAgent v) {
        this.set(localDevice, (BValue)v, null);
    }

    public void clearSnmpAlarmTable() {
        this.invoke(clearSnmpAlarmTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public Type getDeviceType() {
        return BSnmpDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSnmpDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "snmp");
    }

    public void serviceStarted() throws Exception {
        this.alarms = new AlarmTable(this);
        this.inputs = new PointTable();
        this.outputs = new PointTable();
        this.objects = new PointTable();
        this.unsolicitedReceive = new SnmpReceiveTraps(this);
        snmpReceive = new SnmpReceive(this);
        this.snmpDriver = new SnmpDriver(this);
        this.networkInitComplete = true;
    }

    public void serviceStopped() {
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BSnmpAgent) {
            throw new LocalizableRuntimeException("snmp", "addLocalDeviceError");
        }
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        acc.add((Object)this.getLocalDevice());
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public void started() throws Exception {
        super.started();
        BComponent[] networks = Sys.getServices((Type)TYPE);
        if (networks.length > 1) {
            for (int i = 0; i < networks.length; ++i) {
                ((BSnmpNetwork)networks[i]).configFatal("Only one SNMP Network is allowed per station. Remove duplicate SNMP network(s) and restart station.");
            }
        }
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log().isLoggable(Level.FINE)) {
                this.log().fine(this + " *** Starting SNMP communication ***");
            }
            this.inputs.start();
            this.outputs.start();
            this.objects.start();
            this.snmpDriver.start();
            if (this.getSnmpReceiveRequests()) {
                snmpReceive.start();
            }
            if (this.getSnmpReceiveTraps()) {
                this.unsolicitedReceive.start();
            }
            this.networkStartComplete = true;
        }
    }

    public void stopped() throws Exception {
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine(this + " *** Stopping SNMP communication ***");
        }
        SnmpStopRequest stopReq = new SnmpStopRequest();
        this.postRequest(stopReq);
        stopReq.stop();
        this.snmpDriver.stop();
        snmpReceive.stop();
        this.unsolicitedReceive.stop();
        this.networkStartComplete = false;
        super.stopped();
    }

    public void atSteadyState() {
        this.startupTime = Clock.ticks();
        if (this.isCommActive() && this.getDefaultNetworkManagerIpAddress().length() > 0) {
            GenericTrap.sendColdStart(this);
        }
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == status && this.networkInitComplete) {
            if (!(this.isDisabled() || this.isDown() || this.isFatalFault() || this.networkStartComplete)) {
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().fine(this + " *** Starting SNMP communication ***");
                }
                this.snmpDriver.start();
                if (this.getSnmpReceiveRequests()) {
                    snmpReceive.start();
                }
                this.inputs.start();
                this.outputs.start();
                this.objects.start();
                if (this.getSnmpReceiveTraps()) {
                    this.unsolicitedReceive.start();
                }
                this.networkStartComplete = true;
            } else if (this.networkStartComplete) {
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().fine(this + " *** Stopping SNMP communication ***");
                }
                SnmpStopRequest stopReq = new SnmpStopRequest();
                this.postRequest(stopReq);
                stopReq.stop();
                this.snmpDriver.stop();
                snmpReceive.stop();
                this.unsolicitedReceive.stop();
                this.networkStartComplete = false;
            }
        } else if (prop.equals(snmpReceiveTraps) && this.networkInitComplete && this.networkStartComplete) {
            if (this.getSnmpReceiveTraps()) {
                this.unsolicitedReceive.start();
            } else {
                this.unsolicitedReceive.stop();
            }
        } else if (prop.equals(snmpReceiveRequests) && this.networkInitComplete && this.networkStartComplete) {
            if (this.getSnmpReceiveRequests()) {
                snmpReceive.start();
            } else {
                snmpReceive.stop();
            }
        } else if (prop.equals(snmpReceiveTrapsPort) && this.getSnmpReceiveTraps() && this.networkInitComplete && this.networkStartComplete) {
            this.unsolicitedReceive.stop();
            this.unsolicitedReceive.start();
        } else if (prop.equals(snmpReceivePort) && this.getSnmpReceiveRequests() && this.networkInitComplete && this.networkStartComplete) {
            snmpReceive.stop();
            snmpReceive.start();
        } else if (prop.equals(snmpAlarmTableCapacity) && this.networkInitComplete) {
            this.alarms.setCapacity(this.getSnmpAlarmTableCapacity());
        }
    }

    public boolean isCommActive() {
        return this.networkStartComplete;
    }

    public void doClearSnmpAlarmTable() {
        if (this.alarms != null) {
            this.alarms.clearAlarmTable();
        }
    }

    public IFuture postSync(Runnable r) {
        return this.getDispatcher().post(r);
    }

    public IFuture postRequest(Runnable req) {
        return this.getWorker().post(req);
    }

    public IFuture postCoalescingRequest(Runnable req) {
        return this.getWriteWorker().post(req);
    }

    public SnmpPDU sendAsyncRequest(SnmpPDU msg, int timeout, int retryCount) {
        return this.send(msg, timeout, retryCount, true, true);
    }

    public SnmpPDU sendAsyncRequest(SnmpPDU msg, int timeout, int retryCount, boolean responseExpected) {
        return this.send(msg, timeout, retryCount, true, responseExpected);
    }

    public SnmpPDU sendRequest(SnmpPDU msg, int timeout, int retryCount) {
        return this.send(msg, timeout, retryCount, false, true);
    }

    public SnmpPDU sendRequest(SnmpPDU msg, int timeout, int retryCount, boolean responseExpected) {
        return this.send(msg, timeout, retryCount, false, responseExpected);
    }

    protected SnmpPDU send(SnmpPDU msg, int timeout, int retryCount, boolean async, boolean responseExpected) {
        if (!this.isCommActive()) {
            return null;
        }
        SnmpRequest req = new SnmpRequest(this, msg, timeout, retryCount, responseExpected);
        if (responseExpected) {
            if (async) {
                this.postSync(req);
            } else {
                req.execute();
            }
            SnmpPDU response = req.getResponse(timeout * retryCount);
            if (response != null) {
                try {
                    BSnmpDevice destDevice = this.findDevice(msg.getDestinationIp());
                    if (destDevice != null) {
                        destDevice.pingOk();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return response;
        }
        if (async) {
            this.postSync(req);
        } else {
            req.execute();
        }
        return null;
    }

    public BSnmpDevice findDevice(InetAddress address) {
        if (address == null) {
            return null;
        }
        BDevice[] devices = this.getDevices();
        if (devices == null) {
            return null;
        }
        for (int i = 0; i < devices.length; ++i) {
            InetAddress devAddr;
            if (devices[i] == null || !(devices[i] instanceof BSnmpDevice) || (devAddr = ((BSnmpDevice)devices[i]).getInetAddress()) == null || !devAddr.equals(address)) continue;
            return (BSnmpDevice)devices[i];
        }
        return null;
    }

    public AlarmTable alarms() {
        return this.alarms;
    }

    public PointTable inputs() {
        return this.inputs;
    }

    public PointTable outputs() {
        return this.outputs;
    }

    public PointTable objects() {
        return this.objects;
    }

    public synchronized TridiumMib getMib() {
        if (mib == null) {
            mib = new TridiumMib(this);
        }
        return mib;
    }

    public synchronized void mibChanged() {
        mib = null;
    }

    @Override
    public PointTable getTable(boolean input) {
        return input ? this.inputs() : this.outputs();
    }

    @Override
    public String getObjectIdentifier() {
        return "1.3.6.1.4.1.4131.1";
    }

    public InetAddress getManagerIp() {
        try {
            return InetAddress.getByName(this.getDefaultNetworkManagerIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public DatagramSocket getSocket() {
        if (this.getSnmpReceiveRequests()) {
            return snmpReceive.getSocket();
        }
        return null;
    }

    @Override
    public void registerIoObject(PointEntry ioObj) {
        if (ioObj.isSettablePoint()) {
            this.inputs.registerIoObject(ioObj);
        } else {
            this.outputs.registerIoObject(ioObj);
        }
    }

    @Override
    public void unregisterIoObject(PointEntry ioObj) {
        if (ioObj.isSettablePoint()) {
            this.inputs.unregisterIoObject(ioObj);
        } else {
            this.outputs.unregisterIoObject(ioObj);
        }
    }

    public long getTimeTick() {
        long elapsedTime = (Clock.ticks() - this.startupTime) / 10L;
        if (elapsedTime < 0L) {
            elapsedTime = Clock.ticks();
        }
        while (elapsedTime > 0xFFFFFFFFL) {
            elapsedTime -= 0xFFFFFFFFL;
        }
        return elapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextReqid() {
        Object object = this.reqIdSync;
        synchronized (object) {
            return this.reqId++;
        }
    }

    public SnmpDriver snmpDriver() {
        return this.snmpDriver;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)("Snmp Alarm Table " + this.getEnterprise() + ".1.3"), 2);
        out.endProps();
        this.alarms.spy(out);
        out.startProps();
        out.trTitle((Object)("Snmp Input Table" + this.getEnterprise() + ".1.4"), 2);
        out.endProps();
        this.inputs.spy(out);
        out.startProps();
        out.trTitle((Object)("Snmp Output Table" + this.getEnterprise() + ".1.5"), 2);
        out.endProps();
        this.outputs.spy(out);
        PointContainer[] pcs = (PointContainer[])SnmpUtil.getDecendantsByClass((BComponent)this, PointContainer.class);
        for (int i = 0; i < pcs.length; ++i) {
            this.spyExport(out, pcs[i]);
        }
        if (this.objects.getArray().length > 0) {
            out.startProps();
            out.trTitle((Object)"Snmp Objects 1.3.6.1.4.1.4131.1.7", 2);
            out.endProps();
            this.objects.spy(out);
        }
        out.startProps();
        out.trTitle((Object)"Current Mib representation for this station", 4);
        out.endProps();
        this.getMib().spy(out);
    }

    public void spyExport(SpyWriter out, PointContainer pc) throws Exception {
        String name = ((BComponent)pc).getName();
        out.startProps();
        out.trTitle((Object)(name + " Input Table " + pc.getObjectIdentifier() + ".1"), 2);
        out.endProps();
        pc.getTable(true).spy(out);
        out.startProps();
        out.trTitle((Object)(name + " Output Table" + pc.getObjectIdentifier() + ".2"), 2);
        out.endProps();
        pc.getTable(false).spy(out);
    }

    private static BServerPort initSnmpReceivePort() {
        BServerPort port = new BServerPort(161, IpProtocol.UDP);
        Property slot = port.getProperty("publicServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)4999, (int)10));
        slot = port.getProperty("localServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)4999, (int)10));
        return port;
    }

    private static BServerPort initSnmpReceiveTrapsPort() {
        BServerPort port = new BServerPort(162, IpProtocol.UDP);
        Property slot = port.getProperty("publicServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)4999, (int)10));
        slot = port.getProperty("localServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)4999, (int)10));
        return port;
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger("snmp");
        }
        return this.log;
    }
}

