/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lontunnel;

import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.loncomm.RawMessage;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="identifier", type="String", defaultValue="none", flags=1), @NiagaraProperty(name="deviceName", type="String", defaultValue="LON1")})
public class BLonTunnel
extends BTunnel
implements LonListener,
TunnelConst,
NetMessages {
    public static final Property identifier = BLonTunnel.newProperty((int)1, (String)"none", null);
    public static final Property deviceName = BLonTunnel.newProperty((int)0, (String)"LON1", null);
    public static final Type TYPE = Sys.loadType(BLonTunnel.class);
    private boolean[] tagOutstanding = new boolean[16];
    private byte[] lastEscapeReq = null;
    private boolean statusInitialized = false;
    private int reset_cause;
    private int state;
    private int version;
    private int model;
    private static final int ADDRESS_TABLE_LEN = 15;
    private static final int ADDRESS_ENTRY_LEN = 5;
    private byte[][] adrTab;
    private boolean adrTabInitialized = false;
    private static final int DOMAIN_TABLE_LEN = 15;
    private byte[] domain0 = new byte[15];
    private byte[] domain1 = new byte[15];
    private boolean domainInitialized = false;
    private static final int CONFIG_TABLE_LEN = 27;
    private byte[] config;
    private boolean configInitialized = false;
    private static final int READ_ONLY_TABLE_LEN = 48;
    private byte[] readOnly;
    private boolean readOnlyInitialized = false;
    private Logger log = null;
    private boolean connected = false;
    private NLonComm lonComm = null;
    private BTunnelConnection[] conns = null;
    public static final int MAX_EXPICIT_MSG_CODE = 78;

    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String v) {
        this.setString(identifier, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setIdentifier(this.getDeviceName());
        super.started();
        this.log().info("lontunnel started for: " + this.getDeviceName());
    }

    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
        this.log().info("lontunnel stopped for: " + this.getDeviceName());
    }

    public void service(BTunnelConnection cx) throws IOException {
        this.log().info("service(TunnelConnection)::thread=" + Thread.currentThread().getName());
        byte[] len = new byte[2];
        byte[] respbuffer = new byte[300];
        Vector<byte[]> respVect = new Vector<byte[]>(10);
        while (cx.isConnected()) {
            if (cx.read(len, 0, 2) != 2) {
                cx.disconnect();
                break;
            }
            int msgLen = (len[0] << 8) + (len[1] & 0xFF);
            byte[] a = new byte[msgLen];
            int lenRead = cx.read(a, 0, msgLen);
            try {
                this.processMessage(a, respVect);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            while (!respVect.isEmpty()) {
                byte[] respMsg = respVect.elementAt(0);
                respVect.removeElementAt(0);
                if (respMsg == null) continue;
                this.writeMessage(respbuffer, cx, respMsg);
            }
        }
    }

    private void writeMessage(byte[] buffer, BTunnelConnection cx, byte[] msg) throws IOException {
        int msgLen = msg.length;
        buffer[0] = (byte)(msgLen >> 8 & 0xFF);
        buffer[1] = (byte)(msgLen & 0xFF);
        System.arraycopy(msg, 0, buffer, 2, msgLen);
        cx.write(buffer, 0, msgLen + 2);
    }

    public void sessionClosed(BTunnelConnection cx) {
        this.log().info(" session closed");
        this.doDisconnectAll();
    }

    public boolean supportsConcurrentConnections() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(BTunnelConnection session) {
        super.addConnection(session);
        this.startLonTunnel();
        BLonTunnel bLonTunnel = this;
        synchronized (bLonTunnel) {
            this.conns = this.getTunnelConnectionsArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(BTunnelConnection session) {
        super.removeConnection(session);
        this.stopLonTunnel();
        BLonTunnel bLonTunnel = this;
        synchronized (bLonTunnel) {
            this.conns = this.getTunnelConnectionsArray();
        }
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == deviceName) {
            this.setIdentifier(this.getDeviceName());
        }
        super.changed(property, context);
    }

    public boolean startLonTunnel() {
        int i;
        if (!this.getEnabled() || this.connected) {
            return true;
        }
        BComponent[] a = Sys.getServices((Type)BLonNetwork.TYPE);
        for (i = 0; i < a.length; ++i) {
            BLonNetwork net = (BLonNetwork)a[i];
            if (!net.getLonCommConfig().getDeviceName().equals(this.getDeviceName())) continue;
            this.lonComm = (NLonComm)net.lonComm();
            this.connected = true;
            break;
        }
        if (!this.connected) {
            return false;
        }
        this.lonComm.registerLonListener((LonListener)this, 127, null, RawMessage.class);
        this.lonComm.registerLonListener((LonListener)this, 125, null, RawMessage.class);
        for (i = 0; i < 78; ++i) {
            this.lonComm.registerLonListener((LonListener)this, i, null, RawMessage.class);
        }
        return false;
    }

    public void stopLonTunnel() {
        if (!this.connected) {
            return;
        }
        this.lonComm.unregisterLonListener((LonListener)this, 127, null);
        this.lonComm.unregisterLonListener((LonListener)this, 125, null);
        for (int i = 0; i < 78; ++i) {
            this.lonComm.unregisterLonListener((LonListener)this, i, null);
        }
        this.connected = false;
        this.lonComm = null;
        this.log().info("BLonTunnel.stopLonTunnel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLonMessage(LonMessage msg) {
        byte[] lastEscReq = this.lastEscapeReq;
        try {
            byte[] raw = ((RawMessage)msg).getRawData();
            if (raw[16] == 125 && lastEscReq != null) {
                raw[2] = (byte)(raw[2] & 0xF0 | lastEscReq[2] & 0xF);
            }
            if ((raw[2] & 0x60) == 96) {
                this.tagOutstanding[raw[2] & 0xF] = true;
            }
            this.log().fine("returning unsolicited message(" + this.msgToString(raw) + ")");
            BLonTunnel bLonTunnel = this;
            synchronized (bLonTunnel) {
                byte[] respbuffer = new byte[300];
                for (int i = 0; i < this.conns.length; ++i) {
                    this.writeMessage(respbuffer, this.conns[i], raw);
                }
            }
        }
        catch (Exception e) {
            this.log().severe("Exception in VlonService.receiveLonMessage  " + e);
            e.printStackTrace();
        }
    }

    private void initTagOutstanding() {
        for (int i = 0; i < 16; ++i) {
            this.tagOutstanding[i] = false;
        }
    }

    private boolean processMessage(byte[] a, Vector<byte[]> respVect) {
        boolean success;
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine("*****\nVlonService.processMessage    (" + this.msgToString(a) + ")");
        }
        if ((success = this.doProcessMessage(a, respVect)) && this.log().isLoggable(Level.FINE)) {
            for (int i = 0; i < respVect.size(); ++i) {
                this.log().fine("returning response message   (" + this.msgToString(respVect.elementAt(i)) + ")");
            }
        }
        return success;
    }

    private boolean doProcessMessage(byte[] a, Vector<byte[]> respVect) {
        if (a.length == 0) {
            this.log().severe("*** Zero length message received. ***");
            return false;
        }
        int code = a[0] & 0xFF;
        switch (code) {
            case 80: 
            case 96: {
                respVect.addElement(a);
                return true;
            }
            case 112: {
                return false;
            }
            case 224: {
                byte[] resp = new byte[]{-32, 1, 35};
                respVect.addElement(resp);
                return true;
            }
            case 144: {
                byte[] resp1 = new byte[]{96, 0};
                respVect.addElement(resp1);
                return true;
            }
        }
        if (a.length <= 16) {
            if (this.log().isLoggable(Level.FINE)) {
                this.log().fine("*** Ignoring local command in VlonService.terminalInput(). ***");
                this.log().fine(this.msgToString(a));
            }
            return false;
        }
        if (this.isLocal(a)) {
            if (this.isProcessLonMaker3(a, respVect)) {
                this.log().fine("Create response to lon maker3 message.");
                return true;
            }
            if (this.isProcessNetMgmtMsg(a, respVect)) {
                this.log().fine("Create response to network management message.");
                return true;
            }
        }
        int tag = a[2] & 0xF;
        if ((a[3] & 1) == 1) {
            if (!this.tagOutstanding[tag]) {
                this.log().fine("Rejected response with no outstanding request:" + this.msgToString(a));
                return false;
            }
            this.tagOutstanding[tag] = false;
        }
        try {
            NAppBuffer req = NAppBuffer.makeAppBuffer((byte[])a);
            NAppBuffer resp = null;
            if (req.isResp()) {
                this.lonComm.doSendResponse(req);
                return false;
            }
            if (req.isLocalAddress() && req.isImplicitAddress()) {
                req.setExplicitAddress(true);
            }
            if (a[16] == 125) {
                this.lastEscapeReq = a;
            }
            boolean explicitMsg = req.isExplicitAddress();
            resp = req.isRequest() ? this.lonComm.doLonCommSendRequest(req, tag == 15 ? 15 : -1) : this.lonComm.doLonCommSendNormal(req);
            if (resp == null) {
                return false;
            }
            NAppBuffer ab = resp;
            while (ab != null) {
                ab.setTag(tag);
                ab.setExplicitAddress(explicitMsg);
                byte[] rsp = ab.toNetworkBytes();
                respVect.addElement(rsp);
                ab = ab.nextAppBuffer;
            }
            resp.releaseAppBuffer();
            this.lastEscapeReq = null;
            return true;
        }
        catch (Exception e) {
            this.log().severe("Exception in VlonService.terminalInput  " + e);
            e.printStackTrace();
            return false;
        }
    }

    private boolean isProcessLonMaker3(byte[] a, Vector<byte[]> respVect) {
        if (a[16] == 96) {
            byte[] rsp = new byte[]{22, 15, 115, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            rsp[2] = a[2];
            respVect.addElement(rsp);
            return true;
        }
        if (a[16] == 112) {
            byte[] rsp = new byte[17];
            System.arraycopy(a, 0, rsp, 0, rsp.length);
            rsp[0] = 24;
            rsp[1] = 15;
            respVect.addElement(rsp);
            return true;
        }
        if (a[16] != 125) {
            return false;
        }
        if (a[17] == 1 && a[18] == 1) {
            byte[] rsp = new byte[]{22, 20, 112, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 3, 1, 28, 0, 4};
            rsp[2] = a[2];
            respVect.addElement(rsp);
        } else if (a[17] == 3 && a[18] == 10) {
            byte[] rsp = new byte[]{22, 15, 127, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            respVect.addElement(rsp);
        } else if (a[17] == 3 && a[18] == 15) {
            byte[] rsp = new byte[]{22, 29, 127, 1, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 64, 35, -15, -32, 0, 0, 1, 4, 0, 0, 14, 28, -4, 4};
            respVect.addElement(rsp);
        } else if (a[17] == 3 && a[18] == 102) {
            byte[] rsp = new byte[]{22, 35, 127, 1, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 1, 1, 108, 111, 110, 0, -60, 88, -60, 0, 17, 0, 0, 0, 65, 0, 0, 0, 72};
            respVect.addElement(rsp);
        } else if (a[17] == 3 && (a[18] == 7 || a[18] == 100)) {
            byte[] rsp = new byte[]{22, 15, 127, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61};
            respVect.addElement(rsp);
        } else {
            return false;
        }
        return true;
    }

    private void createResponse(byte[] msg, Vector<byte[]> respVect) {
        respVect.addElement(this.createResponseMsg(msg));
        if (!this.isLocal(msg)) {
            respVect.addElement(this.createCompletionMsg(msg));
        }
    }

    private byte[] createResponseMsg(byte[] msg) {
        return this.createResponseMsg(msg, 1);
    }

    private byte[] createResponseMsg(byte[] msg, int length) {
        byte[] resp = new byte[16 + length];
        resp[0] = 22;
        resp[1] = (byte)(14 + length);
        resp[2] = msg[2];
        resp[3] = (byte)(msg[3] | 1);
        resp[4] = (byte)length;
        resp[16] = (byte)(msg[16] & 0xFFFFFF3F | 0x20);
        return resp;
    }

    private byte[] createCompletionMsg(byte[] msg) {
        msg[0] = 22;
        msg[3] = (byte)(msg[3] & 0xFFFFFFCF | 0x10);
        return msg;
    }

    private boolean isProcessNetMgmtMsg(byte[] msg, Vector<byte[]> respVect) {
        if (!this.isLocal(msg)) {
            return false;
        }
        int msgType = msg[16] & 0xFF;
        switch (msgType) {
            case 99: {
                this.storeDomain(msg);
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 106: {
                respVect.addElement(this.getDomain(msg));
                return true;
            }
            case 100: {
                this.leaveDomain(msg);
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 110: {
                if (msg[17] == 1) {
                    this.storeReadOnly(msg);
                    if (msg[21] != 3) {
                        respVect.addElement(this.createResponseMsg(msg));
                    }
                    return true;
                }
                if (msg[17] == 2) {
                    this.storeConfig(msg);
                    respVect.addElement(this.createResponseMsg(msg));
                    return true;
                }
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 109: {
                if (msg[17] == 1) {
                    byte[] resp = this.readReadOnly(msg);
                    if (resp != null) {
                        respVect.addElement(resp);
                    }
                    return true;
                }
                if (msg[17] == 2) {
                    byte[] resp = this.readConfig(msg);
                    if (resp != null) {
                        respVect.addElement(resp);
                    }
                    return true;
                }
                return false;
            }
            case 102: {
                this.storeAddress(msg);
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 103: {
                respVect.addElement(this.getAddress(msg));
                return true;
            }
            case 108: {
                this.updateMode(msg);
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 81: {
                respVect.addElement(this.getStatus(msg));
                return true;
            }
            case 83: {
                this.clearStatus();
                respVect.addElement(this.createResponseMsg(msg));
                return true;
            }
            case 84: 
            case 97: 
            case 104: 
            case 114: 
            case 115: {
                return false;
            }
        }
        respVect.addElement(this.createResponseMsg(msg));
        return true;
    }

    private boolean isLocal(byte[] msg) {
        return (msg[0] & 0xF0) == 32 || msg[5] == 0 || msg[5] == 127;
    }

    private void updateMode(byte[] msg) {
        this.initStatus();
        byte mode = msg[17];
        switch (mode) {
            case 0: {
                if (this.state != 4) break;
                this.state = 12;
                break;
            }
            case 1: {
                if (this.state == 12) {
                    this.state = 4;
                }
                if (this.state != 140) break;
                this.state = 4;
                break;
            }
            case 2: {
                if (this.state == 12) {
                    this.state = 4;
                }
                if (this.state == 140) {
                    this.state = 4;
                }
                this.reset_cause = 20;
                break;
            }
            case 3: {
                this.state = msg[18];
            }
        }
    }

    private byte[] getStatus(byte[] msg) {
        this.initStatus();
        byte[] resp = this.createResponseMsg(msg, 16);
        resp[27] = (byte)this.reset_cause;
        resp[28] = (byte)this.state;
        resp[29] = (byte)this.version;
        resp[30] = 0;
        resp[31] = (byte)this.model;
        return resp;
    }

    private void clearStatus() {
        this.reset_cause = 0;
    }

    private void initStatus() {
        if (this.statusInitialized) {
            return;
        }
        this.state = 4;
        try {
            QueryStatusResponse qResp = NmUtil.queryStatus((LonComm)this.lonComm, (LonAddress)BLocal.local, (int)0, (boolean)false, (boolean)false);
            this.reset_cause = qResp.getResetCause();
            this.version = qResp.getVersionNumber();
            this.model = qResp.getModelNumber();
        }
        catch (LonException lonException) {
            // empty catch block
        }
        this.statusInitialized = true;
    }

    public void setStatusVersion(int version) {
        this.initStatus();
        this.version = version;
    }

    public void setStatusModel(int model) {
        this.initStatus();
        this.model = model;
    }

    private void initAdrTab() {
        if (this.adrTabInitialized) {
            return;
        }
        this.adrTab = new byte[15][];
        for (int i = 0; i < 15; ++i) {
            this.adrTab[i] = new byte[5];
        }
        this.adrTabInitialized = true;
    }

    private void storeAddress(byte[] msg) {
        this.initAdrTab();
        byte index = msg[17];
        if (index >= 15 || msg.length < 23) {
            return;
        }
        System.arraycopy(msg, 18, this.adrTab[index], 0, 5);
    }

    private byte[] getAddress(byte[] msg) {
        this.initAdrTab();
        byte index = msg[17];
        byte[] resp = this.createResponseMsg(msg, 6);
        if (index < 15) {
            System.arraycopy(this.adrTab[index], 0, resp, 17, 5);
        }
        return resp;
    }

    private void initDomain() {
        if (this.domainInitialized) {
            return;
        }
        try {
            this.initDom(0, this.domain0);
            this.initDom(1, this.domain1);
        }
        catch (Exception e) {
            this.log().severe("ERROR: Failed attempt to initialize domains in VlonService.\n" + e);
            return;
        }
        this.domainInitialized = true;
    }

    private void initDom(int index, byte[] domain) throws LonException {
        QueryDomainResponse domResp = NmUtil.queryDomain((LonComm)this.lonComm, (LonAddress)BLocal.local, (int)index, (boolean)false, (boolean)false);
        System.arraycopy(domResp.getDomainId(), 0, domain, 0, 6);
        domain[6] = (byte)domResp.getSubnet();
        domain[7] = (byte)(domResp.getNodeId() | 0x80);
        domain[8] = (byte)domResp.len;
        System.arraycopy(domResp.getKey(), 0, domain, 9, 6);
    }

    private void storeDomain(byte[] msg) {
        this.initDomain();
        byte domain = msg[17];
        if (domain == 0) {
            this.compareDomain(domain, this.domain0, msg);
            System.arraycopy(msg, 18, this.domain0, 0, 15);
        } else {
            this.compareDomain(domain, this.domain1, msg);
            System.arraycopy(msg, 18, this.domain1, 0, 15);
        }
    }

    private void compareDomain(int entry, byte[] domain, byte[] msg) {
        if (domain[6] != msg[24] || domain[7] != msg[25]) {
            this.log().warning("Attempt to change subnet/node address for domain entry " + entry + " from " + domain[6] + "/" + (domain[7] & 0x7F) + " to " + msg[24] + "/" + (msg[25] & 0x7F));
        }
        boolean domChange = false;
        int len = domain[8] & 0xFF;
        int newLen = msg[26] & 0xFF;
        if (len != newLen) {
            domChange = true;
        } else if (len > 0 && len <= 6) {
            for (int i = 0; i < len; ++i) {
                if (domain[i] == msg[18 + i]) continue;
                domChange = true;
            }
        }
        if (domChange) {
            this.log().warning("Attempt to change domain id for domain entry " + entry + " from {" + this.domainToString(domain, len, 0) + "} to {" + this.domainToString(msg, newLen, 18) + "}");
        }
    }

    private String domainToString(byte[] a, int len, int offset) {
        if (len < 0 || len > 6) {
            return "not in use";
        }
        return LonByteArrayUtil.toString((byte[])a, (int)16, (char)'.', (int)len, (int)offset);
    }

    private byte[] getDomain(byte[] msg) {
        this.initDomain();
        byte[] resp = this.createResponseMsg(msg, 16);
        byte domain = msg[17];
        if (domain == 0) {
            System.arraycopy(this.domain0, 0, resp, 17, 15);
        } else {
            System.arraycopy(this.domain1, 0, resp, 17, 15);
        }
        return resp;
    }

    private void leaveDomain(byte[] msg) {
        byte[] a;
        this.initDomain();
        byte domain = msg[17];
        byte[] byArray = a = domain == 0 ? this.domain0 : this.domain1;
        if ((a[8] & 0xFF) != 255) {
            this.log().warning("Attempt to leave domain " + domain);
        }
        a[8] = -1;
    }

    private void initConfig() {
        if (this.configInitialized) {
            return;
        }
        this.config = new byte[27];
        try {
            this.config = Neuron.getConfigStruct((LonComm)this.lonComm, (LonAddress)BLocal.local, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            this.log().severe("ERROR: Failed attempt to initialize config in VlonService.\n" + e);
            return;
        }
        this.configInitialized = true;
    }

    private void storeConfig(byte[] msg) {
        this.initConfig();
        int offset = (msg[18] << 8) + msg[19];
        byte length = msg[20];
        if (offset + length + 1 > 27) {
            return;
        }
        System.arraycopy(msg, 22, this.config, offset, length);
    }

    private byte[] readConfig(byte[] msg) {
        this.initConfig();
        int offset = (msg[18] << 8) + msg[19];
        byte length = msg[20];
        if (offset + length + 1 > 27) {
            return null;
        }
        byte[] resp = this.createResponseMsg(msg, length + 1);
        System.arraycopy(this.config, offset, resp, 17, length);
        return resp;
    }

    private void initReadOnly() {
        if (this.readOnlyInitialized) {
            return;
        }
        this.readOnly = new byte[48];
        try {
            BLocal sendAddr = BLocal.local;
            int len = 48;
            int readLen = 16;
            for (int bytesRead = 0; bytesRead < len; bytesRead += readLen) {
                if (readLen > len - bytesRead) {
                    readLen = len - bytesRead;
                }
                byte[] a = Neuron.readMemory((LonComm)this.lonComm, (int)1, (LonAddress)sendAddr, (int)bytesRead, (int)readLen, (boolean)false, (boolean)false);
                System.arraycopy(a, 0, this.readOnly, bytesRead, readLen);
            }
        }
        catch (Exception e) {
            this.log().severe("ERROR: Failed attempt to initialize readOnly in VlonService.\n" + e);
            return;
        }
        this.readOnlyInitialized = true;
    }

    private void storeReadOnly(byte[] msg) {
        this.initReadOnly();
        int offset = (msg[18] << 8) + msg[19];
        byte length = msg[20];
        if (offset + length + 1 > 48) {
            return;
        }
        System.arraycopy(msg, 22, this.readOnly, offset, length);
    }

    private byte[] readReadOnly(byte[] msg) {
        this.initReadOnly();
        int offset = (msg[18] << 8) + msg[19];
        byte length = msg[20];
        if (offset + length + 1 > 48) {
            return null;
        }
        byte[] resp = this.createResponseMsg(msg, length + 1);
        System.arraycopy(this.readOnly, offset, resp, 17, length);
        return resp;
    }

    public String msgToString(byte[] a) {
        if (a.length == 0) {
            return "";
        }
        int len = a.length;
        StringBuffer sb = new StringBuffer();
        if (len > a.length) {
            len = a.length;
        }
        if (len == 0) {
            return "";
        }
        for (int i = 0; i < len; ++i) {
            if (i == 2 || i == 5 || i == 16) {
                sb.append(' ');
            }
            if ((a[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toString(a[i] & 0xFF, 16)).append(' ');
        }
        return sb.toString();
    }

    public Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger("tunnel." + this.getDeviceName().toLowerCase());
        }
        return this.log;
    }
}

