/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import javax.baja.gx.Point;
import javax.baja.sys.BComplex;
import javax.baja.sys.Clock;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.tree.TreeSubject;

public class TreeController
extends BTree.TreeSupport {
    private String searchText = "";
    private long lastSearchTime = 0L;
    private TreeNode focus;
    private TreeNode mouseNode;
    private TreeNode lastTarget = null;
    private TreeNode startTarget = null;

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent event) {
        this.getTree().repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.getTree().repaint();
    }

    public void expanded(TreeNode node) {
    }

    public void collapsed(TreeNode node) {
        if (this.focus == null) {
            return;
        }
        if (this.focus.isDescendantOf(node)) {
            this.setFocus(null);
        }
    }

    public TreeNode getFocus() {
        return this.focus;
    }

    public void setFocus(TreeNode node) {
        if (this.focus != null) {
            this.focus.setFocus(false);
        }
        this.focus = node;
        if (this.focus != null) {
            this.focus.setFocus(true);
            this.getTree().fireActionPerformed(new BWidgetEvent(2, this.getTree()));
        }
        this.getTree().repaint();
    }

    protected void mouseSelection(TreeNode target, BMouseEvent evt) {
        boolean released;
        boolean pressed = evt.getId() == 501;
        boolean bl = released = evt.getId() == 502;
        if (target == null) {
            this.getSelection().deselectAll();
            this.lastTarget = null;
            this.startTarget = null;
            this.setFocus(null);
            return;
        }
        if (evt.isControlDown()) {
            if (target.isSelected() && target != this.lastTarget && released) {
                this.getSelection().deselect(target);
                this.lastTarget = null;
            } else if (target.isSelected() && pressed && evt.getClickCount() != 2) {
                this.getSelection().deselect(target);
                this.lastTarget = null;
            } else if (!target.isSelected() && pressed) {
                this.getSelection().select(target);
                this.lastTarget = target;
            }
        } else if (evt.isShiftDown()) {
            if (pressed) {
                if (this.startTarget != null) {
                    this.getSelection().deselectAll();
                    this.getSelection().select(this.startTarget);
                    this.selectBetween(target, this.startTarget);
                }
                this.getSelection().select(target);
                this.lastTarget = target;
            }
        } else if (!target.isSelected() || released) {
            this.getSelection().deselectAll();
            this.getSelection().select(target);
            this.startTarget = this.lastTarget = target;
        }
        this.setFocus(target);
        if (this.startTarget == null) {
            this.startTarget = target;
        }
    }

    public void mouseWheel(BMouseWheelEvent evt) {
    }

    private void selectBetween(TreeNode node1, TreeNode node2) {
        if (node1 == node2) {
            return;
        }
        TreeNode[] list = this.getTree().getVisibleNodes();
        int idx1 = this.getNodeIndex(list, node1);
        int idx2 = this.getNodeIndex(list, node2);
        if (idx1 == -1 || idx2 == -1) {
            return;
        }
        this.getSelection().supressUpdates(true);
        if (idx2 < idx1) {
            int a = idx1;
            idx1 = idx2;
            idx2 = a;
        }
        for (int i = idx1 + 1; i < idx2; ++i) {
            this.getSelection().select(list[i]);
        }
        this.getSelection().supressUpdates(false);
    }

    private int getNodeIndex(TreeNode[] list, TreeNode node) {
        for (int i = 0; i < list.length; ++i) {
            if (node != list[i]) continue;
            return i;
        }
        return -1;
    }

    public void mousePressed(BMouseEvent evt) {
        this.getTree().requestFocus();
        double x = evt.getX();
        double y = evt.getY();
        TreeNode target = this.getTree().yToTreeNode(y);
        if (target != null) {
            if (target.inExpander(x, y)) {
                this.getTree().toggleExpanded(target);
            } else if (target.isSelection(x, y)) {
                this.mouseSelection(target, evt);
                if (!evt.isButton3Down() && evt.getClickCount() == 2) {
                    this.getSelection().deselectAll();
                    this.getSelection().select(target);
                    this.nodeDoubleClicked(evt, target);
                }
            } else {
                target = null;
                this.mouseSelection(null, evt);
            }
        } else {
            this.mouseSelection(null, evt);
        }
        if (evt.isPopupTrigger()) {
            this.popup(evt, target);
        }
    }

    public void mouseReleased(BMouseEvent evt) {
        if (evt.isPopupTrigger()) {
            double x = evt.getX();
            double y = evt.getY();
            TreeNode target = this.getFocus();
            if (target == null && (target = this.getTree().yToTreeNode(y)) != null && !target.isSelection(x, y)) {
                target = null;
            }
            this.popup(evt, target);
        } else {
            TreeNode target = this.getFocus();
            this.mouseSelection(target, evt);
        }
    }

    public void mouseMoved(BMouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        TreeNode target = this.getTree().yToTreeNode(y);
        if (target != null && !target.isSelection(x, y)) {
            target = null;
        }
        this.setMouseNode(target);
    }

    private void setMouseNode(TreeNode node) {
        if (this.mouseNode == node) {
            return;
        }
        TreeNode oldMouseNode = this.mouseNode;
        this.mouseNode = node;
        if (oldMouseNode != null) {
            this.nodeExited(oldMouseNode);
        }
        if (this.mouseNode != null) {
            this.nodeEntered(this.mouseNode);
        }
    }

    public void mouseEntered(BMouseEvent evt) {
        this.mouseMoved(evt);
    }

    public void mouseExited(BMouseEvent evt) {
        this.setMouseNode(null);
    }

    protected void nodeEntered(TreeNode node) {
    }

    protected void nodeExited(TreeNode node) {
    }

    public void mouseDragged(BMouseEvent evt) {
    }

    public void mousePulsed(BMouseEvent evt) {
    }

    protected final void initFocus() {
        TreeNode node = this.getSelection().getNode();
        if (node == null) {
            TreeModel model = this.getModel();
            int rootCount = model.getRootCount();
            if (rootCount == 0) {
                return;
            }
            node = model.getRoot(0);
        }
        this.setFocus(node);
        this.getSelection().deselectAll();
        this.getSelection().select(node);
    }

    public void keyPressed(BKeyEvent evt) {
        if (evt.isControlDown() || evt.isAltDown()) {
            return;
        }
        int keyCode = evt.getKeyCode();
        TreeNode target = this.getFocus();
        if (target != null) {
            switch (keyCode) {
                case 39: {
                    this.getTree().setExpanded(target, true);
                    evt.consume();
                    this.searchText = "";
                    return;
                }
                case 37: {
                    this.getTree().setExpanded(target, false);
                    evt.consume();
                    this.searchText = "";
                    return;
                }
                case 10: {
                    this.doSelectAction(target, target.getX(), target.getY());
                    evt.consume();
                    this.searchText = "";
                    return;
                }
                case 525: {
                    this.popup(new BMouseEvent(501, this.getTree(), 0, this.getSelection().getNode().getX(), this.getSelection().getNode().getY(), 0, true), this.getSelection().getNode());
                }
            }
            char ch = evt.getKeyChar();
            if (32 <= keyCode && keyCode <= 57 || 65 <= keyCode && keyCode <= 90) {
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + ch : "" + ch;
                for (int i = 0; i < this.getModel().getRootCount() && !this.search(this.getModel().getRoot(i), this.searchText); ++i) {
                }
                this.lastSearchTime = Clock.ticks();
                evt.consume();
            }
        }
        switch (keyCode) {
            case 38: {
                this.previousSelection(evt);
                evt.consume();
                this.searchText = "";
                break;
            }
            case 40: {
                this.nextSelection(evt);
                evt.consume();
                this.searchText = "";
            }
        }
    }

    private boolean search(TreeNode node, String searchText) {
        if (null == node) {
            return false;
        }
        TreeSelection sel = this.getSelection();
        String text = node.getText();
        if (text != null && text.length() > 0 && text.toLowerCase().startsWith(searchText.toLowerCase())) {
            sel.deselectAll();
            sel.select(node);
            this.setFocus(node);
            this.getTree().scrollNodeToVisible(node);
            return true;
        }
        if (node.isExpanded()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!this.search(node.getChild(i), searchText)) continue;
                return true;
            }
        }
        return false;
    }

    public void keyReleased(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        if (event.getKeyCode() == 10) {
            this.handleEnter(event);
        } else if (event.getKeyCode() == 27) {
            this.handleEscape(event);
        }
    }

    public void keyTyped(BKeyEvent evt) {
    }

    protected void handleEnter(BKeyEvent event) {
        event.consume();
        this.getTree().fireActionPerformed(new BWidgetEvent(2, this.getTree()));
    }

    protected void handleEscape(BKeyEvent event) {
        event.consume();
        this.getTree().fireCancelled(new BWidgetEvent(2, this.getTree()));
    }

    private void previousSelection(BKeyEvent evt) {
        TreeNode current = this.getFocus();
        if (current == null) {
            this.initFocus();
        } else {
            TreeNode newSelection = this.getTree().getPrevious(current);
            if (newSelection != null) {
                if (evt != null && (evt.isControlDown() || evt.isShiftDown())) {
                    this.getSelection().getSelection().select(newSelection);
                } else {
                    this.getSelection().deselectAll();
                    this.getSelection().select(newSelection);
                }
                this.setFocus(newSelection);
                this.getTree().scrollNodeToVisible(newSelection);
            }
        }
    }

    private void nextSelection(BKeyEvent evt) {
        TreeNode current = this.getFocus();
        if (current == null) {
            this.initFocus();
        } else {
            TreeNode newSelection = this.getTree().getNext(current);
            if (newSelection != null) {
                if (evt != null && (evt.isControlDown() || evt.isShiftDown())) {
                    this.getSelection().select(newSelection);
                } else {
                    this.getSelection().deselectAll();
                    this.getSelection().select(newSelection);
                }
                this.setFocus(newSelection);
                this.getTree().scrollNodeToVisible(newSelection);
            }
        }
    }

    protected void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
        this.doSelectAction(node, event.getX(), event.getY());
    }

    protected void doSelectAction(TreeNode target, double x, double y) {
    }

    public boolean pulseViewport(double x, double y) {
        BComplex parent = this.getTree().getParent();
        if (parent instanceof BScrollPane) {
            return ((BScrollPane)parent).pulseViewport(new Point(x, y), this.getNodeRenderer().getHeight());
        }
        return false;
    }

    protected void popup(BMouseEvent event, TreeNode node) {
        TreeSubject subject = this.getSelection().getSubject(node);
        BMenu menu = this.makePopup(subject);
        if (menu != null) {
            menu.removeConsecutiveSeparators();
            menu.open(event);
        }
    }

    protected BMenu makePopup(TreeSubject subject) {
        return null;
    }
}

