/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.transfer;

import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellManager;
import javax.baja.space.Mark;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferConst;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;
import javax.baja.ui.util.UiLexicon;

public abstract class BTransferWidget
extends BWidget
implements TransferConst {
    public static final Type TYPE = Sys.loadType(BTransferWidget.class);
    boolean cutEnabled = false;
    boolean copyEnabled = false;
    boolean pasteEnabled = false;
    boolean pasteSpecialEnabled = false;
    boolean duplicateEnabled = false;
    boolean deleteEnabled = false;
    boolean renameEnabled = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isCutEnabled() {
        return this.cutEnabled;
    }

    public void setCutEnabled(boolean cutEnabled) {
        if (this.cutEnabled == cutEnabled) {
            return;
        }
        this.cutEnabled = cutEnabled;
        this.updateStates();
    }

    public boolean isCopyEnabled() {
        return this.copyEnabled;
    }

    public void setCopyEnabled(boolean copyEnabled) {
        if (this.copyEnabled == copyEnabled) {
            return;
        }
        this.copyEnabled = copyEnabled;
        this.updateStates();
    }

    public boolean isPasteEnabled() {
        return this.pasteEnabled;
    }

    public void setPasteEnabled(boolean pasteEnabled) {
        if (this.pasteEnabled == pasteEnabled) {
            return;
        }
        this.pasteEnabled = pasteEnabled;
        this.updateStates();
    }

    public boolean isPasteSpecialEnabled() {
        return this.pasteSpecialEnabled;
    }

    public void setPasteSpecialEnabled(boolean pasteSpecialEnabled) {
        if (this.pasteSpecialEnabled == pasteSpecialEnabled) {
            return;
        }
        this.pasteSpecialEnabled = pasteSpecialEnabled;
        this.updateStates();
    }

    public boolean isDuplicateEnabled() {
        return this.duplicateEnabled;
    }

    public void setDuplicateEnabled(boolean duplicateEnabled) {
        if (this.duplicateEnabled == duplicateEnabled) {
            return;
        }
        this.duplicateEnabled = duplicateEnabled;
        this.updateStates();
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public void setDeleteEnabled(boolean deleteEnabled) {
        if (this.deleteEnabled == deleteEnabled) {
            return;
        }
        this.deleteEnabled = deleteEnabled;
        this.updateStates();
    }

    public boolean isRenameEnabled() {
        return this.renameEnabled;
    }

    public void setRenameEnabled(boolean renameEnabled) {
        if (this.renameEnabled == renameEnabled) {
            return;
        }
        this.renameEnabled = renameEnabled;
        this.updateStates();
    }

    private void updateStates() {
        BWidgetShell shell = this.getShell();
        if (shell instanceof NiagaraWbShell) {
            ((NiagaraWbShell)((Object)shell)).updateTransferWidgetStates();
        }
    }

    public void startDrag(BMouseEvent event, TransferContext context, DragRenderer dragRenderer) {
        ShellManager manager = (ShellManager)this.widgetSupport(null);
        manager.startDragOperation(this, event, context, dragRenderer);
    }

    public void startDrag(BMouseEvent event, TransferEnvelope envelope, DragRenderer dragRenderer) {
        this.startDrag(event, this.makeTransferContext(envelope), dragRenderer);
    }

    public void dragEnter(TransferContext cx) {
    }

    public int dragOver(TransferContext cx) {
        return 0;
    }

    public void dragExit(TransferContext cx) {
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doCopy() throws Exception {
        this.setCurrentMark(null);
        if (!this.copyEnabled) {
            return null;
        }
        TransferEnvelope envelope = this.getTransferData();
        if (envelope == null) {
            return null;
        }
        Clipboard.getDefault().setContents(envelope);
        if (envelope.supports(TransferFormat.mark)) {
            Mark mark = (Mark)envelope.getData(TransferFormat.mark);
            this.setCurrentMark(mark);
        }
        return null;
    }

    public CommandArtifact doCut() throws Exception {
        this.setCurrentMark(null);
        if (!this.cutEnabled) {
            return null;
        }
        TransferEnvelope envelope = this.getTransferData();
        if (envelope == null) {
            return null;
        }
        Clipboard.getDefault().setContents(envelope);
        if (envelope.supports(TransferFormat.mark)) {
            Mark mark = (Mark)envelope.getData(TransferFormat.mark);
            mark.setPendingMove(true);
            this.setCurrentMark(mark);
        }
        TransferContext cx = this.makeTransferContext(null, 32, envelope);
        return this.removeTransferData(cx);
    }

    public CommandArtifact doPaste() throws Exception {
        if (!this.pasteEnabled) {
            return null;
        }
        try {
            Mark mark;
            TransferEnvelope envelope = Clipboard.getDefault().getContents();
            if (envelope == null) {
                BDialog.error(this, UiLexicon.bajaui().getText("command.paste.emptyClipboard"));
                return null;
            }
            int action = 16;
            if (envelope.supports(TransferFormat.mark) && (mark = (Mark)envelope.getData(TransferFormat.mark)).isPendingMove()) {
                action = 32;
                Clipboard.getDefault().setContents(null);
                this.setCurrentMark(null);
                mark.setPendingMove(false);
            }
            TransferContext cx = this.makeTransferContext(null, action, envelope);
            return this.insertTransferData(cx);
        }
        catch (UnsupportedFormatException e) {
            BDialog.error(this, UiLexicon.bajaui().getText("command.paste.unsupportedFormat"));
            return null;
        }
    }

    public CommandArtifact doPasteSpecial() throws Exception {
        if (!this.pasteSpecialEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doDuplicate() throws Exception {
        if (!this.duplicateEnabled) {
            return null;
        }
        TransferEnvelope envelope = this.getTransferData();
        if (envelope == null) {
            return null;
        }
        TransferContext cx = this.makeTransferContext(null, 16, envelope);
        return this.insertTransferData(cx);
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.deleteEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public CommandArtifact doRename() throws Exception {
        if (!this.renameEnabled) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public abstract TransferEnvelope getTransferData() throws Exception;

    public abstract CommandArtifact insertTransferData(TransferContext var1) throws Exception;

    public abstract CommandArtifact removeTransferData(TransferContext var1) throws Exception;

    public final TransferContext makeTransferContext(TransferEnvelope envelope) {
        return this.makeTransferContext(null, 16, envelope);
    }

    public TransferContext makeTransferContext(Context sourceContext, int action, TransferEnvelope envelope) {
        return new TransferContext(sourceContext, action, envelope);
    }

    void setCurrentMark(Mark mark) {
        Mark.setCurrent((Mark)mark);
        this.getShell().repaint();
    }
}

