/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;
import javax.baja.ui.util.UiLexicon;

public class FindNext
extends TextEditorCommand {
    Position foundPosition;

    public FindNext(BTextEditor editor) {
        super(editor, BKeyBindings.findNext);
    }

    public Position getFoundPosition() {
        return this.foundPosition;
    }

    @Override
    public CommandArtifact doInvoke() {
        FindPattern pattern = FindPattern.getCurrent();
        String string = pattern.string;
        Position pos = this.editor.getModel().findNext(pattern);
        if (pos != null) {
            this.foundPosition = pos;
            Position end = new Position(pos.line, pos.column + string.length());
            this.editor.getSelection().select(pos, end);
            this.editor.getShell().showStatus("Line: " + (pos.line + 1) + " Column: " + (pos.column + 1));
        } else {
            this.editor.getShell().showStatus(UiLexicon.bajaui().getText("noMore") + ": " + string);
        }
        return null;
    }
}

