/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.commands.EditCommand;

public class DeleteWord
extends EditCommand {
    public DeleteWord(BTextEditor editor) {
        super(editor, BKeyBindings.deleteWord);
    }

    @Override
    public CommandArtifact doInvoke() {
        Position from = this.editor.getCaretPosition();
        Position to = null;
        Line line = this.editor.getModel().getLine(from.line);
        Segment seg = line.getSegmentAt(from.column);
        if (seg != null) {
            to = new Position(from.line, seg.offset + seg.length);
        } else if (from.line + 1 < this.editor.getModel().getLineCount()) {
            from = new Position(from.line, line.getColumnCountWithoutNewline());
            to = new Position(from.line, from.column + 1);
        }
        if (to != null) {
            return this.remove(from, to);
        }
        return null;
    }
}

