/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.collection.BITable;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.UiLexicon;

public class TableController
extends BTable.TableSupport {
    private int overResize = -1;
    private int overHeader = -1;
    private int overRow = -1;
    private int overColumn = -1;
    private boolean overBackground;
    private boolean checkSelectionOnRelease;
    private String searchText = "";
    private long lastSearchTime = 0L;

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent event) {
        BTable table = this.getTable();
        TableSelection sel = table.getSelection();
        if (sel.getRow() == -1 && table.getModel().getRowCount() > 0) {
            sel.select(0);
        }
        this.getTable().repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.getTable().repaint();
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getModifiers() != 0 && event.getModifiers() != 1) {
            return;
        }
        int key = event.getKeyCode();
        BTable table = this.getTable();
        TableSelection sel = table.getSelection();
        int anchor = sel.getAnchor();
        int lead = sel.getLead();
        int visible = table.getVisibleRowCount();
        int top = table.getVscrollBar().getPosition();
        int moveTo = -1;
        switch (key) {
            case 36: {
                moveTo = 0;
                this.searchText = "";
                break;
            }
            case 35: {
                moveTo = table.getModel().getRowCount() - 1;
                this.searchText = "";
                break;
            }
            case 38: {
                moveTo = Math.max(lead - 1, 0);
                this.searchText = "";
                break;
            }
            case 40: {
                moveTo = Math.min(lead + 1, table.getModel().getRowCount() - 1);
                this.searchText = "";
                break;
            }
            case 33: {
                moveTo = lead > top && lead <= top + visible ? Math.max(top, 0) : Math.max(lead - visible + 1, 0);
                this.searchText = "";
                break;
            }
            case 34: {
                moveTo = lead > top && lead < top + visible - 1 ? Math.min(top + visible - 1, table.getModel().getRowCount() - 1) : Math.min(lead + visible - 1, table.getModel().getRowCount() - 1);
                this.searchText = "";
            }
        }
        if (moveTo != -1) {
            event.consume();
            if (event.isShiftDown()) {
                sel.select(anchor, moveTo, true);
            } else {
                sel.select(moveTo, true);
            }
            table.ensureRowIsVisible(moveTo);
        } else if (this.getTextSearchColumn() != -1) {
            char ch = event.getKeyChar();
            if (32 <= key && key <= 57 || 65 <= key && key <= 90) {
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + ch : "" + ch;
                if (!this.search(this.searchText)) {
                    // empty if block
                }
                this.lastSearchTime = Clock.ticks();
                event.consume();
            }
        }
    }

    public int getTextSearchColumn() {
        return -1;
    }

    private boolean search(String jumpText) {
        TableModel model = this.table.getModel();
        TableSelection sel = this.getSelection();
        int index = -1;
        for (int i = 0; i < model.getRowCount(); ++i) {
            String text = model.getValueAt(i, this.getTextSearchColumn()).toString();
            if (text == null || text.length() <= 0 || !text.toLowerCase().startsWith(jumpText.toLowerCase())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            sel.select(index, true);
            this.table.ensureRowIsVisible(index);
            return true;
        }
        return false;
    }

    public void keyReleased(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        if (event.getKeyCode() == 10) {
            this.handleEnter(event);
        } else if (event.getKeyCode() == 27) {
            this.handleEscape(event);
        }
    }

    public void keyTyped(BKeyEvent event) {
    }

    protected void handleEnter(BKeyEvent event) {
        event.consume();
        this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
    }

    protected void handleEscape(BKeyEvent event) {
        event.consume();
        this.getTable().fireCancelled(new BWidgetEvent(2, this.getTable()));
    }

    public void mousePressed(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellPressed(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerPressed(event, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotPressed(event, this.overResize);
        } else if (this.overBackground) {
            this.backgroundPressed(event);
        }
        if (this.overRow != -1) {
            this.getTable().requestFocus();
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellReleased(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerReleased(event, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotReleased(event, this.overResize);
        } else if (this.overBackground) {
            this.backgroundReleased(event);
        }
        this.checkMouseOver(event);
    }

    public void mouseEntered(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.fireExit(event);
    }

    public void mouseMoved(BMouseEvent event) {
        if (this.checkMouseOver(event)) {
            return;
        }
        if (this.overRow != -1) {
            this.cellMoved(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerMoved(event, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotMoved(event, this.overResize);
        } else if (this.overBackground) {
            this.backgroundMoved(event);
        }
    }

    public void mouseDragged(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellDragged(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerDragged(event, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotDragged(event, this.overResize);
        } else if (this.overBackground) {
            this.backgroundDragged(event);
        }
    }

    public void mousePulsed(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellPulsed(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerPulsed(event, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotPulsed(event, this.overResize);
        } else if (this.overBackground) {
            this.backgroundPulsed(event);
        }
    }

    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = this.getTable().getVscrollBar();
        sb.scrollByUnits(event.getPreciseWheelRotation());
    }

    public void mouseHover(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellHover(event, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerHover(event, this.overHeader);
        } else if (this.overBackground) {
            this.backgroundHover(event);
        }
    }

    private boolean checkMouseOver(BMouseEvent event) {
        BTable table = this.getTable();
        double mx = event.getX();
        double my = event.getY();
        int row = table.getRowAt(my);
        int col = table.getColumnAt(mx);
        if (row == -1 || col == -1) {
            if (!this.overBackground) {
                this.fireExit(event);
                this.overBackground = true;
                this.backgroundEntered(event);
                return true;
            }
        } else if (row == Integer.MAX_VALUE) {
            int resize = this.getResize(table, col, mx);
            if (resize != -1) {
                if (this.overResize != resize) {
                    this.fireExit(event);
                    this.overResize = resize;
                    this.resizeHotspotEntered(event, this.overResize);
                    return true;
                }
                return false;
            }
            if (this.overHeader != col) {
                this.fireExit(event);
                this.overHeader = col;
                this.headerEntered(event, this.overHeader);
                return true;
            }
        } else {
            int resize;
            if (this.getTable().getExtendedResize() && (resize = this.getResize(table, col, mx)) != -1) {
                if (this.overResize != resize) {
                    this.fireExit(event);
                    this.overResize = resize;
                    this.resizeHotspotEntered(event, this.overResize);
                    return true;
                }
                return false;
            }
            if (this.overRow != row || this.overColumn != col) {
                this.fireExit(event);
                this.overRow = row;
                this.overColumn = col;
                this.cellEntered(event, this.overRow, this.overColumn);
                return true;
            }
        }
        return false;
    }

    private int getResize(BTable table, int col, double mx) {
        mx = table.translateXToTable(mx);
        int colCount = table.getModel().getColumnCount();
        int resize = -1;
        RectGeom rect = table.getHeaderBounds(col);
        double leftEdge = rect.x;
        double rightEdge = rect.x + rect.width;
        if (mx > rightEdge - 4.0 && col != colCount - 1) {
            resize = col + 1;
        } else if (mx < leftEdge + 4.0 && col != 0) {
            resize = col;
        }
        return resize;
    }

    private void fireExit(BMouseEvent event) {
        if (this.overRow != -1) {
            this.cellExited(event, this.overRow, this.overColumn);
            this.overColumn = -1;
            this.overRow = -1;
        } else if (this.overHeader != -1) {
            this.headerExited(event, this.overHeader);
            this.overHeader = -1;
        } else if (this.overResize != -1) {
            this.resizeHotspotExited(event, this.overResize);
            this.overResize = -1;
        } else if (this.overBackground) {
            this.backgroundExited(event);
            this.overBackground = false;
        }
    }

    public int getMouseOverHeader() {
        return this.overHeader;
    }

    public int getMouseOverColumn() {
        return this.overColumn;
    }

    public int getMouseOverRow() {
        return this.overRow;
    }

    public int getMouseOverResizeColumn() {
        return this.overResize;
    }

    protected void headerEntered(BMouseEvent event, int column) {
    }

    protected void headerExited(BMouseEvent event, int column) {
    }

    protected void headerPressed(BMouseEvent event, int column) {
        BTable table;
        if (event.isButton1Down() && (table = this.getTable()).getModel().isColumnSortable(column)) {
            boolean ascending = table.isSortAscending();
            if (table.getSortColumn() == column) {
                table.sortByColumn(column, !ascending);
            } else {
                table.sortByColumn(column, ascending);
            }
        }
        if (event.isPopupTrigger()) {
            this.headerPopup(event, column);
        }
    }

    protected void headerReleased(BMouseEvent event, int column) {
        if (event.isPopupTrigger()) {
            this.headerPopup(event, column);
        }
    }

    protected void headerMoved(BMouseEvent event, int column) {
    }

    protected void headerDragged(BMouseEvent event, int column) {
    }

    protected void headerPulsed(BMouseEvent event, int column) {
    }

    protected void headerPopup(BMouseEvent event, int column) {
        DynamicTableModel dynamicModel;
        TableModel model = this.getModel();
        if (model instanceof DynamicTableModel && (dynamicModel = (DynamicTableModel)model).isColumnShowable(column = dynamicModel.toRootColumnIndex(column))) {
            BMenu menu = new BMenu();
            menu.add(null, new HideColumnCommand(dynamicModel, column));
            menu.open(this.getTable(), event.getX(), event.getY());
        }
    }

    protected void headerHover(BMouseEvent event, int column) {
    }

    protected void cellEntered(BMouseEvent event, int row, int column) {
    }

    protected void cellExited(BMouseEvent event, int row, int column) {
    }

    protected void cellPressed(BMouseEvent event, int row, int column) {
        if (this.getSelection().isSelected(row)) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(event, row);
        }
        if (event.isPopupTrigger()) {
            this.cellPopup(event, row, column);
        }
        if (event.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.cellDoubleClicked(event, row, column);
        }
    }

    protected void cellReleased(BMouseEvent event, int row, int column) {
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!event.isPopupTrigger()) {
                this.checkSelection(event, row);
            }
        }
        if (event.isPopupTrigger()) {
            this.cellPopup(event, row, column);
        }
    }

    protected void cellMoved(BMouseEvent event, int row, int column) {
    }

    protected void cellDragged(BMouseEvent event, int row, int column) {
    }

    protected void cellPulsed(BMouseEvent event, int row, int column) {
    }

    protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
    }

    protected void cellHover(BMouseEvent event, int row, int column) {
    }

    protected void resizeHotspotPressed(BMouseEvent event, int column) {
    }

    protected void resizeHotspotReleased(BMouseEvent event, int column) {
    }

    protected void resizeHotspotEntered(BMouseEvent event, int column) {
        this.getTable().setMouseCursor(MouseCursor.eResize);
    }

    protected void resizeHotspotExited(BMouseEvent event, int column) {
        this.getTable().setMouseCursor(MouseCursor.normal);
    }

    protected void resizeHotspotMoved(BMouseEvent event, int column) {
    }

    protected void resizeHotspotDragged(BMouseEvent event, int column) {
        this.getTable().setColumnPosition(column, event.getX());
    }

    protected void resizeHotspotPulsed(BMouseEvent event, int column) {
    }

    protected void backgroundEntered(BMouseEvent event) {
    }

    protected void backgroundExited(BMouseEvent event) {
    }

    protected void backgroundPressed(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.backgroundPopup(event);
        } else if (!event.isButton3Down()) {
            this.getSelection().deselectAll();
        }
    }

    protected void backgroundReleased(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.backgroundPopup(event);
        }
    }

    protected void backgroundMoved(BMouseEvent event) {
    }

    protected void backgroundDragged(BMouseEvent event) {
    }

    protected void backgroundPulsed(BMouseEvent event) {
    }

    protected void backgroundHover(BMouseEvent event) {
    }

    protected void cellPopup(BMouseEvent event, int row, int column) {
        this.popup(event, row, column);
    }

    protected void backgroundPopup(BMouseEvent event) {
        this.popup(event, -1, -1);
    }

    protected void popup(BMouseEvent event, int row, int col) {
        TableSubject subject = this.getSelection().getSubject(row);
        BMenu menu = this.makePopup(subject);
        if (menu != null) {
            menu.removeConsecutiveSeparators();
            menu.open(event);
        }
    }

    protected BMenu makePopup(TableSubject subject) {
        return null;
    }

    public void doOptions() {
        BMenu menu = this.makeOptionsMenu();
        if (menu != null) {
            BTable table = this.getTable();
            menu.computePreferredSize();
            BButton b = table.getOptionsButton();
            double x = b.getX() + b.getWidth();
            double y = b.getY() + b.getHeight();
            if (x <= 0.0) {
                x = 0.0;
            }
            if (y <= 0.0) {
                y = 0.0;
            }
            menu.open(table, x -= menu.getPreferredWidth(), y);
        }
    }

    protected BMenu makeOptionsMenu() {
        BTable table = this.getTable();
        TableModel model = this.getModel();
        BMenu menu = new BMenu();
        menu.add("resizeColumns", new ResizeColumnsCommand(table));
        menu.add("export", new ExportCommand(table));
        if (model instanceof DynamicTableModel) {
            DynamicTableModel dynamicModel = (DynamicTableModel)model;
            menu.add("showSep", (BValue)new BSeparator());
            int count = 0;
            for (int i = 0; i < dynamicModel.getRootColumnCount(); ++i) {
                if (!dynamicModel.isColumnShowable(i)) continue;
                menu.add(null, new ShowColumnCommand(dynamicModel, i));
                ++count;
            }
            if (count == 0) {
                menu.remove("showSep");
            }
        }
        return menu;
    }

    static CommandArtifact exportDialog(BTable table, boolean asPrint) throws Exception {
        try {
            BITable<? extends BIObject> itable = table.getModel().export();
            Type type = Sys.getType((String)"workbench:ExportDialog");
            Class cls = type.getTypeClass();
            Method method = cls.getMethod("invoke", BWidget.class, BITable.class, Boolean.TYPE);
            return (CommandArtifact)method.invoke(null, table, itable, new Boolean(asPrint));
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    protected void checkSelection(BMouseEvent event, int row) {
        BTable table = this.getTable();
        TableSelection sel = table.getSelection();
        if (table.getMultipleSelection()) {
            if (event.isShiftDown() && sel.getAnchor() >= 0) {
                sel.select(sel.getAnchor(), row, !event.isControlDown());
            } else if (event.isControlDown()) {
                if (sel.isSelected(row)) {
                    sel.deselect(row);
                } else {
                    sel.select(row);
                }
            } else {
                sel.select(row, true);
                this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
            }
        } else {
            sel.select(row, true);
            this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
        }
    }

    class ShowColumnCommand
    extends ToggleCommand {
        DynamicTableModel model;
        int column;

        ShowColumnCommand(DynamicTableModel model, int column) {
            super(model.getTable(), model.getRootColumnName(column));
            this.model = model;
            this.column = column;
            this.setSelected(model.showColumn(column));
        }

        @Override
        public void setSelected(boolean sel) {
            super.setSelected(sel);
            this.model.setShowColumn(this.column, sel);
        }
    }

    class HideColumnCommand
    extends Command {
        DynamicTableModel model;
        int column;

        HideColumnCommand(DynamicTableModel model, int column) {
            super((BWidget)model.getTable(), UiLexicon.bajaui().module, "commands.table.hideColumn");
            this.model = model;
            this.column = column;
        }

        @Override
        public CommandArtifact doInvoke() {
            this.model.setShowColumn(this.column, false);
            return null;
        }
    }

    public class ExportCommand
    extends Command {
        public ExportCommand(BTable owner) {
            super((BWidget)owner, UiLexicon.bajaui().module, "commands.export");
            this.accelerator = null;
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            return TableController.exportDialog((BTable)this.getOwner(), true);
        }
    }

    class PrintCommand
    extends Command {
        PrintCommand(BTable owner) {
            super((BWidget)owner, UiLexicon.bajaui().module, "commands.print");
            this.accelerator = null;
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            return TableController.exportDialog((BTable)this.getOwner(), true);
        }
    }

    public class ResizeColumnsCommand
    extends Command {
        public ResizeColumnsCommand(BTable owner) {
            super((BWidget)owner, UiLexicon.bajaui().module, "commands.table.resizeColumns");
        }

        @Override
        public CommandArtifact doInvoke() {
            TableController.this.getTable().sizeColumnsToFit();
            return null;
        }
    }
}

