/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.BitSet;
import javax.baja.sys.BObject;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;

public class DynamicTableModel
extends WrapperTableModel {
    BitSet showCols = new BitSet();
    BitSet showable = new BitSet();
    int showCount = -1;
    int[] toRootMap;
    int[] fromRootMap;

    public DynamicTableModel(TableModel root, int[] showColumns) {
        super(root);
        for (int i = 0; i < showColumns.length; ++i) {
            this.showCols.set(showColumns[i]);
        }
        DynamicTableModel.set(this.showable, 0, root.getColumnCount());
    }

    public DynamicTableModel(TableModel root) {
        super(root);
        DynamicTableModel.set(this.showCols, 0, 255);
        DynamicTableModel.set(this.showable, 0, 255);
    }

    @Override
    public int getColumnCount() {
        if (this.showCount < 0) {
            this.columnsModified();
        }
        return this.showCount;
    }

    @Override
    public String getColumnName(int col) {
        return this.root.getColumnName(this.toRootColumnIndex(col));
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.root.getValueAt(row, this.toRootColumnIndex(col));
    }

    @Override
    public Object getSubject(int row) {
        return this.root.getSubject(row);
    }

    @Override
    public BHalign getColumnAlignment(int col) {
        return this.root.getColumnAlignment(this.toRootColumnIndex(col));
    }

    @Override
    public boolean isColumnSortable(int col) {
        return this.root.isColumnSortable(this.toRootColumnIndex(col));
    }

    @Override
    public void sortByColumn(int col, boolean ascending) {
        this.root.sortByColumn(this.toRootColumnIndex(col), ascending);
    }

    public int getRootColumnCount() {
        return this.root.getColumnCount();
    }

    public String getRootColumnName(int rootCol) {
        return this.root.getColumnName(rootCol);
    }

    public int toRootColumnIndex(int showCol) {
        if (showCol < 0) {
            return showCol;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.toRootMap[showCol];
    }

    public int fromRootColumnIndex(int rootCol) {
        if (rootCol < 0) {
            return rootCol;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.fromRootMap[rootCol];
    }

    public boolean showColumn(int rootCol) {
        return this.showCols.get(rootCol);
    }

    public void setShowColumn(int rootCol, boolean show) {
        if (!this.showable.get(rootCol)) {
            return;
        }
        BTable table = this.getTable();
        if (this.showCols.get(rootCol) != show) {
            int sortCol = -1;
            boolean sortAscending = true;
            if (table != null) {
                this.toRootColumnIndex(table.getSortColumn());
                sortAscending = table.isSortAscending();
            }
            DynamicTableModel.set(this.showCols, rootCol, show);
            this.columnsModified();
            if (table != null) {
                this.getTable().sizeColumnsToFit();
            }
            if (table != null) {
                int relSortCol;
                table.sortByColumn(-1, sortAscending);
                if (sortCol >= 0 && this.showColumn(sortCol) && (relSortCol = this.fromRootColumnIndex(sortCol)) >= 0 && this.root.isColumnSortable(relSortCol)) {
                    table.sortByColumn(relSortCol, sortAscending);
                }
            }
        }
    }

    public void columnsModified() {
        int count = this.getRootColumnCount();
        int showCount = 0;
        int[] toRootMap = new int[count];
        int[] fromRootMap = new int[count];
        for (int i = 0; i < count; ++i) {
            if (this.showColumn(i)) {
                toRootMap[showCount++] = i;
                fromRootMap[i] = showCount - 1;
                continue;
            }
            fromRootMap[i] = -1;
        }
        this.showCount = showCount;
        this.toRootMap = toRootMap;
        this.fromRootMap = fromRootMap;
    }

    public void setColumnShowable(int rootCol, boolean show) {
        DynamicTableModel.set(this.showable, rootCol, show);
    }

    public boolean isColumnShowable(int rootCol) {
        return this.showable.get(rootCol);
    }

    @Override
    public BObject export(int row, int col) {
        return this.root.export(row, this.toRootColumnIndex(col));
    }

    static void set(BitSet bits, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            bits.set(i);
        }
    }

    static void set(BitSet bits, int index, boolean bit) {
        if (bit) {
            bits.set(index);
        } else {
            bits.clear(index);
        }
    }
}

