/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.shape;

import com.tridium.ui.ShellManager;
import javax.baja.gx.BBrush;
import javax.baja.gx.BGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public abstract class BShape
extends BWidget {
    public static final Property fill = BShape.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property stroke = BShape.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property pen = BShape.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BShape.class);
    private static final BIcon icon = BIcon.std((String)"widgets/shape.png");

    public BBrush getFill() {
        return (BBrush)this.get(fill);
    }

    public void setFill(BBrush v) {
        this.set(fill, (BValue)v, null);
    }

    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    public void setStroke(BBrush v) {
        this.set(stroke, (BValue)v, null);
    }

    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BShape(BGeom geom, BBrush fill, BBrush stroke, BPen pen) {
        this.setShapeGeom(geom);
        this.setFill(fill);
        this.setStroke(stroke);
        this.setPen(pen);
    }

    protected BShape(BGeom geom) {
        this.setShapeGeom(geom);
    }

    protected BShape() {
    }

    public abstract BGeom getShapeGeom();

    public abstract void setShapeGeom(BGeom var1);

    @Override
    public boolean receiveInputEvents() {
        return this.hasBindings();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getShapeGeom().contains(x, y);
    }

    @Override
    public void paint(Graphics g) {
        boolean forceStroke = false;
        BGeom geom = this.getShapeGeom();
        BBrush fill = this.getFill();
        if (!fill.isNull()) {
            g.setBrush(fill);
            g.fill((IGeom)geom);
        }
        BBrush stroke = this.getStroke();
        if (fill.isNull() && stroke.isNull()) {
            ShellManager manager = this.getShellManager();
            boolean bl = forceStroke = manager != null && manager.paintTranslucentShapes();
        }
        if (!stroke.isNull() || forceStroke) {
            g.setBrush(stroke);
            g.setPen(this.getPen());
            g.stroke((IGeom)geom);
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

