/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class PxDecoder
extends XParser {
    protected String[] modules;
    protected PxProperty[] props;
    protected PxLayer[] layers;
    protected HashMap<String, TypeInfo> types = new HashMap();
    protected BOrd baseOrd;
    protected TypeInfo media;
    protected Context cx;
    protected Logger log = Logger.getLogger("px.decode");

    public PxDecoder(BIFile file) throws Exception {
        this(file, null);
    }

    public PxDecoder(BIFile file, Context cx) throws Exception {
        this(file.getAbsoluteOrd(), new BufferedInputStream(file.getInputStream()), cx);
    }

    public PxDecoder(BOrd baseOrd, InputStream in) throws Exception {
        this(baseOrd, in, null);
    }

    public PxDecoder(BOrd baseOrd, InputStream in, Context cx) throws Exception {
        super(in);
        this.baseOrd = baseOrd;
        this.cx = cx;
    }

    public BWidget decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWidget decodeDocument(boolean close) throws Exception {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Starting decode of px file " + this.baseOrd);
        }
        long start = System.currentTimeMillis();
        try {
            XElem root = this.parse();
            this.decodeHeader(root);
            this.decodeImport(root);
            this.decodeLayers(root);
            BWidget rootWidget = this.decodeContent(root);
            this.decodeProperties(root, rootWidget);
            BWidget bWidget = rootWidget;
            return bWidget;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Decoded " + this.baseOrd + " in " + (end - start) + "ms");
            }
            if (close) {
                this.close();
            }
        }
    }

    public TypeInfo getMedia() {
        return this.media;
    }

    public String[] getModules() {
        return this.modules;
    }

    protected void decodeHeader(XElem root) throws Exception {
        if (!root.name().equals("px")) {
            throw this.err("Root element must be \"px\"", root);
        }
        String ver = root.get("version");
        if (!ver.equals("1.0")) {
            throw this.err("Only version 1.0 is supported", root);
        }
        String media = root.get("media", null);
        if (media != null) {
            try {
                this.media = Sys.getRegistry().getType(media);
            }
            catch (TypeNotFoundException e) {
                this.warning("Media not found: " + media, root);
            }
        }
    }

    protected void decodeImport(XElem root) throws Exception {
        XElem elem = root.elem("import");
        if (elem == null) {
            throw this.err("Missing <import> element", root);
        }
        XElem[] moduleElems = elem.elems("module");
        this.modules = new String[moduleElems.length];
        for (int i = 0; i < moduleElems.length; ++i) {
            this.modules[i] = moduleElems[i].get("name");
        }
    }

    private void decodeProperties(XElem root, BWidget rootWidget) throws Exception {
        XElem elem = root.elem("properties");
        if (elem == null) {
            this.props = new PxProperty[0];
            return;
        }
        XElem[] propElems = elem.elems("property");
        this.props = new PxProperty[propElems.length];
        for (int i = 0; i < propElems.length; ++i) {
            String name = propElems[i].get("name");
            BTypeSpec type = BTypeSpec.make((String)propElems[i].get("type"));
            BSimple value = this.decodeSimple((BValue)type.getResolvedType().getInstance(), propElems[i].get("value"));
            XElem[] targElems = propElems[i].elems("target");
            SlotPath[] targets = new SlotPath[targElems.length];
            for (int j = 0; j < targElems.length; ++j) {
                String path = targElems[j].get("ord");
                targets[j] = new SlotPath(path.substring("slot:".length()));
            }
            this.props[i] = new PxProperty(name, type, (BValue)value, targets);
        }
    }

    protected void decodeLayers(XElem root) throws Exception {
        XElem layRoot = root.elem("layers");
        if (layRoot == null) {
            this.layers = new PxLayer[0];
            return;
        }
        XElem[] elems = layRoot.elems("layer");
        this.layers = new PxLayer[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            String name = elems[i].get("name");
            BLayerStatus status = BLayerStatus.make(elems[i].get("status"));
            this.layers[i] = new PxLayer(name, status);
        }
    }

    private BWidget decodeContent(XElem root) throws Exception {
        XElem widgetElem = this.getContentElem(root);
        BValue value = this.decodeFromElem(widgetElem);
        if (value == null || value instanceof BWidget) {
            return (BWidget)value;
        }
        throw this.err("Content type " + value.getType() + " is not a Widget", widgetElem);
    }

    protected XElem getContentElem(XElem root) {
        XElem elem = root.elem("content");
        if (elem == null) {
            throw this.err("Missing <content> element", root);
        }
        XElem[] subElems = elem.elems();
        if (subElems.length != 1) {
            throw this.err("There must be exactly one child element under <content>", elem);
        }
        return subElems[0];
    }

    private BValue decodeFromElem(XElem x) throws Exception {
        TypeInfo type = this.toType(x);
        BValue value = null;
        try {
            value = (BValue)type.getInstance();
            if (value instanceof BPxInclude) {
                value.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
            }
        }
        catch (Throwable e) {
            throw this.err("Cannot create instance of " + type, x, e);
        }
        if (value instanceof BSimple) {
            String string = x.get("value");
            value = this.decodeSimple(value, string);
        } else {
            this.decodeProps(x, (BComplex)value);
        }
        return value;
    }

    private void decodeProps(XElem x, BComplex c) throws Exception {
        String type = c.getType().getTypeName();
        for (int i = 0; i < x.attrSize(); ++i) {
            String name = x.attrName(i);
            try {
                Property prop = c.getProperty(name);
                if (prop == null) {
                    if (!name.equals("h") || !c.isComponent()) continue;
                    ((ComponentSlotMap)c.fw(1)).setHandle((Object)x.attrValue(i));
                    continue;
                }
                BValue value = c.get(prop);
                if (!value.isSimple()) {
                    throw this.err("Expecting simple prop: " + name, x);
                }
                value = this.decodeSimple(value, x.attrValue(i));
                c.set(prop, value);
                continue;
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.err("Cannot decode " + type + "." + name, x, e);
            }
        }
        XElem[] kids = x.elems();
        for (int i = 0; i < kids.length; ++i) {
            XElem kid = kids[i];
            String name = kid.get("name", null);
            BValue value = this.decodeFromElem(kid);
            try {
                if (name != null && c.getProperty(name) != null) {
                    c.set(name, value);
                } else {
                    c.asComponent().add(name, value);
                }
                String flags = kid.get("f", null);
                String facets = kid.get("ft", null);
                if (flags != null) {
                    c.setFlags((Slot)c.getProperty(name), Flags.decodeFromString((String)flags));
                }
                if (facets == null || facets.isEmpty()) continue;
                c.setFacets((Slot)c.getProperty(name), (BFacets)BFacets.DEFAULT.decodeFromString(facets));
                continue;
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.err("Cannot decode " + type + "." + name, kid, e);
            }
        }
    }

    protected TypeInfo toType(XElem x) {
        String typeName = x.name();
        TypeInfo type = this.types.get(typeName);
        if (type != null) {
            return type;
        }
        for (int i = 0; i < this.modules.length; ++i) {
            try {
                type = Sys.getRegistry().getType(this.modules[i] + ":" + typeName);
                this.types.put(typeName, type);
                return type;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw this.err("Unknown type " + typeName, x);
    }

    private BSimple decodeSimple(BValue proto, String str) throws Exception {
        BSimple val = (BSimple)((BSimple)proto).decodeFromString(str);
        val.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
        return val;
    }

    private void loadBrush(BBrush brush) {
        BBrush.Paint p = brush.getPaint();
        if (p instanceof BBrush.Image) {
            BImage img = ((BBrush.Image)p).getImage();
            img.setBaseOrd(this.baseOrd);
        }
    }

    protected XException err(String msg, XElem elem, Throwable cause) {
        return new XException(msg, elem, cause);
    }

    protected XException err(String msg, XElem elem) {
        return new XException(msg, elem);
    }

    protected void warning(String msg, XElem elem) {
        String line = "";
        if (elem != null) {
            line = " [line " + elem.line() + "]";
        }
        System.out.println("WARNING: " + msg + line);
    }

    public PxProperty[] getPxProperties() {
        return (PxProperty[])new Array((Object[])this.props).trim();
    }

    public PxLayer[] getPxLayers() {
        return (PxLayer[])new Array((Object[])this.layers).trim();
    }
}

